/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public record ArtifactBossImmunityParticleOptions(ParticleType<ArtifactBossImmunityParticleOptions> particleType, int lifetime, Vector3f color, Vector3f color2) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<ArtifactBossImmunityParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<ArtifactBossImmunityParticleOptions>(){

        @Nonnull
        @ParametersAreNonnullByDefault
        public ArtifactBossImmunityParticleOptions fromCommand(ParticleType<ArtifactBossImmunityParticleOptions> particleType, StringReader reader) throws CommandSyntaxException {
            return new ArtifactBossImmunityParticleOptions(particleType, reader.readInt(), ArtifactBossImmunityParticleOptions.readVector3f(reader), ArtifactBossImmunityParticleOptions.readVector3f(reader));
        }

        @Nonnull
        @ParametersAreNonnullByDefault
        public ArtifactBossImmunityParticleOptions fromNetwork(ParticleType<ArtifactBossImmunityParticleOptions> particleType, FriendlyByteBuf buffer) {
            return new ArtifactBossImmunityParticleOptions(particleType, buffer.readInt(), new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()), new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()));
        }
    };

    public static Codec<ArtifactBossImmunityParticleOptions> codec(ParticleType<ArtifactBossImmunityParticleOptions> particleType) {
        return RecordCodecBuilder.create(c -> c.group((App)Codec.INT.fieldOf("lifetime").forGetter(data -> data.lifetime), (App)Vector3f.f_176762_.fieldOf("color").forGetter(data -> data.color), (App)Vector3f.f_176762_.fieldOf("color").forGetter(data -> data.color)).apply((Applicative)c, (range, color, color2) -> new ArtifactBossImmunityParticleOptions(particleType, (int)range, (Vector3f)color, (Vector3f)color2)));
    }

    @Nonnull
    public ParticleType<ArtifactBossImmunityParticleOptions> m_6012_() {
        return this.particleType;
    }

    public void m_7711_(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeFloat((float)this.lifetime);
        buffer.writeFloat(this.color.m_122239_());
        buffer.writeFloat(this.color.m_122260_());
        buffer.writeFloat(this.color.m_122269_());
        buffer.writeFloat(this.color2.m_122239_());
        buffer.writeFloat(this.color2.m_122260_());
        buffer.writeFloat(this.color2.m_122269_());
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %.2f %.2f %.2f %.2f %.2f %.2f", this.m_6012_().getRegistryName(), this.lifetime, Float.valueOf(this.color.m_122239_()), Float.valueOf(this.color.m_122260_()), Float.valueOf(this.color.m_122269_()), Float.valueOf(this.color2.m_122239_()), Float.valueOf(this.color2.m_122260_()), Float.valueOf(this.color2.m_122269_()));
    }

    private static Vector3f readVector3f(StringReader stringReader) throws CommandSyntaxException {
        stringReader.expect(' ');
        float f0 = stringReader.readFloat();
        stringReader.expect(' ');
        float f1 = stringReader.readFloat();
        stringReader.expect(' ');
        float f2 = stringReader.readFloat();
        return new Vector3f(f0, f1, f2);
    }
}

