/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public record ColoredParticleOptions(ParticleType<ColoredParticleOptions> particleType, Vector3f color) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<ColoredParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<ColoredParticleOptions>(){

        @Nonnull
        @ParametersAreNonnullByDefault
        public ColoredParticleOptions fromCommand(ParticleType<ColoredParticleOptions> particleType, StringReader reader) throws CommandSyntaxException {
            return new ColoredParticleOptions(particleType, ColoredParticleOptions.readVector3f(reader));
        }

        @Nonnull
        @ParametersAreNonnullByDefault
        public ColoredParticleOptions fromNetwork(ParticleType<ColoredParticleOptions> particleType, FriendlyByteBuf buffer) {
            return new ColoredParticleOptions(particleType, new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()));
        }
    };

    public static Codec<ColoredParticleOptions> codec(ParticleType<ColoredParticleOptions> particleType) {
        return RecordCodecBuilder.create(c -> c.group((App)Vector3f.f_176762_.fieldOf("color").forGetter(data -> data.color)).apply((Applicative)c, color -> new ColoredParticleOptions(particleType, (Vector3f)color)));
    }

    @Nonnull
    public ParticleType<ColoredParticleOptions> m_6012_() {
        return this.particleType;
    }

    public void m_7711_(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeFloat(this.color.m_122239_());
        buffer.writeFloat(this.color.m_122260_());
        buffer.writeFloat(this.color.m_122269_());
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", this.m_6012_().getRegistryName(), Float.valueOf(this.color.m_122239_()), Float.valueOf(this.color.m_122260_()), Float.valueOf(this.color.m_122269_()));
    }

    private static Vector3f readVector3f(StringReader stringReader) throws CommandSyntaxException {
        stringReader.expect(' ');
        float f0 = stringReader.readFloat();
        stringReader.expect(' ');
        float f1 = stringReader.readFloat();
        stringReader.expect(' ');
        float f2 = stringReader.readFloat();
        return new Vector3f(f0, f1, f2);
    }
}

