/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.particles;

import iskallia.vault.client.particles.SphericalParticleOptions;
import iskallia.vault.util.MathUtilities;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GrowingSphereParticle
extends SimpleAnimatedParticle {
    private static final float ROTATION_SPEED = 0.0125f;
    private float rotationSpeed;
    private final double xOrigin;
    private final double yOrigin;
    private final double yOffset;
    private final double zOrigin;
    private final float orbitRadius;
    private float orbitAngleRadians;

    protected GrowingSphereParticle(ClientLevel clientLevel, double xPosition, double yPosition, double zPosition, double xOrigin, double yOrigin, double zOrigin, float orbitRadius, float orbitAngleRadians, SpriteSet spriteSet) {
        super(clientLevel, xOrigin, yOrigin, zOrigin, spriteSet, 0.0f);
        this.xOrigin = xOrigin;
        this.yOrigin = yOrigin;
        this.zOrigin = zOrigin;
        this.orbitRadius = orbitRadius;
        this.f_107219_ = false;
        this.orbitAngleRadians = orbitAngleRadians;
        this.yOffset = yPosition - this.yOrigin;
        this.f_107212_ = this.xOrigin;
        this.f_107213_ = this.yOrigin;
        this.f_107214_ = this.zOrigin;
        this.f_107209_ = this.xOrigin;
        this.f_107210_ = this.yOrigin;
        this.f_107211_ = this.zOrigin;
        this.f_107230_ = 1.0f;
    }

    public void setRotationSpeed(float rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.orbitAngleRadians += this.rotationSpeed;
        this.f_107230_ = (float)(this.f_107225_ - this.f_107224_) / (float)this.f_107225_;
        float radius = Math.min(1.0f, (float)(this.f_107224_ + this.f_107224_) / (float)this.f_107225_);
        this.m_107264_(this.xOrigin + Math.cos(this.orbitAngleRadians) * (double)this.orbitRadius * (double)radius, this.yOrigin + this.yOffset * (double)radius, this.zOrigin + Math.sin(this.orbitAngleRadians) * (double)this.orbitRadius * (double)radius);
    }

    public boolean shouldCull() {
        return false;
    }

    public int m_6355_(float pPartialTick) {
        return 240;
    }

    public static class SphereProvider
    implements ParticleProvider<SphericalParticleOptions> {
        private static final Random RANDOM = new Random();
        private final SpriteSet sprites;
        private final float orbitSpeed;
        private final int durationTicks;
        private final float scale;

        public SphereProvider(SpriteSet pSprites, float orbitSpeed, int durationTicks, float scale) {
            this.sprites = pSprites;
            this.orbitSpeed = orbitSpeed;
            this.durationTicks = durationTicks;
            this.scale = scale;
        }

        @Nullable
        public Particle createParticle(SphericalParticleOptions data, @Nonnull ClientLevel level, double xOrigin, double yOrigin, double zOrigin, double xSpeed, double ySpeed, double zSpeed) {
            Vec3 position = MathUtilities.getRandomPointOnSphere(xOrigin, yOrigin, zOrigin, data.range(), RANDOM);
            float orbitRadius = (float)MathUtilities.getDistance(position.f_82479_, position.f_82481_, xOrigin, zOrigin);
            float orbitAngleRadians = (float)Math.atan2(position.f_82479_ - xOrigin, position.f_82481_ - zOrigin);
            GrowingSphereParticle particle = new GrowingSphereParticle(level, position.f_82479_, position.f_82480_, position.f_82481_, xOrigin, yOrigin, zOrigin, orbitRadius, orbitAngleRadians, this.sprites);
            particle.m_108335_(this.sprites);
            particle.m_107253_(data.color().m_122239_(), data.color().m_122260_(), data.color().m_122269_());
            particle.m_6569_(this.scale);
            particle.m_107257_(this.durationTicks);
            particle.setRotationSpeed((0.0125f + Mth.m_144924_((Random)RANDOM, (float)-0.01f, (float)0.01f)) * this.orbitSpeed);
            return particle;
        }
    }
}

