/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.particles;

import iskallia.vault.client.particles.NovaSpeedParticle;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NovaDotParticle
extends TextureSheetParticle {
    private static final Random RANDOM = new Random();
    private final SpriteSet sprites;

    NovaDotParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet pSprites) {
        super(pLevel, pX, pY, pZ, 0.5 - RANDOM.nextDouble(), pYSpeed, 0.5 - RANDOM.nextDouble());
        this.f_172258_ = 0.96f;
        this.f_107226_ = -0.1f;
        this.f_172259_ = true;
        this.sprites = pSprites;
        this.f_107216_ *= (double)0.2f;
        if (pXSpeed == 0.0 && pZSpeed == 0.0) {
            this.f_107215_ *= (double)0.1f;
            this.f_107217_ *= (double)0.1f;
        }
        this.f_107663_ *= 0.75f;
        this.f_107225_ = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.f_107219_ = false;
        this.m_108339_(pSprites);
        if (this.isCloseToScopingPlayer()) {
            this.m_107271_(0.0f);
        }
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
        if (this.isCloseToScopingPlayer()) {
            this.m_107271_(0.0f);
        } else {
            this.m_107271_(Mth.m_14179_((float)0.05f, (float)this.f_107230_, (float)1.0f));
        }
    }

    private boolean isCloseToScopingPlayer() {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localPlayer = minecraft.f_91074_;
        return localPlayer != null && localPlayer.m_146892_().m_82531_(this.f_107212_, this.f_107213_, this.f_107214_) <= 9.0 && minecraft.f_91066_.m_92176_().m_90612_() && localPlayer.m_150108_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new NovaSpeedParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, this.sprites);
        }
    }
}

