/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public record SphericalParticleOptions(ParticleType<SphericalParticleOptions> particleType, float range, Vector3f color) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<SphericalParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<SphericalParticleOptions>(){

        @Nonnull
        @ParametersAreNonnullByDefault
        public SphericalParticleOptions fromCommand(ParticleType<SphericalParticleOptions> particleType, StringReader reader) throws CommandSyntaxException {
            return new SphericalParticleOptions(particleType, reader.readFloat(), SphericalParticleOptions.readVector3f(reader));
        }

        @Nonnull
        @ParametersAreNonnullByDefault
        public SphericalParticleOptions fromNetwork(ParticleType<SphericalParticleOptions> particleType, FriendlyByteBuf buffer) {
            return new SphericalParticleOptions(particleType, buffer.readFloat(), new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()));
        }
    };

    public static Codec<SphericalParticleOptions> codec(ParticleType<SphericalParticleOptions> particleType) {
        return RecordCodecBuilder.create(c -> c.group((App)Codec.FLOAT.fieldOf("range").forGetter(data -> Float.valueOf(data.range)), (App)Vector3f.f_176762_.fieldOf("color").forGetter(data -> data.color)).apply((Applicative)c, (range, color) -> new SphericalParticleOptions(particleType, range.floatValue(), (Vector3f)color)));
    }

    @Nonnull
    public ParticleType<SphericalParticleOptions> m_6012_() {
        return this.particleType;
    }

    public void m_7711_(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeFloat(this.range);
        buffer.writeFloat(this.color.m_122239_());
        buffer.writeFloat(this.color.m_122260_());
        buffer.writeFloat(this.color.m_122269_());
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f", this.m_6012_().getRegistryName(), Float.valueOf(this.range), Float.valueOf(this.color.m_122239_()), Float.valueOf(this.color.m_122260_()), Float.valueOf(this.color.m_122269_()));
    }

    private static Vector3f readVector3f(StringReader stringReader) throws CommandSyntaxException {
        stringReader.expect(' ');
        float f0 = stringReader.readFloat();
        stringReader.expect(' ');
        float f1 = stringReader.readFloat();
        stringReader.expect(' ');
        float f2 = stringReader.readFloat();
        return new Vector3f(f0, f1, f2);
    }
}

