/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.particles;

import iskallia.vault.block.StabilizerBlock;
import iskallia.vault.block.entity.StabilizerTileEntity;
import iskallia.vault.client.particles.BaseFloatingCubeParticle;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StabilizerCubeParticle
extends BaseFloatingCubeParticle {
    private final BlockPos originPos;

    private StabilizerCubeParticle(ClientLevel world, SpriteSet spriteSet, double x, double y, double z) {
        super(world, spriteSet, x, y, z);
        this.originPos = new BlockPos(x, y, z);
    }

    @Override
    protected boolean isValid() {
        return this.getTileRef() != null;
    }

    @Override
    protected boolean isActive() {
        StabilizerTileEntity tile = this.getTileRef();
        return tile != null && tile.isActive();
    }

    @Nullable
    private StabilizerTileEntity getTileRef() {
        BlockState at = this.f_107208_.m_8055_(this.originPos);
        if (!(at.m_60734_() instanceof StabilizerBlock)) {
            return null;
        }
        BlockEntity tile = this.f_107208_.m_7702_(this.originPos);
        if (tile instanceof StabilizerTileEntity) {
            return (StabilizerTileEntity)tile;
        }
        return null;
    }

    @Override
    protected int getActiveColor() {
        return 301982;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new StabilizerCubeParticle(worldIn, this.spriteSet, x, y, z);
        }
    }
}

