/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import iskallia.vault.mixin.AccessorBakedOverride;
import java.lang.reflect.Type;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BuiltInModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InjectDifferentShieldTransforms {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).registerTypeAdapter(ShieldTransforms.class, (Object)new Deserializer()).create();
    private static final String SHIELD_TRANSFORMS_JSON = "{\"thirdperson_righthand\":{\"rotation\":[0,90,0],\"translation\":[10,6,-4],\"scale\":[1,1,1]},\"thirdperson_lefthand\":{\"rotation\":[0,90,0],\"translation\":[10,6,12],\"scale\":[1,1,1]},\"firstperson_righthand\":{\"rotation\":[0,180,5],\"translation\":[-10,-0.75,-10],\"scale\":[1.25,1.25,1.25]},\"firstperson_lefthand\":{\"rotation\":[0,180,5],\"translation\":[10,-2.5,-10],\"scale\":[1.25,1.25,1.25]},\"gui\":{\"rotation\":[15,-25,-5],\"translation\":[2,3,0],\"scale\":[0.65,0.65,0.65]},\"fixed\":{\"rotation\":[0,180,0],\"translation\":[-2,4,-5],\"scale\":[0.5,0.5,0.5]},\"ground\":{\"rotation\":[0,0,0],\"translation\":[4,4,2],\"scale\":[0.25,0.25,0.25]}}";
    private static final String SHIELD_BLOCK_TRANSFORMS_JSON = "{\"thirdperson_righthand\":{\"rotation\":[45,135,0],\"translation\":[3.51,11,-2],\"scale\":[1,1,1]},\"thirdperson_lefthand\":{\"rotation\":[45,135,0],\"translation\":[13.51,3,5],\"scale\":[1,1,1]},\"firstperson_righthand\":{\"rotation\":[0,180,-5],\"translation\":[-15,1.25,-11],\"scale\":[1.25,1.25,1.25]},\"firstperson_lefthand\":{\"rotation\":[0,180,-5],\"translation\":[5,3,-11],\"scale\":[1.25,1.25,1.25]},\"gui\":{\"rotation\":[15,-25,-5],\"translation\":[2,3,0],\"scale\":[0.65,0.65,0.65]}}";

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ModelResourceLocation mrl;
        ModelManager itemModelManager = Minecraft.m_91087_().m_91291_().m_115103_().m_109393_();
        BakedModel shieldModel = itemModelManager.m_119422_(mrl = new ModelResourceLocation("shield#inventory"));
        if (shieldModel instanceof BuiltInModel) {
            BuiltInModel model = (BuiltInModel)shieldModel;
            if (!(shieldModel.m_7442_() instanceof ShieldTransforms)) {
                model.f_119167_ = (ItemTransforms)GSON.fromJson(SHIELD_TRANSFORMS_JSON, ShieldTransforms.class);
            }
            ItemOverrides overrides = shieldModel.m_7343_();
            for (ItemOverrides.BakedOverride override : overrides.f_111735_) {
                AccessorBakedOverride accessorOverride;
                BakedModel shieldOverrideModel;
                if (!(override instanceof AccessorBakedOverride) || (shieldOverrideModel = (accessorOverride = (AccessorBakedOverride)override).getModel()).m_7442_() instanceof ShieldTransforms || !(shieldOverrideModel instanceof BuiltInModel)) continue;
                BuiltInModel overrideModel = (BuiltInModel)shieldOverrideModel;
                overrideModel.f_119167_ = (ItemTransforms)GSON.fromJson(SHIELD_BLOCK_TRANSFORMS_JSON, ShieldTransforms.class);
            }
        }
    }

    public static class ShieldTransforms
    extends ItemTransforms {
        public ShieldTransforms(ItemTransform p_111798_, ItemTransform p_111799_, ItemTransform p_111800_, ItemTransform p_111801_, ItemTransform p_111802_, ItemTransform p_111803_, ItemTransform p_111804_, ItemTransform p_111805_, ImmutableMap<ItemTransforms.TransformType, ItemTransform> moddedTransforms) {
            super(p_111798_, p_111799_, p_111800_, p_111801_, p_111802_, p_111803_, p_111804_, p_111805_, moddedTransforms);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<ShieldTransforms> {
        public ShieldTransforms deserialize(JsonElement pJson, Type pType, JsonDeserializationContext pContext) throws JsonParseException {
            JsonObject jsonobject = pJson.getAsJsonObject();
            ItemTransform itemtransform = this.getTransform(pContext, jsonobject, "thirdperson_righthand");
            ItemTransform itemtransform1 = this.getTransform(pContext, jsonobject, "thirdperson_lefthand");
            if (itemtransform1 == ItemTransform.f_111754_) {
                itemtransform1 = itemtransform;
            }
            ItemTransform itemtransform2 = this.getTransform(pContext, jsonobject, "firstperson_righthand");
            ItemTransform itemtransform3 = this.getTransform(pContext, jsonobject, "firstperson_lefthand");
            if (itemtransform3 == ItemTransform.f_111754_) {
                itemtransform3 = itemtransform2;
            }
            ItemTransform itemtransform4 = this.getTransform(pContext, jsonobject, "head");
            ItemTransform itemtransform5 = this.getTransform(pContext, jsonobject, "gui");
            ItemTransform itemtransform6 = this.getTransform(pContext, jsonobject, "ground");
            ItemTransform itemtransform7 = this.getTransform(pContext, jsonobject, "fixed");
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ItemTransforms.TransformType type : ItemTransforms.TransformType.values()) {
                ItemTransform transform;
                if (!type.isModded() || (transform = this.getTransform(pContext, jsonobject, type.getSerializeName())) == ItemTransform.f_111754_) continue;
                builder.put((Object)type, (Object)transform);
            }
            return new ShieldTransforms(itemtransform1, itemtransform, itemtransform3, itemtransform2, itemtransform4, itemtransform5, itemtransform6, itemtransform7, (ImmutableMap<ItemTransforms.TransformType, ItemTransform>)builder.build());
        }

        private ItemTransform getTransform(JsonDeserializationContext pContext, JsonObject pJson, String pName) {
            return pJson.has(pName) ? (ItemTransform)pContext.deserialize(pJson.get(pName), ItemTransform.class) : ItemTransform.f_111754_;
        }
    }
}

