/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;

public final class LineRenderUtil {
    private static final LineRenderUtil INSTANCE = new LineRenderUtil();
    private final LineVector startLinePoint = new LineVector();
    private final LineVector endLinePoint = new LineVector();
    private final LineVector lineVector = new LineVector();
    private final LineVector perpendicularVector = new LineVector();
    private final LineVector quadPoint0 = new LineVector();
    private final LineVector quadPoint1 = new LineVector();
    private final LineVector quadPoint2 = new LineVector();
    private final LineVector quadPoint3 = new LineVector();

    public static LineRenderUtil getInstance() {
        return INSTANCE;
    }

    public void drawLine(VertexConsumer vertexConsumer, PoseStack poseStack, double x0, double y0, double x1, double y1, double width, int color) {
        Matrix4f offset = poseStack.m_85850_().m_85861_();
        this.startLinePoint.set(x0, y0);
        this.endLinePoint.set(x1, y1);
        this.lineVector.set(this.endLinePoint).subtract(this.startLinePoint).normalize();
        this.perpendicularVector.set(-this.lineVector.y, this.lineVector.x);
        this.quadPoint0.set(this.perpendicularVector).scale(width).negate().add(this.startLinePoint);
        this.quadPoint1.set(this.perpendicularVector).scale(width).negate().add(this.endLinePoint);
        this.quadPoint2.set(this.perpendicularVector).scale(width).add(this.endLinePoint);
        this.quadPoint3.set(this.perpendicularVector).scale(width).add(this.startLinePoint);
        vertexConsumer.m_85982_(offset, (float)this.quadPoint3.x, (float)this.quadPoint3.y, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255).m_5752_();
        vertexConsumer.m_85982_(offset, (float)this.quadPoint2.x, (float)this.quadPoint2.y, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255).m_5752_();
        vertexConsumer.m_85982_(offset, (float)this.quadPoint1.x, (float)this.quadPoint1.y, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255).m_5752_();
        vertexConsumer.m_85982_(offset, (float)this.quadPoint0.x, (float)this.quadPoint0.y, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255).m_5752_();
    }

    private LineRenderUtil() {
    }

    private static class LineVector {
        private static final float EPSILON = 1.0E-4f;
        double x;
        double y;

        private LineVector() {
        }

        public LineVector set(double x, double y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public LineVector set(LineVector lineVector) {
            return this.set(lineVector.x, lineVector.y);
        }

        public LineVector add(LineVector lineVector) {
            return this.set(this.x + lineVector.x, this.y + lineVector.y);
        }

        public LineVector subtract(LineVector lineVector) {
            return this.set(this.x - lineVector.x, this.y - lineVector.y);
        }

        public LineVector negate() {
            return this.set(-this.x, -this.y);
        }

        public LineVector scale(double value) {
            return this.set(this.x * value, this.y * value);
        }

        public LineVector normalize() {
            double f = Math.sqrt(this.x * this.x + this.y * this.y);
            return f < (double)1.0E-4f ? this.set(0.0, 0.0) : this.set(this.x / f, this.y / f);
        }
    }
}

