/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import iskallia.vault.command.Command;
import iskallia.vault.world.VaultDifficulty;
import iskallia.vault.world.data.WorldSettings;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class DifficultyCommand
extends Command {
    private static final String COMMANDS_PREFIX = "commands.";
    private static final DynamicCommandExceptionType ERROR_ALREADY_DIFFICULT = new DynamicCommandExceptionType(vaultDifficulty -> new TranslatableComponent("commands.the_vault.difficulty.failure", new Object[]{vaultDifficulty}));

    @Override
    public String getName() {
        return "difficulty";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        for (VaultDifficulty vaultDifficulty : VaultDifficulty.values()) {
            builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)vaultDifficulty.getKey()).requires(s -> s.m_6761_(2))).executes(ctx -> DifficultyCommand.setDifficulty((CommandSourceStack)ctx.getSource(), vaultDifficulty)));
        }
        builder.executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            VaultDifficulty vaultDifficulty = WorldSettings.get((Level)player.m_183503_()).getGlobalVaultDifficulty();
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.the_vault.difficulty.query", new Object[]{vaultDifficulty.getDisplayName()}), false);
            return vaultDifficulty.getId();
        });
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    public static int setDifficulty(CommandSourceStack source, VaultDifficulty vaultDifficulty) throws CommandSyntaxException {
        WorldSettings worldSettings = WorldSettings.get((Level)source.m_81372_());
        if (worldSettings.getGlobalVaultDifficulty() == vaultDifficulty) {
            throw ERROR_ALREADY_DIFFICULT.create((Object)vaultDifficulty.getKey());
        }
        worldSettings.setGlobalVaultDifficulty(vaultDifficulty);
        source.m_81354_((Component)new TranslatableComponent("commands.the_vault.difficulty.success", new Object[]{vaultDifficulty.getDisplayName()}), true);
        return 0;
    }
}

