/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.config.gear.VaultGearTagConfig;
import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class GearDebugCommand
extends Command {
    private static final Random rand = new Random();

    @Override
    public String getName() {
        return "gear_debug";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"setLevel").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(this::setLevel)));
        builder.then(Commands.m_82127_((String)"rollType").then(Commands.m_82129_((String)"rollType", (ArgumentType)StringArgumentType.string()).executes(this::setRollType)));
        builder.then(Commands.m_82127_((String)"addModifier").executes(this::addModifier));
        builder.then(Commands.m_82127_((String)"removeModifier").executes(this::removeModifier));
        builder.then(Commands.m_82127_((String)"rerollAll").executes(this::rerollAllModifiers));
        builder.then(Commands.m_82127_((String)"rerollWithTag").then(Commands.m_82129_((String)"tag", (ArgumentType)StringArgumentType.string()).executes(this::rerollAllModifiersWithTag)));
        builder.then(Commands.m_82127_((String)"unpack").executes(this::unpackGearData));
        builder.then(Commands.m_82127_((String)"pack").executes(this::packGearData));
    }

    private int packGearData(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = player.m_21205_();
        if (gear.m_41619_() || !AttributeGearData.hasData(gear)) {
            player.m_6352_((Component)new TextComponent("No gear data found on item."), Util.f_137441_);
            return 0;
        }
        CompoundTag tag = gear.m_41784_().m_128469_("nbtGearData");
        ((AttributeGearData)AttributeGearData.fromNbt(gear, tag)).write(gear);
        gear.m_41784_().m_128473_("nbtGearData");
        return 0;
    }

    private int unpackGearData(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = player.m_21205_();
        if (gear.m_41619_() || !AttributeGearData.hasData(gear)) {
            player.m_6352_((Component)new TextComponent("No gear data found on item."), Util.f_137441_);
            return 0;
        }
        CompoundTag data = ((AttributeGearData)AttributeGearData.read(gear)).toNbt();
        gear.m_41784_().m_128365_("nbtGearData", (Tag)data);
        return 0;
    }

    private int rerollAllModifiersWithTag(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = this.getHeldGear(player);
        String tag = StringArgumentType.getString(ctx, (String)"tag");
        VaultGearTagConfig.ModTagGroup groupTag = ModConfigs.VAULT_GEAR_TAG_CONFIG.getGroupTag(tag);
        if (groupTag == null) {
            player.m_6352_((Component)new TextComponent("Could not add modifier of tag " + tag), Util.f_137441_);
            return 0;
        }
        if (!VaultGearModifierHelper.reForgeAllWithTag(groupTag, gear, rand)) {
            player.m_6352_((Component)new TextComponent("Could not add modifier of tag " + tag), Util.f_137441_);
        }
        return 0;
    }

    private int rerollAllModifiers(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = this.getHeldGear(player);
        VaultGearModifierHelper.reForgeAllModifiers(gear, rand);
        return 0;
    }

    private int removeModifier(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = this.getHeldGear(player);
        if (!VaultGearModifierHelper.removeRandomModifier(gear, rand)) {
            player.m_6352_((Component)new TextComponent("No modifiers remaining to remove."), Util.f_137441_);
        }
        return 0;
    }

    private int addModifier(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        long gameTime = player.m_20193_().m_46467_();
        ItemStack gear = this.getHeldGear(player);
        if (!VaultGearModifierHelper.addNewModifier(gear, gameTime, rand)) {
            player.m_6352_((Component)new TextComponent("No empty modifier slots remaining."), Util.f_137441_);
        }
        return 0;
    }

    private int setRollType(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = this.getHeldGear(player);
        String rollType = StringArgumentType.getString(ctx, (String)"rollType");
        if (!ModConfigs.VAULT_GEAR_TYPE_CONFIG.getRollPoolNames().contains(rollType)) {
            player.m_6352_((Component)new TextComponent("Unknown roll type " + rollType), Util.f_137441_);
            player.m_6352_((Component)new TextComponent("Known roll types: " + ModConfigs.VAULT_GEAR_TYPE_CONFIG.getRollPoolNames().toString()), Util.f_137441_);
            return 0;
        }
        VaultGearData data = VaultGearData.read(gear);
        data.updateAttribute(ModGearAttributes.GEAR_ROLL_TYPE, rollType);
        data.write(gear);
        return 0;
    }

    private int setLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = this.getHeldGear(player);
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        VaultGearData data = VaultGearData.read(gear);
        data.setItemLevel(level);
        data.write(gear);
        return 0;
    }

    private ItemStack getHeldGear(ServerPlayer player) {
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!(held.m_41720_() instanceof VaultGearItem)) {
            player.m_6352_((Component)new TextComponent("No vaultgear held in hand"), Util.f_137441_);
            throw new IllegalArgumentException("Not vaultgear in hand");
        }
        return held;
    }
}

