/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.OpenVaultSnapshotMessage;
import iskallia.vault.world.data.VaultSnapshots;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public class OpenVaultSnapshotCommand
extends Command {
    @Override
    public String getName() {
        return "open_snapshot";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"open").then(Commands.m_82129_((String)"target", (ArgumentType)UuidArgument.m_113850_()).then(Commands.m_82129_((String)"asPlayer", (ArgumentType)UuidArgument.m_113850_()).executes(this::open))));
        builder.then(Commands.m_82127_((String)"send").then(Commands.m_82129_((String)"target", (ArgumentType)UuidArgument.m_113850_()).executes(this::send)));
    }

    private int open(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        UUID target = UuidArgument.m_113853_(ctx, (String)"target");
        UUID asPlayer = UuidArgument.m_113853_(ctx, (String)"asPlayer");
        VaultSnapshot snapshot = VaultSnapshots.get(target);
        if (snapshot != null) {
            ModNetwork.CHANNEL.sendTo((Object)new OpenVaultSnapshotMessage.S2C(snapshot, asPlayer), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        return 0;
    }

    private int send(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        UUID target = UuidArgument.m_113853_(ctx, (String)"target");
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        OpenVaultSnapshotCommand.sendCommand(player, target, srv);
        return 0;
    }

    public static void sendCommand(ServerPlayer player, UUID target, MinecraftServer srv) {
        String openSnapshot = "/the_vault open_snapshot open " + target + " " + player.m_142081_();
        String snapshotName = "Vault";
        MutableComponent acceptTxt = new TextComponent(snapshotName).m_130940_(ChatFormatting.AQUA);
        acceptTxt.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to open"))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, openSnapshot)));
        MutableComponent acceptMessage = new TextComponent("").m_7220_((Component)new TextComponent("[").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)acceptTxt).m_7220_((Component)new TextComponent("]").m_130940_(ChatFormatting.GREEN));
        srv.m_6846_().m_11264_((Component)new TranslatableComponent("chat.type.text", new Object[]{player.m_5446_(), acceptMessage}), ChatType.CHAT, Util.f_137441_);
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

