/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import iskallia.vault.command.Command;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class PointsResetCommand
extends Command {
    private static final Map<String, CommandSourceStack> currentlyRunning = new HashMap<String, CommandSourceStack>();

    @Override
    public String getName() {
        return "points_reset";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, suggestionsBuilder) -> SharedSuggestionProvider.m_82970_(List.of("skill", "knowledge", "archetype"), (SuggestionsBuilder)suggestionsBuilder)).executes(this::resetPoints));
    }

    private int resetPoints(CommandContext<CommandSourceStack> context) {
        String type = StringArgumentType.getString(context, (String)"type");
        if (!currentlyRunning.containsKey(type)) {
            currentlyRunning.put(type, (CommandSourceStack)context.getSource());
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("WARNING: THIS CANNOT BE UNDONE! If you are absolutely sure you want to reset " + type.toUpperCase() + " points, click here or run the command again..").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, context.getInput()))), true);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("You have reset " + type + " points").m_130940_(ChatFormatting.GREEN), true);
        currentlyRunning.remove(type);
        return 1;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

