/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.util.NetcodeUtils;
import iskallia.vault.util.PlayerReference;
import iskallia.vault.world.data.PlayerResearchesData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ResearchTeamCommand
extends Command {
    @Override
    public String getName() {
        return "research_team";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"invite").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(this::invite)));
        builder.then(Commands.m_82127_((String)"accept_invite").then(Commands.m_82129_((String)"inviter", (ArgumentType)EntityArgument.m_91466_()).executes(this::accept)));
        builder.then(Commands.m_82127_((String)"leave").executes(this::leave));
        builder.then(Commands.m_82127_((String)"list").executes(this::list));
    }

    private int invite(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        if (player.m_142081_().equals(target.m_142081_())) {
            player.m_6352_((Component)new TextComponent("You can't invite yourself!").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        String playerName = player.m_36316_().getName();
        String targetName = target.m_36316_().getName();
        PlayerResearchesData data = PlayerResearchesData.get(player.m_183503_());
        if (data.isInTeam(target.m_142081_()) || !data.createInvite((Player)player, (Player)target)) {
            boolean inPlayerTeam = data.getTeamMembers(player.m_142081_()).stream().map(PlayerReference::getId).anyMatch(id -> id.equals(target.m_142081_()));
            String teamMsg = " is already part of " + (inPlayerTeam ? "your" : "a") + " team!";
            player.m_6352_((Component)new TextComponent(targetName + teamMsg).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        player.m_6352_((Component)new TextComponent("Invited " + targetName + " to the research-sharing team.").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        data.getTeamMembers(player.m_142081_()).forEach(plReference -> NetcodeUtils.runIfPresent(player.f_8924_, plReference.getId(), otherPlayer -> otherPlayer.m_6352_((Component)new TextComponent(playerName + " invited " + targetName + " to the research-sharing team.").m_130940_(ChatFormatting.GRAY), Util.f_137441_)));
        target.m_6352_((Component)new TextComponent(player.m_36316_().getName() + " invited you to a research-sharing team.").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        String teamAccept = "/the_vault research_team accept_invite " + playerName;
        MutableComponent acceptTxt = new TextComponent(teamAccept).m_130940_(ChatFormatting.AQUA);
        acceptTxt.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to accept!"))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, teamAccept)));
        MutableComponent acceptMessage = new TextComponent("").m_7220_((Component)new TextComponent("Run '").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)acceptTxt).m_7220_((Component)new TextComponent("' to accept their invite!").m_130940_(ChatFormatting.GREEN));
        target.m_6352_((Component)acceptMessage, Util.f_137441_);
        return 0;
    }

    private int accept(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ServerPlayer inviter = EntityArgument.m_91474_(ctx, (String)"inviter");
        PlayerResearchesData data = PlayerResearchesData.get(player.m_183503_());
        if (data.isInTeam(player.m_142081_())) {
            player.m_6352_((Component)new TextComponent("Unable to accept a invite! You are already in a research-sharing team!").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        String playerName = player.m_36316_().getName();
        if (!data.acceptInvite((Player)player, inviter.m_142081_())) {
            player.m_6352_((Component)new TextComponent("Unable to accept a invite! You were not invited by " + playerName + "!").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        player.m_6352_((Component)new TextComponent("Successfully joined a research-sharing team!").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        this.list(ctx);
        data.getTeamMembers(player.m_142081_()).forEach(plReference -> NetcodeUtils.runIfPresent(player.f_8924_, plReference.getId(), otherPlayer -> {
            if (!otherPlayer.m_142081_().equals(player.m_142081_())) {
                otherPlayer.m_6352_((Component)new TextComponent(playerName + " joined the research-sharing team.").m_130940_(ChatFormatting.GRAY), Util.f_137441_);
            }
        }));
        return 0;
    }

    private int leave(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        PlayerResearchesData data = PlayerResearchesData.get(player.m_183503_());
        if (!data.isInTeam(player.m_142081_()) || !data.leaveCurrentTeam((Player)player)) {
            player.m_6352_((Component)new TextComponent("You are not in a research-sharing team!").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        player.m_6352_((Component)new TextComponent("Successfully left your research-sharing team!").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 0;
    }

    private int list(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ResearchTree tree = PlayerResearchesData.get(player.m_183503_()).getResearches((Player)player);
        List<PlayerReference> teamMembers = tree.getResearchShares();
        if (teamMembers.isEmpty()) {
            player.m_6352_((Component)new TextComponent("You are not in a research-sharing team!").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        player.m_6352_((Component)new TextComponent("You are sharing new researches with:"), Util.f_137441_);
        teamMembers.stream().map(PlayerReference::getName).map(name -> new TextComponent("- " + name)).forEach(cmp -> player.m_6352_((Component)cmp, Util.f_137441_));
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

