/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.world.data.PlayerResearchesData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class ResetCommand
extends Command {
    @Override
    public String getName() {
        return "reset";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"all").executes(this::resetAll));
        builder.then(Commands.m_82127_((String)"level_abilities_talents_and_expertises").executes(this::resetLevelAbilitiesTalentsAndExpertises));
        builder.then(Commands.m_82127_((String)"level").executes(this::resetLevel));
        builder.then(Commands.m_82127_((String)"abilities_and_talents").executes(this::resetAbilitiesAndTalents));
        builder.then(Commands.m_82127_((String)"expertises").executes(this::resetExpertises));
        builder.then(Commands.m_82127_((String)"research").executes(this::resetResearch));
    }

    private int resetAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        PlayerVaultStatsData.get(source.m_81372_()).resetLevelAbilitiesAndExpertise(source.m_81375_());
        PlayerResearchesData.get(source.m_81372_()).resetResearchTree(source.m_81375_());
        PlayerVaultStatsData.get(source.m_81372_()).resetKnowledge(source.m_81375_());
        return 0;
    }

    private int resetLevelAbilitiesTalentsAndExpertises(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        PlayerVaultStatsData.get(source.m_81372_()).resetLevelAbilitiesAndExpertise(source.m_81375_());
        return 0;
    }

    private int resetLevel(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        PlayerVaultStatsData.get(source.m_81372_()).resetLevel(source.m_81375_());
        return 0;
    }

    private int resetAbilitiesAndTalents(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        PlayerVaultStatsData.get(source.m_81372_()).resetSkills(source.m_81375_());
        return 0;
    }

    private int resetExpertises(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        PlayerVaultStatsData.get(source.m_81372_()).resetExpertises(source.m_81375_());
        return 0;
    }

    private int resetResearch(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        PlayerResearchesData.get(source.m_81372_()).resetResearchTree(source.m_81375_());
        PlayerVaultStatsData.get(source.m_81372_()).resetKnowledge(source.m_81375_());
        return 0;
    }
}

