/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.world.data.ArenaSnapshotData;
import iskallia.vault.world.data.TimestampedInventorySnapshotData;
import iskallia.vault.world.data.VaultDeathSnapshotData;
import iskallia.vault.world.data.VaultJoinSnapshotData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SnapshotCommand
extends Command {
    private static final String PLAYER_IGN_ARGUMENT = "playerIGN";
    private static final String TIMESTAMP_ARGUMENT = "timestamp";
    private static final String RESTORE_TO_PLAYER_ARGUMENT = "restoreToPlayer";

    @Override
    public String getName() {
        return "snapshot";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"arena").then(Commands.m_82127_((String)"create").executes(this::createSnapshot))).then(Commands.m_82127_((String)"restore").executes(this::restoreSnapshot)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"death").then(this.timestampedSnapshotList((com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)this::listDeathSnapshots)))).then(this.timestampedSnapshotRestore(VaultDeathSnapshotData::get)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"vaultJoin").then(this.timestampedSnapshotList((com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)this::listJoinSnapshots)))).then(this.timestampedSnapshotRestore(VaultJoinSnapshotData::get)));
    }

    private LiteralArgumentBuilder<CommandSourceStack> timestampedSnapshotRestore(Function<ServerLevel, TimestampedInventorySnapshotData> getSnapshotData) {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"restore").then(Commands.m_82129_((String)PLAYER_IGN_ARGUMENT, (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)TIMESTAMP_ARGUMENT, (ArgumentType)IntegerArgumentType.integer()).executes(context -> this.restoreTimestampedSnapshot(getSnapshotData, ((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)PLAYER_IGN_ARGUMENT), IntegerArgumentType.getInteger((CommandContext)context, (String)TIMESTAMP_ARGUMENT), (Player)((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)RESTORE_TO_PLAYER_ARGUMENT, (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> this.restoreTimestampedSnapshot(getSnapshotData, ((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)PLAYER_IGN_ARGUMENT), IntegerArgumentType.getInteger((CommandContext)ctx, (String)TIMESTAMP_ARGUMENT), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)RESTORE_TO_PLAYER_ARGUMENT))))));
    }

    private LiteralArgumentBuilder<CommandSourceStack> timestampedSnapshotList(com.mojang.brigadier.Command<CommandSourceStack> listSnapshotsCommand) {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"list").then(Commands.m_82129_((String)PLAYER_IGN_ARGUMENT, (ArgumentType)StringArgumentType.word()).executes(listSnapshotsCommand));
    }

    private int restoreTimestampedSnapshot(Function<ServerLevel, TimestampedInventorySnapshotData> getSnapshotData, ServerPlayer serverPlayer, String playerIGN, int timestamp, Player restoreToPlayer) {
        ServerLevel serverLevel = serverPlayer.m_183503_();
        serverLevel.m_142572_().m_129927_().m_10996_(playerIGN).ifPresentOrElse(gp -> {
            if (((TimestampedInventorySnapshotData)((Object)((Object)getSnapshotData.apply(serverLevel)))).restoreSnapshot(restoreToPlayer, gp.getId(), timestamp)) {
                serverPlayer.m_6352_((Component)new TextComponent("Restored " + playerIGN + "'s snapshot"), Util.f_137441_);
            } else {
                serverPlayer.m_6352_((Component)new TextComponent("Failed to restore " + playerIGN + "'s snapshot"), Util.f_137441_);
            }
        }, () -> serverPlayer.m_6352_((Component)new TextComponent("Unable to find player's IGN: " + playerIGN).m_130940_(ChatFormatting.RED), Util.f_137441_));
        return 0;
    }

    private int listDeathSnapshots(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return this.listSnapshotTimestamps(context, VaultDeathSnapshotData::get, "death");
    }

    private int listJoinSnapshots(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return this.listSnapshotTimestamps(context, VaultJoinSnapshotData::get, "vaultJoin");
    }

    private int listSnapshotTimestamps(CommandContext<CommandSourceStack> context, Function<ServerLevel, TimestampedInventorySnapshotData> getSnapshotData, String snapshotName) throws CommandSyntaxException {
        String playerIGN = StringArgumentType.getString(context, (String)PLAYER_IGN_ARGUMENT);
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel serverLevel = source.m_81372_();
        ServerPlayer player = source.m_81375_();
        serverLevel.m_142572_().m_129927_().m_10996_(playerIGN).ifPresentOrElse(gp -> {
            ArrayList<Integer> timestamps = new ArrayList<Integer>(((TimestampedInventorySnapshotData)((Object)((Object)getSnapshotData.apply(serverLevel)))).getSnapshotTimestamps(gp.getId()));
            if (timestamps.isEmpty()) {
                player.m_6352_((Component)new TextComponent("No snapshot exists for " + playerIGN).m_130940_(ChatFormatting.RED), Util.f_137441_);
                return;
            }
            timestamps.sort(Comparator.naturalOrder());
            SimpleDateFormat dateFormat = new SimpleDateFormat();
            source.m_81354_((Component)new TextComponent("Timestamps"), false);
            timestamps.forEach(timestamp -> {
                TextComponent message = new TextComponent("");
                message.m_7220_((Component)new TextComponent(dateFormat.format(new Date((long)timestamp.intValue() * 1000L)) + " (" + timestamp + ")").m_130938_(s -> s.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/the_vault snapshot " + snapshotName + " restore " + playerIGN + " " + timestamp + " @p")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to get restore command for this timestamp")))));
                source.m_81354_((Component)message, false);
            });
        }, () -> player.m_6352_((Component)new TextComponent("Unable to find player's IGN: " + playerIGN).m_130940_(ChatFormatting.RED), Util.f_137441_));
        return 0;
    }

    private int restoreSnapshot(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ArenaSnapshotData.get(((CommandSourceStack)ctx.getSource()).m_81372_()).restoreSnapshot((Player)((CommandSourceStack)ctx.getSource()).m_81375_());
        return 0;
    }

    private int createSnapshot(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ArenaSnapshotData.get(((CommandSourceStack)ctx.getSource()).m_81372_()).createSnapshot((Player)((CommandSourceStack)ctx.getSource()).m_81375_());
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

