/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.entity.entity.SpiritEntity;
import iskallia.vault.init.ModEntities;
import iskallia.vault.world.data.ServerVaults;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SpiritCommand
extends Command {
    private static final String PLAYER_IGN_ARGUMENT = "playerIGN";
    private static final String VAULT_LEVEL_ARGUMENT = "vaultLevel";

    @Override
    public String getName() {
        return "spirit";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"summon").then(Commands.m_82129_((String)PLAYER_IGN_ARGUMENT, (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)VAULT_LEVEL_ARGUMENT, (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> this.summonSpirit((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)PLAYER_IGN_ARGUMENT), IntegerArgumentType.getInteger((CommandContext)ctx, (String)VAULT_LEVEL_ARGUMENT), false))).then(Commands.m_82129_((String)"addCurrentPlayersItems", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> this.summonSpirit((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)PLAYER_IGN_ARGUMENT), IntegerArgumentType.getInteger((CommandContext)ctx, (String)VAULT_LEVEL_ARGUMENT), BoolArgumentType.getBool((CommandContext)ctx, (String)"addCurrentPlayersItems")))))));
    }

    private int summonSpirit(CommandContext<CommandSourceStack> context, String playerIGN, int vaultLevel, boolean addCurrentPlayersItems) throws CommandSyntaxException {
        ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity != null) {
            ServerLevel serverLevel = source.m_81372_();
            serverLevel.m_142572_().m_129927_().m_10996_(playerIGN).ifPresentOrElse(gp -> {
                SpiritEntity spirit = (SpiritEntity)ModEntities.SPIRIT.m_20592_(serverLevel, null, null, entity.m_20097_(), MobSpawnType.MOB_SUMMONED, true, false);
                if (spirit != null) {
                    spirit.setGameProfile((GameProfile)gp);
                    spirit.setVaultLevel(vaultLevel);
                    spirit.setPlayerLevel(vaultLevel);
                    ServerVaults.get((Level)serverLevel).ifPresent(vault -> {
                        Listener listener = vault.get(Vault.LISTENERS).get(serverPlayer.m_142081_());
                        if (listener != null) {
                            spirit.setJoinState(listener.get(Listener.JOIN_STATE));
                        }
                    });
                    if (addCurrentPlayersItems) {
                        spirit.addPlayersItems((Player)serverPlayer);
                    }
                }
            }, () -> serverPlayer.m_6352_((Component)new TextComponent("Unable to find player's IGN: " + playerIGN).m_130940_(ChatFormatting.RED), Util.f_137441_));
        }
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

