/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.block.entity.VaultAltarTileEntity;
import iskallia.vault.command.Command;
import iskallia.vault.world.data.PlayerVaultAltarData;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;

public class VaultAltarCommand
extends Command {
    @Override
    public String getName() {
        return "altar";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"reset").executes(this::reset));
    }

    private int reset(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        PlayerVaultAltarData data = PlayerVaultAltarData.get(player.m_183503_());
        List<BlockPos> altars = data.getAltars(player.m_142081_());
        altars.stream().filter(pos -> player.m_183503_().m_46749_(pos)).map(pos -> player.m_183503_().m_7702_(pos)).filter(te -> te instanceof VaultAltarTileEntity).map(te -> (VaultAltarTileEntity)((Object)te)).filter(altar -> altar.getAltarState() == VaultAltarTileEntity.AltarState.ACCEPTING).forEach(altar -> altar.onRemoveVaultRock(player.m_142081_()));
        data.removeRecipe(player.m_142081_());
        data.m_77762_();
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

