/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class AbilitiesGUIConfig
extends Config {
    @Expose
    private Map<String, AbilityStyle> styles;
    private final Map<String, SpecializationStyle> specializationStyleLookup = new HashMap<String, SpecializationStyle>();

    @Override
    public String getName() {
        return "abilities_gui_styles";
    }

    @Override
    public <T extends Config> T readConfig() {
        AbilitiesGUIConfig config = (AbilitiesGUIConfig)super.readConfig();
        config.specializationStyleLookup.clear();
        for (AbilityStyle abilityStyle : config.styles.values()) {
            Map<String, SpecializationStyle> specializationStyles = abilityStyle.getSpecializationStyles();
            if (specializationStyles == null) continue;
            config.specializationStyleLookup.putAll(specializationStyles);
        }
        AbilitiesGUIConfig guiConfig = config;
        return (T)guiConfig;
    }

    @Nullable
    public ResourceLocation getIcon(String key) {
        if (this.specializationStyleLookup.containsKey(key)) {
            return this.specializationStyleLookup.get(key).getIcon();
        }
        return null;
    }

    public Map<String, AbilityStyle> getStyles() {
        return this.styles;
    }

    @Override
    protected void reset() {
        this.styles = new HashMap<String, AbilityStyle>();
        int x = 0;
        int y = 0;
        this.styles.put("Nova", new AbilityStyle(x, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Nova_Base", new SpecializationStyle(VaultMod.id("gui/abilities/nova")));
                this.put("Nova_Slow", new SpecializationStyle(VaultMod.id("gui/abilities/nova_speed")));
                this.put("Nova_Dot", new SpecializationStyle(VaultMod.id("gui/abilities/nova_dot")));
            }
        }));
        this.styles.put("Vein_Miner", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Vein_Miner_Base", new SpecializationStyle(VaultMod.id("gui/abilities/vein_miner")));
                this.put("Vein_Miner_Fortune", new SpecializationStyle(VaultMod.id("gui/abilities/vein_miner_fortune")));
                this.put("Vein_Miner_Durability", new SpecializationStyle(VaultMod.id("gui/abilities/vein_miner_durability")));
                this.put("Vein_Miner_Void", new SpecializationStyle(VaultMod.id("gui/abilities/vein_miner_void")));
            }
        }));
        this.styles.put("Rampage", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Rampage_Base", new SpecializationStyle(VaultMod.id("gui/abilities/rampage")));
                this.put("Rampage_Leech", new SpecializationStyle(VaultMod.id("gui/abilities/rampage_leech")));
                this.put("Rampage_Chain", new SpecializationStyle(VaultMod.id("gui/abilities/rampage_chain")));
            }
        }));
        this.styles.put("Ghost_Walk", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Ghost_Walk_Base", new SpecializationStyle(VaultMod.id("gui/abilities/ghost_walk")));
                this.put("Ghost_Walk_Spirit", new SpecializationStyle(VaultMod.id("gui/abilities/ghost_walk_spirit_walk")));
            }
        }));
        this.styles.put("Dash", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Dash_Base", new SpecializationStyle(VaultMod.id("gui/abilities/dash")));
                this.put("Dash_Damage", new SpecializationStyle(VaultMod.id("gui/abilities/dash_damage")));
                this.put("Dash_Warp", new SpecializationStyle(VaultMod.id("gui/abilities/dash_warp")));
            }
        }));
        this.styles.put("Mega_Jump", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Mega_Jump_Base", new SpecializationStyle(VaultMod.id("gui/abilities/mega_jump")));
                this.put("Mega_Jump_Break_Up", new SpecializationStyle(VaultMod.id("gui/abilities/mega_jump_break_up")));
                this.put("Mega_Jump_Break_Down", new SpecializationStyle(VaultMod.id("gui/abilities/mega_jump_break_down")));
            }
        }));
        this.styles.put("Mana_Shield", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Mana_Shield_Base", new SpecializationStyle(VaultMod.id("gui/abilities/mana_shield")));
                this.put("Mana_Shield_Retribution", new SpecializationStyle(VaultMod.id("gui/abilities/mana_shield_retribution")));
            }
        }));
        this.styles.put("Execute", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Execute_Base", new SpecializationStyle(VaultMod.id("gui/abilities/execute")));
            }
        }));
        this.styles.put("Heal", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Heal_Base", new SpecializationStyle(VaultMod.id("gui/abilities/heal")));
                this.put("Heal_Group", new SpecializationStyle(VaultMod.id("gui/abilities/heal_group")));
                this.put("Heal_Cleanse", new SpecializationStyle(VaultMod.id("gui/abilities/heal_effect")));
            }
        }));
        this.styles.put("Empower", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Empower_Base", new SpecializationStyle(VaultMod.id("gui/abilities/empower")));
                this.put("Empower_Ice_Armor", new SpecializationStyle(VaultMod.id("gui/abilities/empower_ice_armour")));
            }
        }));
        this.styles.put("Summon_Eternal", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Summon_Eternal_Base", new SpecializationStyle(VaultMod.id("gui/abilities/summon_eternal")));
            }
        }));
        this.styles.put("Hunter", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Hunter_Base", new SpecializationStyle(VaultMod.id("gui/abilities/hunter")));
                this.put("Hunter_Blocks", new SpecializationStyle(VaultMod.id("gui/abilities/hunter_blocks")));
                this.put("Hunter_Wooden", new SpecializationStyle(VaultMod.id("gui/abilities/hunter_wooden")));
                this.put("Hunter_Gilded", new SpecializationStyle(VaultMod.id("gui/abilities/hunter_gilded")));
                this.put("Hunter_Living", new SpecializationStyle(VaultMod.id("gui/abilities/hunter_living")));
                this.put("Hunter_Ornate", new SpecializationStyle(VaultMod.id("gui/abilities/hunter_ornate")));
                this.put("Hunter_Coins", new SpecializationStyle(VaultMod.id("gui/abilities/hunter_coins")));
            }
        }));
        this.styles.put("Farmer", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Farmer_Base", new SpecializationStyle(VaultMod.id("gui/abilities/farmer")));
                this.put("Farmer_Melon", new SpecializationStyle(VaultMod.id("gui/abilities/farmer_melon")));
                this.put("Farmer_Cactus", new SpecializationStyle(VaultMod.id("gui/abilities/farmer_cactus")));
                this.put("Farmer_Animal", new SpecializationStyle(VaultMod.id("gui/abilities/farmer_animal")));
            }
        }));
        this.styles.put("Taunt", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Taunt_Base", new SpecializationStyle(VaultMod.id("gui/abilities/taunt")));
                this.put("Taunt_Repel", new SpecializationStyle(VaultMod.id("gui/abilities/taunt_repel")));
                this.put("Taunt_Charm", new SpecializationStyle(VaultMod.id("gui/abilities/taunt_charm")));
            }
        }));
        this.styles.put("Stonefall", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Stonefall_Base", new SpecializationStyle(VaultMod.id("gui/abilities/stonefall")));
                this.put("Stonefall_Snow", new SpecializationStyle(VaultMod.id("gui/abilities/stonefall_snow")));
                this.put("Stonefall_Cold", new SpecializationStyle(VaultMod.id("gui/abilities/stonefall_cold")));
            }
        }));
        this.styles.put("Totem", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Totem_Base", new SpecializationStyle(VaultMod.id("gui/abilities/totem")));
                this.put("Totem_Mob_Damage", new SpecializationStyle(VaultMod.id("gui/abilities/totem_mob_damage")));
                this.put("Totem_Mana_Regen", new SpecializationStyle(VaultMod.id("gui/abilities/totem_mana_regen")));
                this.put("Totem_Player_Damage", new SpecializationStyle(VaultMod.id("gui/abilities/totem_player_damage")));
            }
        }));
        this.styles.put("Javelin", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Javelin_Base", new SpecializationStyle(VaultMod.id("gui/abilities/javelin")));
                this.put("Javelin_Piercing", new SpecializationStyle(VaultMod.id("gui/abilities/javelin_piercing")));
                this.put("Javelin_Scatter", new SpecializationStyle(VaultMod.id("gui/abilities/javelin_scatter")));
                this.put("Javelin_Sight", new SpecializationStyle(VaultMod.id("gui/abilities/javelin_sight")));
            }
        }));
        this.styles.put("Smite", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Smite_Base", new SpecializationStyle(VaultMod.id("gui/abilities/smite")));
                this.put("Smite_Archon", new SpecializationStyle(VaultMod.id("gui/abilities/smite_archon")));
                this.put("Smite_Thunderstorm", new SpecializationStyle(VaultMod.id("gui/abilities/smite_thunderstorm")));
            }
        }));
        this.styles.put("Shell", new AbilityStyle(x += 38, y, (Map<String, SpecializationStyle>)new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Shell_Base", new SpecializationStyle(VaultMod.id("gui/abilities/shell")));
                this.put("Shell_Porcupine", new SpecializationStyle(VaultMod.id("gui/abilities/shell_porcupine")));
                this.put("Shell_Quill", new SpecializationStyle(VaultMod.id("gui/abilities/shell_quill")));
            }
        }));
    }

    public static class AbilityStyle {
        @Expose
        private final int x;
        @Expose
        private final int y;
        @Expose
        private final Map<String, SpecializationStyle> specializationStyles;

        public AbilityStyle(int x, int y, Map<String, SpecializationStyle> specializationStyles) {
            this.x = x;
            this.y = y;
            this.specializationStyles = specializationStyles;
        }

        public List<ResourceLocation> getIcons() {
            return this.specializationStyles.values().stream().map(IconStyle::getIcon).collect(Collectors.toList());
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Map<String, SpecializationStyle> getSpecializationStyles() {
            return this.specializationStyles;
        }
    }

    public static class SpecializationStyle
    extends IconStyle {
        public SpecializationStyle(ResourceLocation icon) {
            super(icon);
        }
    }

    public static class IconStyle {
        @Expose
        private final ResourceLocation icon;

        public IconStyle(ResourceLocation icon) {
            this.icon = icon;
        }

        public ResourceLocation getIcon() {
            return this.icon;
        }
    }
}

