/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import java.util.ArrayList;
import java.util.List;

public class ArchitectConfig
extends Config {
    @Expose
    private List<TilePredicate> whitelist;
    @Expose
    private List<TilePredicate> blacklist;

    @Override
    public String getName() {
        return "architect";
    }

    public boolean isWhitelisted(PartialTile tile) {
        for (TilePredicate predicate : this.whitelist) {
            if (!predicate.test(tile)) continue;
            return true;
        }
        return false;
    }

    public boolean isBlacklisted(PartialTile tile) {
        for (TilePredicate predicate : this.blacklist) {
            if (!predicate.test(tile)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void reset() {
        this.whitelist = new ArrayList<TilePredicate>();
        this.blacklist = new ArrayList<TilePredicate>();
    }
}

