/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.SoulShardConfig;
import iskallia.vault.config.entry.DescriptionData;
import iskallia.vault.config.entry.IntRangeEntry;
import iskallia.vault.core.vault.objective.scavenger.MobScavengerTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengeTask;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.calc.SoulChanceHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class BestiaryConfig
extends Config {
    @Expose
    private HashMap<ResourceLocation, DescriptionData> groupDescriptions;
    @Expose
    private List<EntityEntry> entities;
    @Expose
    private List<ResourceLocation> hiddenGroups;

    @Override
    public String getName() {
        return "bestiary";
    }

    @Override
    protected void reset() {
        this.groupDescriptions = new HashMap();
        this.groupDescriptions.put(VaultMod.id("horde"), DescriptionData.getDefault("horde"));
        this.groupDescriptions.put(VaultMod.id("assassin"), DescriptionData.getDefault("assassin"));
        this.entities = new ArrayList<EntityEntry>();
        this.entities.add(new EntityEntry(new ResourceLocation("zombie"), DescriptionData.getDefault("zombie"), 100.0f, List.of("Theme 1", "Theme 2"), 0, List.of(new EntityDrop(Items.f_42416_.m_7968_(), new IntRangeEntry(0, 1), new IntRangeEntry(0, -1)), new EntityDrop(Items.f_42619_.m_7968_(), new IntRangeEntry(0, 1), new IntRangeEntry(0, -1)))));
        ItemStack bow = Items.f_42411_.m_7968_();
        bow = EnchantmentHelper.m_44877_((Random)new Random(), (ItemStack)bow, (int)30, (boolean)true);
        this.entities.add(new EntityEntry(new ResourceLocation("skeleton"), DescriptionData.getDefault("skeleton"), 200.0f, List.of("Theme 3", "Theme 4"), 0, List.of(new EntityDrop(Items.f_42500_.m_7968_(), new IntRangeEntry(1, 2), new IntRangeEntry(0, 10)), new EntityDrop(Items.f_42412_.m_7968_(), new IntRangeEntry(0, 1), new IntRangeEntry(0, -1)), new EntityDrop(bow, new IntRangeEntry(0, 1), new IntRangeEntry(0, -1)))));
        this.hiddenGroups = List.of(VaultMod.id("skeleton"), VaultMod.id("zombie"));
    }

    public List<EntityEntry> getEntities() {
        return this.entities;
    }

    public List<ResourceLocation> getHiddenGroups() {
        return this.hiddenGroups;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<EntityEntry> getEntityEntry(EntityType<?> entityType) {
        for (EntityEntry entry : this.getEntities()) {
            ResourceLocation entityId = entityType.getRegistryName();
            if (entityId == null || !entityId.equals((Object)entry.getEntityId())) continue;
            return Optional.of(BestiaryConfig.updateWithExistingValues(entry, entityId));
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static EntityEntry updateWithExistingValues(EntityEntry entry, ResourceLocation entityId) {
        EntityEntry copy = new EntityEntry(entityId, entry.descriptionData, entry.vaultExp, entry.themes, entry.minLevel, entry.drops);
        copy.setVaultExp(ModConfigs.VAULT_STATS.getMobsKilled().getOrDefault(entityId, ModConfigs.VAULT_STATS.getMobsKilled().get(new ResourceLocation("default"))).floatValue());
        ArrayList<EntityDrop> drops = new ArrayList<EntityDrop>(copy.getDrops());
        drops.addAll(BestiaryConfig.getSoulShardDrops(entityId));
        drops.addAll(BestiaryConfig.getScavDrops(entityId));
        copy.setDrops(drops);
        return copy;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Optional<Player> getLocalPlayer() {
        return Optional.ofNullable(Minecraft.m_91087_().f_91074_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static List<EntityDrop> getSoulShardDrops(ResourceLocation entityId) {
        List<EntityDrop> defaultList = List.of(new EntityDrop(ModItems.SOUL_SHARD.m_7968_(), new IntRangeEntry(0, 1), new IntRangeEntry(-1, -1)));
        Optional<Player> playerOptional = BestiaryConfig.getLocalPlayer();
        if (playerOptional.isEmpty()) {
            return defaultList;
        }
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(entityId);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (type == null || level == null) {
            return defaultList;
        }
        Entity entity = type.m_20615_((Level)level);
        if (entity == null) {
            return defaultList;
        }
        Player player = playerOptional.get();
        float chanceMultiplier = SoulChanceHelper.getSoulChance((LivingEntity)player);
        float chance = 1.0f + (chanceMultiplier - -0.3f);
        SoulShardConfig.DropRange dropRange = ModConfigs.SOUL_SHARD.getDropRange(entity);
        int amount = (int)Math.ceil(chance * (float)dropRange.getMax());
        EntityDrop shardDrop = new EntityDrop(ModItems.SOUL_SHARD.m_7968_(), new IntRangeEntry(dropRange.getMin(), amount), new IntRangeEntry(-1, -1));
        return List.of(shardDrop);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static List<EntityDrop> getScavDrops(ResourceLocation entityId) {
        for (ScavengeTask task : ModConfigs.SCAVENGER.getTasks()) {
            if (!(task instanceof MobScavengerTask)) continue;
            MobScavengerTask mobScavengerTask = (MobScavengerTask)task;
            for (MobScavengerTask.Entry entry : mobScavengerTask.entries) {
                if (!entry.group.contains(entityId)) continue;
                return List.of(new EntityDrop(entry.item, new IntRangeEntry(0, 1), new IntRangeEntry(0, (int)(mobScavengerTask.probability * 100.0))));
            }
        }
        return List.of();
    }

    public DescriptionData getGroupDescription(ResourceLocation groupId) {
        return this.groupDescriptions.getOrDefault(groupId, DescriptionData.getDefault(groupId.m_135815_()));
    }

    public static final class EntityEntry {
        @Expose
        private ResourceLocation entityId;
        @Expose
        private DescriptionData descriptionData;
        private float vaultExp;
        @Expose
        private List<String> themes;
        @Expose
        private int minLevel;
        @Expose
        List<EntityDrop> drops;
        public static final EntityEntry MISSING = new EntityEntry(new ResourceLocation("missing"), DescriptionData.getDefault("missing"), 9000.0f, List.of("Missing 1", "Missing 2"), 666, List.of());

        public EntityEntry(ResourceLocation entityId, DescriptionData descriptionData, float vaultExp, List<String> themes, int minLevel, List<EntityDrop> drops) {
            this.entityId = entityId;
            this.descriptionData = descriptionData;
            this.vaultExp = vaultExp;
            this.themes = themes;
            this.minLevel = minLevel;
            this.drops = drops;
        }

        public static EntityEntry getDefault(ResourceLocation entityId) {
            EntityEntry entry = new EntityEntry(entityId, EntityEntry.MISSING.descriptionData, EntityEntry.MISSING.vaultExp, EntityEntry.MISSING.themes, EntityEntry.MISSING.minLevel, EntityEntry.MISSING.drops);
            entry.setEntityId(entityId);
            return BestiaryConfig.updateWithExistingValues(entry, entityId);
        }

        public EntityEntry setEntityId(ResourceLocation entityId) {
            this.entityId = entityId;
            return this;
        }

        public EntityEntry setVaultExp(float vaultExp) {
            this.vaultExp = vaultExp;
            return this;
        }

        public EntityEntry setDrops(List<EntityDrop> drops) {
            this.drops = drops;
            return this;
        }

        public ResourceLocation getEntityId() {
            return this.entityId;
        }

        public MutableComponent getDescriptionData() {
            return this.descriptionData.getComponent();
        }

        public float getVaultExp() {
            return this.vaultExp;
        }

        public List<String> getThemes() {
            return this.themes;
        }

        public int getMinLevel() {
            return this.minLevel;
        }

        public List<EntityDrop> getDrops() {
            return this.drops;
        }
    }

    public static final class EntityDrop {
        @Expose
        private ItemStack stack;
        @Expose
        private IntRangeEntry amount;
        @Expose
        private IntRangeEntry probability;

        public EntityDrop(ItemStack item, IntRangeEntry amount, IntRangeEntry probability) {
            this.stack = item;
            this.amount = amount;
            this.probability = probability;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public IntRangeEntry getAmount() {
            return this.amount;
        }

        public IntRangeEntry getProbability() {
            return this.probability;
        }
    }
}

