/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.entity.champion.LeechOnHitAffix;
import iskallia.vault.entity.champion.OnHitApplyPotionAffix;
import iskallia.vault.entity.champion.PotionAuraAffix;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModEffects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class ChampionsConfig
extends Config {
    @Expose
    public float defaultChampionChance;
    @Expose
    public Map<EntityPredicate, Float> entityChampionChance = new HashMap<EntityPredicate, Float>();
    @Expose
    public List<AttributeOverride> defaultAttributeOverrides = new ArrayList<AttributeOverride>();
    @Expose
    public Map<EntityPredicate, List<AttributeOverride>> entityAttributeOverrides = new LinkedHashMap<EntityPredicate, List<AttributeOverride>>();
    @Expose
    public Map<EntityPredicate, WeightedList<CompoundTag>> entityAffixesData = new LinkedHashMap<EntityPredicate, WeightedList<CompoundTag>>();

    @Override
    public String getName() {
        return "champions";
    }

    @Override
    protected void reset() {
        PartialEntity zombiePredicate;
        try {
            zombiePredicate = PartialEntity.parse("minecraft:zombie");
        }
        catch (Exception e) {
            return;
        }
        this.defaultChampionChance = 0.01f;
        this.entityChampionChance.clear();
        this.entityChampionChance.put(zombiePredicate, Float.valueOf(0.05f));
        ArrayList<AttributeOverride> attributes = new ArrayList<AttributeOverride>();
        attributes.add(new AttributeOverride(Attributes.f_22276_.getRegistryName().toString(), 1.5, "multiply"));
        attributes.add(new AttributeOverride(Attributes.f_22281_.getRegistryName().toString(), 2.0, "multiply"));
        attributes.add(new AttributeOverride(ModAttributes.CRIT_CHANCE.getRegistryName().toString(), 0.3, "set"));
        this.defaultAttributeOverrides.clear();
        this.defaultAttributeOverrides.addAll(attributes);
        this.entityAttributeOverrides.clear();
        this.entityAttributeOverrides.put(zombiePredicate, attributes);
        this.entityAffixesData.clear();
        WeightedList<CompoundTag> affixes = new WeightedList<CompoundTag>();
        affixes.add(new OnHitApplyPotionAffix("Poisonous", MobEffects.f_19614_, 60, 0, 0.1f).serialize(), 3);
        affixes.add(new OnHitApplyPotionAffix("Withering", MobEffects.f_19615_, 40, 0, 0.05f).serialize(), 1);
        affixes.add(new OnHitApplyPotionAffix("Draining", MobEffects.f_19612_, 80, 1, 0.3f).serialize(), 2);
        affixes.add(new OnHitApplyPotionAffix("Freezing", ModEffects.FREEZE, 80, 1, 0.3f).serialize(), 2);
        affixes.add(new PotionAuraAffix("Elevating", MobEffects.f_19620_, 20, 0, 10, PotionAuraAffix.Target.PLAYER).serialize(), 3);
        affixes.add(new PotionAuraAffix("Reinforcing", MobEffects.f_19606_, 20, 0, 10, PotionAuraAffix.Target.MOB).serialize(), 3);
        affixes.add(new LeechOnHitAffix("Leeching", 0.5f).serialize(), 2);
        this.entityAffixesData.put(zombiePredicate, affixes);
    }

    public static class AttributeOverride {
        @Expose
        public String NAME;
        @Expose
        public double VALUE;
        @Expose
        public String OPERATOR;

        public AttributeOverride(String name, double value, String operator) {
            this.NAME = name;
            this.VALUE = value;
            this.OPERATOR = operator;
        }

        public void applyTo(AttributeInstance instance) {
            if (this.OPERATOR.equalsIgnoreCase("multiply")) {
                instance.m_22100_(instance.m_22115_() * this.VALUE);
            } else if (this.OPERATOR.equalsIgnoreCase("add")) {
                instance.m_22100_(instance.m_22115_() + this.VALUE);
            } else if (this.OPERATOR.equalsIgnoreCase("set")) {
                instance.m_22100_(this.VALUE);
            }
        }
    }
}

