/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.util.data.WeightedList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CustomEntitySpawnerConfig
extends Config {
    @Expose
    public Map<String, List<SpawnerGroup>> spawnerGroups;

    @Override
    public String getName() {
        return "custom_entity_spawner";
    }

    @Override
    protected void reset() {
        this.spawnerGroups = new HashMap<String, List<SpawnerGroup>>();
        CompoundTag fuse = new CompoundTag();
        fuse.m_128376_("Fuse", (short)80);
        CompoundTag tntState = new CompoundTag();
        tntState.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)Blocks.f_50077_.m_49966_()));
        WeightedList<SpawnerEntity> entities = new WeightedList<SpawnerEntity>();
        entities.add(new SpawnerEntity(EntityType.f_20515_.getRegistryName(), fuse, true), 2);
        entities.add(new SpawnerEntity(EntityType.f_20450_.getRegistryName(), tntState), 1);
        this.spawnerGroups.put("group1", List.of(new SpawnerGroup(0, 10, entities)));
        entities = new WeightedList();
        entities.add(new SpawnerEntity(EntityType.f_20522_.getRegistryName(), null), 2);
        entities.add(new SpawnerEntity(EntityType.f_20451_.getRegistryName(), null, true), 1);
        WeightedList<SpawnerEntity> entities2 = new WeightedList<SpawnerEntity>();
        entities2.add(new SpawnerEntity(EntityType.f_20522_.getRegistryName(), null), 2);
        entities2.add(new SpawnerEntity(EntityType.f_20451_.getRegistryName(), null, true), 1);
        this.spawnerGroups.put("group2", List.of(new SpawnerGroup(0, 20, entities), new SpawnerGroup(5, 20, entities2)));
    }

    public static class SpawnerEntity {
        @Expose
        public ResourceLocation type;
        @Nullable
        @Expose
        public CompoundTag nbt;
        @Expose
        public boolean randomMotion;

        public SpawnerEntity(ResourceLocation type, @Nullable CompoundTag nbt, boolean randomMotion) {
            this.type = type;
            this.nbt = nbt;
            this.randomMotion = randomMotion;
        }

        public SpawnerEntity(ResourceLocation type, @Nullable CompoundTag nbt) {
            this(type, nbt, false);
        }
    }

    public static class SpawnerGroup {
        @Expose
        public int minLevel;
        @Expose
        public int blockCheckRadius;
        @Expose
        public WeightedList<SpawnerEntity> entities;

        public SpawnerGroup(int minLevel, int blockCheckRadius, WeightedList<SpawnerEntity> entities) {
            this.minLevel = minLevel;
            this.blockCheckRadius = blockCheckRadius;
            this.entities = entities;
        }
    }
}

