/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.FloatRangeEntry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.registries.ForgeRegistries;

public class EternalAttributeConfig
extends Config {
    @Expose
    private final Map<String, FloatRangeEntry> initialAttributes = new HashMap<String, FloatRangeEntry>();
    @Expose
    private FloatRangeEntry healthPerLevel;
    @Expose
    private FloatRangeEntry damagePerLevel;
    @Expose
    private FloatRangeEntry moveSpeedPerLevel;

    @Override
    public String getName() {
        return "eternal_attributes";
    }

    public Map<Attribute, Float> createAttributes() {
        HashMap<Attribute, Float> selectedAttributes = new HashMap<Attribute, Float>();
        this.initialAttributes.forEach((attrKey, valueRange) -> {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attrKey));
            if (attribute != null) {
                selectedAttributes.put(attribute, Float.valueOf(valueRange.getRandom()));
            }
        });
        return selectedAttributes;
    }

    public FloatRangeEntry getHealthRollRange() {
        return this.healthPerLevel;
    }

    public FloatRangeEntry getDamageRollRange() {
        return this.damagePerLevel;
    }

    public FloatRangeEntry getMoveSpeedRollRange() {
        return this.moveSpeedPerLevel;
    }

    @Override
    protected void reset() {
        this.initialAttributes.clear();
        this.initialAttributes.put(Attributes.f_22276_.getRegistryName().toString(), new FloatRangeEntry(20.0f, 30.0f));
        this.initialAttributes.put(Attributes.f_22281_.getRegistryName().toString(), new FloatRangeEntry(4.0f, 7.0f));
        this.initialAttributes.put(Attributes.f_22279_.getRegistryName().toString(), new FloatRangeEntry(0.2f, 0.23f));
        this.healthPerLevel = new FloatRangeEntry(4.0f, 8.0f);
        this.damagePerLevel = new FloatRangeEntry(2.0f, 3.0f);
        this.moveSpeedPerLevel = new FloatRangeEntry(0.02f, 0.03f);
    }
}

