/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.tool.ToolMaterial;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SpiritConfig
extends Config {
    @Expose
    public float perRecoveryMultiplierIncrease;
    @Expose
    public float perCompletionMultiplierDecrease;
    @Expose
    public float heroDiscountMin;
    @Expose
    public float heroDiscountMax;
    @Expose
    public float rescuedBonusMin;
    @Expose
    public float rescuedBonusMax;
    @Expose
    public Set<LevelCost> levelCosts;

    @Override
    public String getName() {
        return "spirit";
    }

    @Override
    protected void reset() {
        this.perRecoveryMultiplierIncrease = 0.3f;
        this.perCompletionMultiplierDecrease = 0.05f;
        this.heroDiscountMin = 0.2f;
        this.heroDiscountMax = 0.8f;
        this.rescuedBonusMin = 0.2f;
        this.rescuedBonusMax = 0.8f;
        this.levelCosts = new HashSet<LevelCost>();
        LinkedHashMap<VaultGearRarity, Integer> gearRarityCost = new LinkedHashMap<VaultGearRarity, Integer>();
        gearRarityCost.put(VaultGearRarity.SCRAPPY, 1);
        gearRarityCost.put(VaultGearRarity.COMMON, 2);
        gearRarityCost.put(VaultGearRarity.RARE, 3);
        gearRarityCost.put(VaultGearRarity.EPIC, 4);
        gearRarityCost.put(VaultGearRarity.OMEGA, 5);
        gearRarityCost.put(VaultGearRarity.UNIQUE, 6);
        LinkedHashMap<ToolMaterial, Integer> toolMaterialCost = new LinkedHashMap<ToolMaterial, Integer>();
        toolMaterialCost.put(ToolMaterial.CHROMATIC_IRON_INGOT, 1);
        toolMaterialCost.put(ToolMaterial.CHROMATIC_STEEL_INGOT, 2);
        toolMaterialCost.put(ToolMaterial.VAULTERITE_INGOT, 3);
        toolMaterialCost.put(ToolMaterial.VAULT_ALLOY, 4);
        toolMaterialCost.put(ToolMaterial.BLACK_CHROMATIC_STEEL_INGOT, 5);
        toolMaterialCost.put(ToolMaterial.ECHOING_INGOT, 6);
        toolMaterialCost.put(ToolMaterial.OMEGA_POG, 7);
        LinkedHashMap<ItemStack, Integer> itemCost = new LinkedHashMap<ItemStack, Integer>();
        itemCost.put(new ItemStack((ItemLike)ModItems.VAULT_PICKAXE), 1);
        itemCost.put(new ItemStack((ItemLike)ModItems.MAGNET), 1);
        this.levelCosts.add(new LevelCost(0, (Item)ModBlocks.VAULT_BRONZE, 2.5f, gearRarityCost, toolMaterialCost, 3, itemCost));
        this.levelCosts.add(new LevelCost(5, (Item)ModBlocks.VAULT_SILVER, 3.0f, gearRarityCost, toolMaterialCost, 3, itemCost));
    }

    public float getCompletionMultiplierDecrease() {
        return (float)(this.perCompletionMultiplierDecrease < 0.5f ? 1 : 0) - this.perCompletionMultiplierDecrease;
    }

    public float getHeroDiscount(Random random) {
        return this.heroDiscountMax > 0.0f ? random.nextFloat(this.heroDiscountMin, this.heroDiscountMax) : 0.0f;
    }

    public float getRescuedBonus(Random random) {
        return random.nextFloat(this.rescuedBonusMin, this.rescuedBonusMax);
    }

    public static class LevelCost {
        @Expose
        public int minLevel;
        @Expose
        public Item item;
        @Expose
        public float count;
        @Expose
        public Map<VaultGearRarity, Integer> gearRarityCost;
        @Expose
        public Map<ToolMaterial, Integer> toolMaterialCost;
        @Expose
        public Map<ItemStack, Integer> itemCost;
        @Expose
        public int trinketCost;

        public LevelCost(int minLevel, Item item, float count, Map<VaultGearRarity, Integer> gearRarityCost, Map<ToolMaterial, Integer> toolMaterialCost, int trinketCost, Map<ItemStack, Integer> itemCost) {
            this.minLevel = minLevel;
            this.item = item;
            this.count = count;
            this.gearRarityCost = gearRarityCost;
            this.toolMaterialCost = toolMaterialCost;
            this.trinketCost = trinketCost;
            this.itemCost = itemCost;
        }

        public int getStackCost(ItemStack stack) {
            for (Map.Entry<ItemStack, Integer> entry : this.itemCost.entrySet()) {
                ItemStack costStack = entry.getKey();
                if (stack.m_41720_() != costStack.m_41720_() || !this.nbtMatches(stack, costStack)) continue;
                return entry.getValue();
            }
            return 0;
        }

        private boolean nbtMatches(ItemStack stack, ItemStack costStack) {
            if (!costStack.m_41782_()) {
                return true;
            }
            if (!stack.m_41782_()) {
                return false;
            }
            CompoundTag costTag = costStack.m_41783_();
            CompoundTag stackTag = stack.m_41783_();
            for (String nbtKey : costTag.m_128431_()) {
                if (stackTag.m_128441_(nbtKey) && stackTag.m_128423_(nbtKey).equals(costTag.m_128423_(nbtKey))) continue;
                return false;
            }
            return true;
        }
    }
}

