/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.SingleItemEntry;
import iskallia.vault.util.data.WeightedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class StatueLootConfig
extends Config {
    @Expose
    private int MAX_ACCELERATION_CHIPS;
    @Expose
    private HashMap<Integer, Integer> INTERVAL_DECREASE_PER_CHIP = new HashMap();
    @Expose
    private WeightedList<SingleItemEntry> LOOT = new WeightedList();
    @Expose
    private int INTERVAL;

    @Override
    public String getName() {
        return "statue_loot";
    }

    @Override
    protected void reset() {
        this.MAX_ACCELERATION_CHIPS = 4;
        this.INTERVAL_DECREASE_PER_CHIP.put(1, 50);
        this.INTERVAL_DECREASE_PER_CHIP.put(2, 100);
        this.INTERVAL_DECREASE_PER_CHIP.put(3, 200);
        this.INTERVAL_DECREASE_PER_CHIP.put(4, 500);
        this.LOOT = new WeightedList();
        ItemStack fancyApple = new ItemStack((ItemLike)Items.f_42410_);
        fancyApple.m_41714_((Component)new TextComponent("Fancy Apple"));
        this.LOOT.add(new WeightedList.Entry<SingleItemEntry>(new SingleItemEntry(fancyApple), 1));
        ItemStack sword = new ItemStack((ItemLike)Items.f_42420_);
        sword.m_41663_(Enchantments.f_44977_, 10);
        this.LOOT.add(new WeightedList.Entry<SingleItemEntry>(new SingleItemEntry(sword), 1));
        this.LOOT.add(new WeightedList.Entry<SingleItemEntry>(new SingleItemEntry(Items.f_42339_.m_7968_()), 1));
        this.LOOT.add(new WeightedList.Entry<SingleItemEntry>(new SingleItemEntry(Items.f_42064_.m_7968_()), 1));
        this.LOOT.add(new WeightedList.Entry<SingleItemEntry>(new SingleItemEntry(Items.f_42079_.m_7968_()), 1));
        this.LOOT.add(new WeightedList.Entry<SingleItemEntry>(new SingleItemEntry(Items.f_42378_.m_7968_()), 1));
        this.INTERVAL = 500;
    }

    public ItemStack randomLoot() {
        return this.getItem(this.LOOT.getRandom(new Random()));
    }

    public int getInterval() {
        return this.INTERVAL;
    }

    public int getMaxAccelerationChips() {
        return this.MAX_ACCELERATION_CHIPS;
    }

    private ItemStack getItem(SingleItemEntry entry) {
        ItemStack stack = ItemStack.f_41583_;
        try {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry.ITEM));
            stack = new ItemStack((ItemLike)item);
            if (entry.NBT != null) {
                CompoundTag nbt = TagParser.m_129359_((String)entry.NBT);
                stack.m_41751_(nbt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stack;
    }

    public int getIntervalDecrease(int chipCount) {
        return this.INTERVAL_DECREASE_PER_CHIP.get(chipCount);
    }

    public List<ItemStack> getOptions() {
        ArrayList<ItemStack> options = new ArrayList<ItemStack>();
        WeightedList<SingleItemEntry> entries = this.LOOT;
        if (entries.size() < 5) {
            VaultMod.LOGGER.error("Invalid config: statue weighted list should have more than 5 entries");
            return List.of(Items.f_42064_.m_7968_());
        }
        block0: while (options.size() < 5) {
            SingleItemEntry entry = entries.getRandom(new Random());
            ItemStack item = this.getItem(entry);
            if (item.m_41619_()) {
                entries.remove(entry);
                continue;
            }
            for (ItemStack i : options) {
                if (i.m_41720_() != item.m_41720_()) continue;
                continue block0;
            }
            options.add(item);
        }
        return options;
    }
}

