/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import java.util.HashMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class VaultItemsConfig
extends Config {
    @Expose
    public FlatExpFood VAULT_COOKIE;
    @Expose
    public FlatExpFood PLAIN_BURGER;
    @Expose
    public FlatExpFood CHEESE_BURGER;
    @Expose
    public FlatExpFood DOUBLE_CHEESE_BURGER;
    @Expose
    public FlatExpFood DELUXE_CHEESE_BURGER;
    @Expose
    public FlatExpFood CRISPY_DELUXE_CHEESE_BURGER;
    @Expose
    public FlatExpFood SALTY_DELUXE_CHEESE_BURGER;
    @Expose
    public FlatExpFood CHEESE_BURGER_FEAST;
    @Expose
    public FlatExpFood SPICY_HEARTY_BURGER;
    @Expose
    public VaultDoll VAULT_DOLL;

    @Override
    public String getName() {
        return "vault_items";
    }

    @Override
    protected void reset() {
        this.VAULT_COOKIE = new FlatExpFood(0, 100);
        this.PLAIN_BURGER = new FlatExpFood(0, 100);
        this.CHEESE_BURGER = new FlatExpFood(0, 100);
        this.DOUBLE_CHEESE_BURGER = new FlatExpFood(0, 100);
        this.DELUXE_CHEESE_BURGER = new FlatExpFood(0, 100);
        this.CRISPY_DELUXE_CHEESE_BURGER = new FlatExpFood(0, 100);
        this.SALTY_DELUXE_CHEESE_BURGER = new FlatExpFood(0, 100);
        this.CHEESE_BURGER_FEAST = new FlatExpFood(0, 100);
        this.SPICY_HEARTY_BURGER = new FlatExpFood(0, 100);
        this.VAULT_DOLL = new VaultDoll(0.1f, 0.7f, 0.2f, 0.8f);
    }

    public static class FlatExpFood {
        @Expose
        public int minExp;
        @Expose
        public int maxExp;

        public FlatExpFood(int minExp, int maxExp) {
            this.minExp = minExp;
            this.maxExp = maxExp;
        }
    }

    public static class VaultDoll {
        @Expose
        public float lootPercentageMin;
        @Expose
        public float lootPercentageMax;
        @Expose
        public float xpPercentageMin;
        @Expose
        public float xpPercentageMax;
        @Expose
        private HashMap<Item, Float> helmetOffsets;

        public VaultDoll(float lootPercentageMin, float lootPercentageMax, float xpPercentageMin, float xpPercentageMax) {
            this.lootPercentageMin = lootPercentageMin;
            this.lootPercentageMax = lootPercentageMax;
            this.xpPercentageMin = xpPercentageMin;
            this.xpPercentageMax = xpPercentageMax;
            this.helmetOffsets = new HashMap();
            this.helmetOffsets.put(Items.f_42472_, Float.valueOf(0.08f));
            this.helmetOffsets.put(Items.f_42480_, Float.valueOf(0.08f));
        }

        public float getHelmetOffset(Item helmet) {
            return this.helmetOffsets.getOrDefault(helmet, Float.valueOf(0.08f)).floatValue();
        }
    }

    public static class PercentageExpFood {
        @Expose
        public float minExpPercent;
        @Expose
        public float maxExpPercent;

        public PercentageExpFood(float minExpPercent, float maxExpPercent) {
            this.minExpPercent = minExpPercent;
            this.maxExpPercent = maxExpPercent;
        }
    }
}

