/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.ChanceItemStackEntry;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.gear.DataInitializationItem;
import iskallia.vault.item.gear.DataTransferItem;
import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class VaultJewelCuttingConfig
extends Config {
    @Expose
    private JewelCuttingInput jewelCuttingInput;
    @Expose
    private JewelCuttingOutput jewelCuttingOutput;
    @Expose
    private JewelCuttingRange jewelCuttingRange;
    @Expose
    private float jewelCuttingModifierRemovalChance;

    @Override
    public String getName() {
        return "vault_jewel_cutting";
    }

    public JewelCuttingOutput getJewelCuttingOutput() {
        return this.jewelCuttingOutput;
    }

    public JewelCuttingInput getJewelCuttingInput() {
        return this.jewelCuttingInput;
    }

    public JewelCuttingRange getJewelCuttingRange() {
        return this.jewelCuttingRange;
    }

    public float getJewelCuttingModifierRemovalChance() {
        return this.jewelCuttingModifierRemovalChance;
    }

    @Override
    protected void reset() {
        this.jewelCuttingModifierRemovalChance = 0.35f;
        this.jewelCuttingRange = new JewelCuttingRange(1, 10);
        this.jewelCuttingInput = new JewelCuttingInput(new ItemStack((ItemLike)ModItems.SILVER_SCRAP, 5), new ItemStack((ItemLike)ModBlocks.VAULT_BRONZE, 16));
        this.jewelCuttingOutput = new JewelCuttingOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.SILVER_SCRAP), 1, 4, 1.0f), new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.WUTODIE_GEM), 1, 2, 0.75f), new ChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f));
    }

    public static class JewelCuttingOutput {
        @Expose
        private final ChanceItemStackEntry mainOutput;
        @Expose
        private final ChanceItemStackEntry extraOutput1;
        @Expose
        private final ChanceItemStackEntry extraOutput2;

        public JewelCuttingOutput(ChanceItemStackEntry mainOutput, ChanceItemStackEntry extraOutput1, ChanceItemStackEntry extraOutput2) {
            this.mainOutput = mainOutput;
            this.extraOutput1 = extraOutput1;
            this.extraOutput2 = extraOutput2;
        }

        public ItemStack generateMainOutput() {
            ItemStack out = DataTransferItem.doConvertStack(this.mainOutput.createItemStack(Config.rand));
            DataInitializationItem.doInitialize(out);
            return out;
        }

        public ChanceItemStackEntry getMainOutput() {
            return this.mainOutput;
        }

        public ChanceItemStackEntry getExtraOutput1() {
            return this.extraOutput1;
        }

        public ChanceItemStackEntry getExtraOutput2() {
            return this.extraOutput2;
        }

        public ItemStack getMainOutputMatching() {
            return this.mainOutput.getMatchingStack();
        }

        public ItemStack generateExtraOutput1() {
            ItemStack out = DataTransferItem.doConvertStack(this.extraOutput1.createItemStack(Config.rand));
            DataInitializationItem.doInitialize(out);
            return out;
        }

        public ItemStack getExtraOutput1Matching() {
            return this.extraOutput1.getMatchingStack();
        }

        public ItemStack generateExtraOutput2() {
            ItemStack out = DataTransferItem.doConvertStack(this.extraOutput2.createItemStack(Config.rand));
            DataInitializationItem.doInitialize(out);
            return out;
        }

        public ItemStack getExtraOutput2Matching() {
            return this.extraOutput2.getMatchingStack();
        }
    }

    public static class JewelCuttingInput {
        @Expose
        private final ItemStack mainInput;
        @Expose
        private final ItemStack secondInput;

        public JewelCuttingInput(ItemStack mainInput, ItemStack secondInput) {
            this.mainInput = mainInput;
            this.secondInput = secondInput;
        }

        public ItemStack getMainInput() {
            return this.mainInput;
        }

        public ItemStack getSecondInput() {
            return this.secondInput;
        }
    }

    public static class JewelCuttingRange {
        @Expose
        private final int min;
        @Expose
        private final int max;

        public JewelCuttingRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public int getRandom() {
            return Mth.m_14072_((Random)new Random(), (int)this.min, (int)this.max);
        }
    }
}

