/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import java.util.ArrayList;
import java.util.List;

public class VaultLevelsConfig
extends Config {
    @Expose
    private int maxLevel;
    @Expose
    private final List<VaultLevelMeta> levelMetas = new ArrayList<VaultLevelMeta>();

    @Override
    public String getName() {
        return "vault_levels";
    }

    public VaultLevelMeta getLevelMeta(int level) {
        int maxLevelTNLAvailable = this.levelMetas.size() - 1;
        if (level < 0 || level > maxLevelTNLAvailable) {
            return this.levelMetas.get(maxLevelTNLAvailable);
        }
        return this.levelMetas.get(level);
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    protected void reset() {
        this.maxLevel = 100;
        this.levelMetas.clear();
        for (int x = 0; x < this.maxLevel; ++x) {
            VaultLevelMeta vaultLevel = new VaultLevelMeta();
            vaultLevel.level = x;
            vaultLevel.tnl = x < 6 ? 1000 * x + 1000 : (x < 8 ? 2000 * x - 5000 : (x < 10 ? 1500 * x - 1000 : (x < 40 ? 400 * x + 10000 : (x < 50 ? 1200 * x - 22000 : (x < 65 ? 98700 : (x < 80 ? 246750 : (x < 90 ? 493500 : 1110375)))))));
            this.levelMetas.add(vaultLevel);
        }
    }

    public long defaultTNLFunction(int level) {
        return 10000L + 400L * (long)level + Math.round(Math.pow((float)level / 59.0f, 28.0));
    }

    public static class VaultLevelMeta {
        @Expose
        public int level;
        @Expose
        public int tnl;
    }
}

