/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.NaturalSpawner;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.VaultDifficulty;
import iskallia.vault.world.data.WorldSettings;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class VaultMobsConfig
extends Config {
    @Expose
    private Map<EntityPredicate, List<Mob.AttributeOverride>> ATTRIBUTE_OVERRIDES = new LinkedHashMap<EntityPredicate, List<Mob.AttributeOverride>>();
    @Expose
    private LevelEntryList<LevelOverride> LEVEL_OVERRIDES = new LevelEntryList();

    public LevelOverride getForLevel(int level) {
        return this.LEVEL_OVERRIDES.getForLevel(level).orElse(LevelOverride.EMPTY);
    }

    @Override
    public String getName() {
        return "vault_mobs";
    }

    public static LivingEntity scale(UUID ownerId, LivingEntity entity, int vaultLevel) {
        List<Mob.AttributeOverride> attributes = null;
        for (Map.Entry<EntityPredicate, List<Mob.AttributeOverride>> entry : ModConfigs.VAULT_MOBS.ATTRIBUTE_OVERRIDES.entrySet()) {
            if (!entry.getKey().test((Entity)entity)) continue;
            attributes = entry.getValue();
        }
        if (attributes == null) {
            return entity;
        }
        VaultDifficulty difficulty = WorldSettings.get(entity.f_19853_).getPlayerDifficulty(ownerId);
        for (Mob.AttributeOverride property : attributes) {
            double rollChance;
            Mob.AttributeOverrideOverride override = property.LEVELS == null ? null : (Mob.AttributeOverrideOverride)property.LEVELS.getForLevel(vaultLevel).orElse(null);
            double d = rollChance = override == null ? property.ROLL_CHANCE : override.ROLL_CHANCE;
            if (entity.f_19853_.f_46441_.nextDouble() >= rollChance) continue;
            Registry.f_122866_.m_6612_(new ResourceLocation(property.NAME)).ifPresent(attribute -> {
                AttributeInstance instance = entity.m_21051_(attribute);
                if (instance == null) {
                    return;
                }
                double baseValue = property.getValue(instance.m_22115_(), vaultLevel, entity.f_19853_.m_5822_());
                if (instance.m_22099_() == Attributes.f_22276_) {
                    baseValue *= difficulty.getHeathMultiplier();
                } else if (instance.m_22099_() == Attributes.f_22281_) {
                    baseValue *= difficulty.getDamageMultiplier();
                }
                instance.m_22100_(baseValue);
            });
        }
        entity.m_21153_(1.0f);
        entity.m_5634_(1000000.0f);
        AttributeInstance inst = entity.m_21051_(Attributes.f_22276_);
        if (inst != null) {
            for (AttributeModifier modifier : inst.m_22122_()) {
                if (!modifier.m_22214_().equals("Leader zombie bonus")) continue;
                inst.m_22130_(modifier);
                break;
            }
        }
        return entity;
    }

    @Override
    protected void reset() {
        ArrayList<Mob.AttributeOverride> attributes = new ArrayList<Mob.AttributeOverride>();
        attributes.add(new Mob.AttributeOverride(ModAttributes.CRIT_CHANCE, 0.0, 0.5, "set", 0.8, 0.05));
        attributes.add(new Mob.AttributeOverride(ModAttributes.CRIT_MULTIPLIER, 0.0, 0.1, "set", 0.8, 0.1));
        this.LEVEL_OVERRIDES.add(new LevelOverride(0));
    }

    public static class LevelOverride
    implements LevelEntryList.ILevelEntry {
        public static final LevelOverride EMPTY = new LevelOverride(0);
        @Expose
        public int MIN_LEVEL;
        @Expose
        public WeightedList<Mob> MOB_POOL;
        @Expose
        public WeightedList<Mob> BOSS_POOL;
        @Expose
        public WeightedList<Mob> RAFFLE_BOSS_POOL;
        @Expose
        public NaturalSpawner.Config SPAWNER;

        public LevelOverride(int minLevel) {
            this.MIN_LEVEL = minLevel;
            this.MOB_POOL = new WeightedList();
            this.BOSS_POOL = new WeightedList();
            this.RAFFLE_BOSS_POOL = new WeightedList();
            this.SPAWNER = new NaturalSpawner.Config(0, 8, 12, 16);
        }

        public LevelOverride mob(EntityType<? extends LivingEntity> type, int weight) {
            this.MOB_POOL.add(new Mob(type), weight);
            return this;
        }

        public LevelOverride mob(EntityType<? extends LivingEntity> type, int weight, Consumer<Mob> action) {
            Mob mob = new Mob(type);
            action.accept(mob);
            this.MOB_POOL.add(mob, weight);
            return this;
        }

        public LevelOverride boss(EntityType<? extends LivingEntity> type, int weight) {
            this.BOSS_POOL.add(new Mob(type), weight);
            return this;
        }

        public LevelOverride boss(EntityType<? extends LivingEntity> type, int weight, Consumer<Mob> action) {
            Mob mob = new Mob(type);
            action.accept(mob);
            this.BOSS_POOL.add(mob, weight);
            return this;
        }

        public LevelOverride raffle(EntityType<? extends LivingEntity> type, int weight) {
            this.RAFFLE_BOSS_POOL.add(new Mob(type), weight);
            return this;
        }

        public LevelOverride raffle(EntityType<? extends LivingEntity> type, int weight, Consumer<Mob> action) {
            Mob mob = new Mob(type);
            action.accept(mob);
            this.RAFFLE_BOSS_POOL.add(mob, weight);
            return this;
        }

        @Override
        public int getLevel() {
            return this.MIN_LEVEL;
        }
    }

    public static class Mob {
        @Expose
        private String NAME;

        public Mob(EntityType<?> type) {
            this.NAME = type.getRegistryName().toString();
        }

        public EntityType<?> getType() {
            return Registry.f_122826_.m_6612_(new ResourceLocation(this.NAME)).orElse(EntityType.f_20549_);
        }

        public LivingEntity create(Level world) {
            return (LivingEntity)this.getType().m_20615_(world);
        }

        public static class AttributeOverrideOverride
        implements LevelEntryList.ILevelEntry {
            @Expose
            public int MIN_LEVEL;
            @Expose
            public double MIN;
            @Expose
            public double MAX;
            @Expose
            public String OPERATOR;
            @Expose
            public double ROLL_CHANCE;
            @Expose
            public double SCALE_PER_LEVEL;
            @Expose
            public int SCALE_MAX_LEVEL = -1;

            @Override
            public int getLevel() {
                return this.MIN_LEVEL;
            }
        }

        public static class AttributeOverride {
            @Expose
            public String NAME;
            @Expose
            public double MIN;
            @Expose
            public double MAX;
            @Expose
            public String OPERATOR;
            @Expose
            public double ROLL_CHANCE;
            @Expose
            public double SCALE_PER_LEVEL;
            @Expose
            public int SCALE_MAX_LEVEL = -1;
            @Expose
            public LevelEntryList<AttributeOverrideOverride> LEVELS;

            public AttributeOverride(Attribute attribute, double min, double max, String operator, double rollChance, double scalePerLevel) {
                this.NAME = attribute.getRegistryName().toString();
                this.MIN = min;
                this.MAX = max;
                this.OPERATOR = operator;
                this.ROLL_CHANCE = rollChance;
                this.SCALE_PER_LEVEL = scalePerLevel;
            }

            public double getValue(double baseValue, int level, Random random) {
                AttributeOverrideOverride override = this.LEVELS == null ? null : (AttributeOverrideOverride)this.LEVELS.getForLevel(level).orElse(null);
                int scaleMaxLevel = override == null ? this.SCALE_MAX_LEVEL : override.SCALE_MAX_LEVEL;
                double scalePerLevel = override == null ? this.SCALE_PER_LEVEL : override.SCALE_PER_LEVEL;
                double value = this.getStartValue(baseValue, level, random);
                if (scaleMaxLevel >= 0) {
                    level = Math.min(level, scaleMaxLevel);
                }
                for (int i = 0; i < level; ++i) {
                    value += this.getStartValue(baseValue, level, random) * scalePerLevel;
                }
                return value;
            }

            public double getStartValue(double baseValue, int level, Random random) {
                AttributeOverrideOverride override = this.LEVELS == null ? null : (AttributeOverrideOverride)this.LEVELS.getForLevel(level).orElse(null);
                double min = override == null ? this.MIN : override.MIN;
                double max = override == null ? this.MAX : override.MAX;
                String operator = override == null ? this.OPERATOR : override.OPERATOR;
                double value = Math.min(min, max) + (double)random.nextFloat() * Math.abs(max - min);
                if (operator.equalsIgnoreCase("multiply")) {
                    return baseValue * value;
                }
                if (operator.equalsIgnoreCase("add")) {
                    return baseValue + value;
                }
                if (operator.equalsIgnoreCase("set")) {
                    return value;
                }
                return baseValue;
            }
        }
    }
}

