/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.ChanceItemStackEntry;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.gear.DataInitializationItem;
import iskallia.vault.item.gear.DataTransferItem;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class VaultRecyclerConfig
extends Config {
    @Expose
    private int processingTickTime;
    @Expose
    private final Map<VaultGearRarity, Float> additionalOutputRarityChances = new LinkedHashMap<VaultGearRarity, Float>();
    @Expose
    private RecyclerOutput gearRecyclingOutput;
    @Expose
    private RecyclerOutput trinketRecyclingOutput;
    @Expose
    private RecyclerOutput jewelRecyclingOutput;
    @Expose
    private RecyclerOutput inscriptionRecyclingOutput;
    @Expose
    private RecyclerOutput magnetRecyclingOutput;
    @Expose
    private RecyclerOutput charmRecyclingOutput;

    @Override
    public String getName() {
        return "vault_recycler";
    }

    public int getProcessingTickTime() {
        return this.processingTickTime;
    }

    public RecyclerOutput getGearRecyclingOutput() {
        return this.gearRecyclingOutput;
    }

    public RecyclerOutput getTrinketRecyclingOutput() {
        return this.trinketRecyclingOutput;
    }

    public RecyclerOutput getJewelRecyclingOutput() {
        return this.jewelRecyclingOutput;
    }

    public RecyclerOutput getInscriptionRecyclingOutput() {
        return this.inscriptionRecyclingOutput;
    }

    public RecyclerOutput getMagnetRecyclingOutput() {
        return this.magnetRecyclingOutput;
    }

    public RecyclerOutput getCharmRecyclingOutput() {
        return this.charmRecyclingOutput;
    }

    public float getAdditionalOutputRarityChance(VaultGearRarity rarity) {
        return this.additionalOutputRarityChances.getOrDefault((Object)rarity, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    protected void reset() {
        this.processingTickTime = 40;
        this.additionalOutputRarityChances.clear();
        this.additionalOutputRarityChances.put(VaultGearRarity.SCRAPPY, Float.valueOf(0.0f));
        this.additionalOutputRarityChances.put(VaultGearRarity.COMMON, Float.valueOf(0.05f));
        this.additionalOutputRarityChances.put(VaultGearRarity.RARE, Float.valueOf(0.1f));
        this.additionalOutputRarityChances.put(VaultGearRarity.EPIC, Float.valueOf(0.15f));
        this.additionalOutputRarityChances.put(VaultGearRarity.OMEGA, Float.valueOf(0.2f));
        this.gearRecyclingOutput = new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.VAULT_SCRAP), 4, 8, 1.0f), new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.PAINITE_GEM), 1, 1, 0.05f), new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.FACETED_FOCUS), 1, 1, 0.0f));
        this.trinketRecyclingOutput = new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)Items.f_42410_), 1, 1, 1.0f), new ChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f), new ChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f));
        this.jewelRecyclingOutput = new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.GEMSTONE), 1, 1, 1.0f), new ChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f), new ChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f));
        this.inscriptionRecyclingOutput = new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.INSCRIPTION_PIECE), 1, 1, 1.0f), new ChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f), new ChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f));
        this.magnetRecyclingOutput = new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.MAGNETITE), 1, 1, 1.0f), new ChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f), new ChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f));
        this.charmRecyclingOutput = new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.ALEXANDRITE_GEM), 1, 1, 1.0f), new ChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f), new ChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f));
    }

    public static class RecyclerOutput {
        @Expose
        private final ChanceItemStackEntry mainOutput;
        @Expose
        private final ChanceItemStackEntry extraOutput1;
        @Expose
        private final ChanceItemStackEntry extraOutput2;

        public RecyclerOutput(ChanceItemStackEntry mainOutput, ChanceItemStackEntry extraOutput1, ChanceItemStackEntry extraOutput2) {
            this.mainOutput = mainOutput;
            this.extraOutput1 = extraOutput1;
            this.extraOutput2 = extraOutput2;
        }

        public ItemStack generateMainOutput(float additionalChance) {
            ItemStack out = DataTransferItem.doConvertStack(this.mainOutput.adjustChance(additionalChance).createItemStack(Config.rand));
            DataInitializationItem.doInitialize(out);
            return out;
        }

        public ChanceItemStackEntry getMainOutput() {
            return this.mainOutput;
        }

        public ChanceItemStackEntry getExtraOutput1() {
            return this.extraOutput1;
        }

        public ChanceItemStackEntry getExtraOutput2() {
            return this.extraOutput2;
        }

        public ItemStack getMainOutputMatching() {
            return this.mainOutput.getMatchingStack();
        }

        public ItemStack generateExtraOutput1(float additionalChance) {
            ItemStack out = DataTransferItem.doConvertStack(this.extraOutput1.adjustChance(additionalChance).createItemStack(Config.rand));
            DataInitializationItem.doInitialize(out);
            return out;
        }

        public ItemStack getExtraOutput1Matching() {
            return this.extraOutput1.getMatchingStack();
        }

        public ItemStack generateExtraOutput2(float additionalChance) {
            ItemStack out = DataTransferItem.doConvertStack(this.extraOutput2.adjustChance(additionalChance).createItemStack(Config.rand));
            DataInitializationItem.doInitialize(out);
            return out;
        }

        public ItemStack getExtraOutput2Matching() {
            return this.extraOutput2.getMatchingStack();
        }

        public RecyclerOutput process(BiFunction<Integer, ItemStack, ItemStack> processor) {
            return new RecyclerOutput(new ChanceItemStackEntry(processor.apply(0, this.mainOutput.getMatchingStack()), this.mainOutput.getMinCount(), this.mainOutput.getMaxCount(), this.mainOutput.getChance()), new ChanceItemStackEntry(processor.apply(1, this.extraOutput1.getMatchingStack()), this.extraOutput1.getMinCount(), this.extraOutput1.getMaxCount(), this.extraOutput1.getChance()), new ChanceItemStackEntry(processor.apply(2, this.extraOutput2.getMatchingStack()), this.extraOutput2.getMinCount(), this.extraOutput2.getMaxCount(), this.extraOutput2.getChance()));
        }
    }
}

