/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.stat.ChestStat;
import iskallia.vault.core.vault.stat.MinedBlocksStat;
import iskallia.vault.core.vault.stat.MobsStat;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.VaultChestType;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModEntities;
import iskallia.vault.util.VaultRarity;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class VaultStatsConfig
extends Config {
    @Expose
    private Map<VaultChestType, Map<VaultRarity, Float>> chests;
    @Expose
    private Map<ResourceLocation, Float> blocksMined;
    @Expose
    private float treasureRoomsOpened;
    @Expose
    private Map<ResourceLocation, Float> mobsKilled;
    @Expose
    private Map<String, Map<Completion, Float>> completion;
    @Expose
    private float percentOfExperienceDealtAsDurabilityDamage;
    @Expose
    private int freeExperienceNotDealtAsDurabilityDamage;

    @Override
    public String getName() {
        return "vault_stats";
    }

    @Override
    protected void reset() {
        this.chests = new LinkedHashMap<VaultChestType, Map<VaultRarity, Float>>();
        LinkedHashMap<VaultRarity, Float> chest = new LinkedHashMap<VaultRarity, Float>();
        chest.put(VaultRarity.COMMON, Float.valueOf(1.0f));
        chest.put(VaultRarity.RARE, Float.valueOf(2.0f));
        chest.put(VaultRarity.EPIC, Float.valueOf(4.0f));
        chest.put(VaultRarity.OMEGA, Float.valueOf(10.0f));
        for (VaultChestType type : VaultChestType.values()) {
            this.chests.put(type, chest);
        }
        this.blocksMined = new LinkedHashMap<ResourceLocation, Float>();
        this.blocksMined.put(ModBlocks.TREASURE_SAND.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.COIN_PILE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.ALEXANDRITE_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.BENITOITE_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.LARIMAR_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.BLACK_OPAL_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.PAINITE_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.ISKALLIUM_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.GORGINITE_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.SPARKLETINE_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.WUTODIE_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.ASHIUM_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.BOMIGNITE_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.TUBIUM_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.UPALINE_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.PUFFIUM_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.PETZANITE_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.XENIUM_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.blocksMined.put(ModBlocks.ECHO_ORE.getRegistryName(), Float.valueOf(1.0f));
        this.treasureRoomsOpened = 50.0f;
        this.mobsKilled = new LinkedHashMap<ResourceLocation, Float>();
        this.mobsKilled.put(new ResourceLocation("default"), Float.valueOf(0.3f));
        this.mobsKilled.put(ModEntities.ELITE_SPIDER.getRegistryName(), Float.valueOf(2.0f));
        this.completion = new LinkedHashMap<String, Map<Completion, Float>>();
        LinkedHashMap<Completion, Float> defaultPool = new LinkedHashMap<Completion, Float>();
        defaultPool.put(Completion.BAILED, Float.valueOf(0.0f));
        defaultPool.put(Completion.FAILED, Float.valueOf(0.0f));
        defaultPool.put(Completion.COMPLETED, Float.valueOf(1000.0f));
        this.completion.put("default", defaultPool);
        this.percentOfExperienceDealtAsDurabilityDamage = 0.2f;
        this.freeExperienceNotDealtAsDurabilityDamage = 400;
    }

    public int getStatsExperience(StatCollector stats) {
        float defaultValue;
        float exp = 0.0f;
        for (ChestStat chestStat : stats.get(StatCollector.CHESTS)) {
            if (chestStat.has(ChestStat.TRAPPED)) continue;
            exp += this.chests.get((Object)chestStat.get(ChestStat.TYPE)).get((Object)chestStat.get(ChestStat.RARITY)).floatValue();
        }
        for (Map.Entry entry : stats.get(StatCollector.MINED_BLOCKS).entrySet()) {
            defaultValue = this.blocksMined.getOrDefault(new ResourceLocation("default"), Float.valueOf(0.0f)).floatValue();
            exp += this.blocksMined.getOrDefault(entry.getKey(), Float.valueOf(defaultValue)).floatValue() * (float)((MinedBlocksStat.Entry)entry.getValue()).get(MinedBlocksStat.Entry.COUNT).intValue();
        }
        exp += this.treasureRoomsOpened * (float)stats.get(StatCollector.TREASURE_ROOMS_OPENED).intValue();
        for (Map.Entry entry : stats.get(StatCollector.MOBS).entrySet()) {
            defaultValue = this.mobsKilled.getOrDefault(new ResourceLocation("default"), Float.valueOf(0.0f)).floatValue();
            exp += this.mobsKilled.getOrDefault(entry.getKey(), Float.valueOf(defaultValue)).floatValue() * (float)((MobsStat.Entry)entry.getValue()).get(MobsStat.Entry.KILLED).intValue();
        }
        return (int)exp;
    }

    public int getExperience(Vault vault, StatCollector stats) {
        float exp = 0.0f;
        exp += (float)this.getStatsExperience(stats);
        return (int)(exp += this.getCompletion(vault).get((Object)stats.getCompletion()).floatValue());
    }

    public int getCompletionExperience(Vault vault, StatCollector stats) {
        float exp = this.getCompletion(vault).get((Object)stats.getCompletion()).floatValue();
        return (int)exp;
    }

    public Map<ResourceLocation, Float> getBlocksMined() {
        return this.blocksMined;
    }

    public Map<ResourceLocation, Float> getMobsKilled() {
        return this.mobsKilled;
    }

    public Map<Completion, Float> getCompletion(Vault vault) {
        String pool = vault.getOptional(Vault.OBJECTIVES).flatMap(objectives -> objectives.getOptional(Objectives.KEY)).orElse("default");
        return !this.completion.containsKey(pool) ? this.completion.get("default") : this.completion.get(pool);
    }

    public float getTreasureRoomsOpened() {
        return this.treasureRoomsOpened;
    }

    public Map<VaultChestType, Map<VaultRarity, Float>> getChests() {
        return this.chests;
    }

    public float getPercentOfExperienceDealtAsDurabilityDamage() {
        return this.percentOfExperienceDealtAsDurabilityDamage;
    }

    public int getFreeExperienceNotDealtAsDurabilityDamage() {
        return this.freeExperienceNotDealtAsDurabilityDamage;
    }
}

