/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.adapter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import iskallia.vault.VaultMod;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemStackAdapter
extends TypeAdapter<ItemStack> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            TypeAdapter itemTypeAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, (TypeToken)new TypeToken<Item>(){});
            return typeToken.getRawType() == ItemStack.class ? new ItemStackAdapter((TypeAdapter<Item>)itemTypeAdapter) : null;
        }
    };
    private static final String KEY_ITEM = "item";
    private static final String KEY_NBT = "nbt";
    private static final String KEY_AMOUNT = "amount";
    private final TypeAdapter<Item> itemTypeAdapter;

    public ItemStackAdapter(TypeAdapter<Item> itemTypeAdapter) {
        this.itemTypeAdapter = itemTypeAdapter;
    }

    public void write(JsonWriter out, ItemStack value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name(KEY_ITEM);
        this.itemTypeAdapter.write(out, (Object)Objects.requireNonNull(value.m_41720_()));
        if (value.m_41782_()) {
            out.name(KEY_NBT);
            out.value(value.m_41782_() ? Objects.requireNonNull(value.m_41783_()).m_7916_() : "");
        }
        if (value.m_41613_() > 1) {
            out.name(KEY_AMOUNT);
            out.value((long)value.m_41613_());
        }
        out.endObject();
    }

    public ItemStack read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            in.beginObject();
            Item item = null;
            CompoundTag nbt = null;
            int amount = 1;
            while (in.peek() == JsonToken.NAME) {
                String name;
                switch (name = in.nextName()) {
                    case "item": {
                        item = (Item)this.itemTypeAdapter.read(in);
                        break;
                    }
                    case "nbt": {
                        if (in.peek() == JsonToken.NULL) {
                            in.nextNull();
                            break;
                        }
                        String nbtString = in.nextString();
                        nbt = nbtString.isEmpty() ? new CompoundTag() : TagParser.m_129359_((String)nbtString);
                        break;
                    }
                    case "amount": {
                        amount = in.nextInt();
                    }
                }
            }
            in.endObject();
            ItemStack stack = new ItemStack(item, amount);
            stack.m_41751_(nbt);
            return stack;
        }
        catch (Exception e) {
            VaultMod.LOGGER.error("Unable to parse NBT when reading an item from config.", (Throwable)e);
            return ItemStack.f_41583_;
        }
    }
}

