/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.core.world.processor.Processor;
import iskallia.vault.core.world.processor.entity.EntityProcessor;
import iskallia.vault.core.world.processor.tile.BernoulliWeightedTileProcessor;
import iskallia.vault.core.world.processor.tile.FilterTileProcessor;
import iskallia.vault.core.world.processor.tile.LeveledTileProcessor;
import iskallia.vault.core.world.processor.tile.ReferenceTileProcessor;
import iskallia.vault.core.world.processor.tile.SpawnerElementTileProcessor;
import iskallia.vault.core.world.processor.tile.SpawnerTileProcessor;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.core.world.processor.tile.VaultLootTileProcessor;
import iskallia.vault.core.world.processor.tile.WeightedTileProcessor;
import java.lang.reflect.Type;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class ProcessorAdapter
implements JsonSerializer<Processor<?>>,
JsonDeserializer<Processor<?>> {
    public static final ProcessorAdapter INSTANCE = new ProcessorAdapter();

    public Processor<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        String type = object.get("type").getAsString();
        if (typeOfT == TileProcessor.class) {
            switch (type) {
                case "reference": {
                    return new ReferenceTileProcessor(new ResourceLocation(object.get("id").getAsString()));
                }
                case "weighted_target": {
                    WeightedTileProcessor processor = new WeightedTileProcessor();
                    JsonElement thing = object.get("target");
                    if (thing instanceof JsonPrimitive || thing instanceof JsonArray) {
                        processor.target(Adapters.TILE_PREDICATE.readJson(thing).orElse(TilePredicate.FALSE));
                    } else if (thing instanceof JsonObject) {
                        CompoundTag nbt;
                        JsonObject object1 = (JsonObject)thing;
                        TilePredicate block = Adapters.TILE_PREDICATE.readJson(object1.get("block")).orElseGet(() -> TilePredicate.of("", true).orElse(TilePredicate.FALSE));
                        if (object1.has("nbt")) {
                            nbt = Adapters.COMPOUND_NBT.readJson(object1.get("nbt")).orElse(null);
                        } else {
                            nbt = Adapters.COMPOUND_NBT.readJson((JsonElement)object1).orElse(new CompoundTag());
                            nbt.m_128473_("block");
                            nbt.m_128473_("weight");
                            if (nbt.m_128456_()) {
                                nbt = null;
                            }
                        }
                        if (block instanceof PartialTile) {
                            PartialTile tile = (PartialTile)block;
                            tile.setEntity(PartialCompoundNbt.of(nbt));
                        }
                        processor.target(block);
                    }
                    JsonElement output = object.get("output");
                    if (output instanceof JsonObject) {
                        JsonObject object1 = (JsonObject)output;
                        object1.keySet().forEach(key -> processor.into((String)key, object1.get(key).getAsInt()));
                    } else if (output instanceof JsonArray) {
                        JsonArray array = (JsonArray)output;
                        array.forEach(element -> {
                            CompoundTag nbt;
                            String block;
                            JsonObject object1 = element.getAsJsonObject();
                            String string = block = !object1.has("block") ? "" : object1.get("block").getAsString();
                            if (object1.has("nbt")) {
                                nbt = Adapters.COMPOUND_NBT.readJson(object1.get("nbt")).orElse(null);
                            } else {
                                nbt = Adapters.COMPOUND_NBT.readJson((JsonElement)object1).orElse(new CompoundTag());
                                nbt.m_128473_("block");
                                nbt.m_128473_("weight");
                                if (nbt.m_128456_()) {
                                    nbt = null;
                                }
                            }
                            PartialTile tile = PartialTile.parse(block, true).orElse(PartialTile.ERROR);
                            tile.setEntity(PartialCompoundNbt.of(nbt));
                            processor.into(tile, object1.get("weight").getAsInt());
                        });
                    }
                    return processor;
                }
                case "bernoulli_weighted_target": {
                    BernoulliWeightedTileProcessor processor = new BernoulliWeightedTileProcessor();
                    if (object.has("target")) {
                        processor.target = TilePredicate.of(object.get("target").getAsString(), true).orElse(TilePredicate.FALSE);
                    }
                    processor.probability = object.get("probability").getAsDouble();
                    JsonObject success = object.get("success").getAsJsonObject();
                    JsonObject failure = object.get("failure").getAsJsonObject();
                    if (success != null) {
                        success.keySet().forEach(key -> {
                            PartialTile tile = PartialTile.parse(key, true).orElse(PartialTile.ERROR);
                            processor.success.put(tile, success.get(key).getAsInt());
                        });
                    }
                    if (failure != null) {
                        failure.keySet().forEach(key -> {
                            PartialTile tile = PartialTile.parse(key, true).orElse(PartialTile.ERROR);
                            processor.failure.put(tile, failure.get(key).getAsInt());
                        });
                    }
                    return processor;
                }
                case "leveled": {
                    LeveledTileProcessor processor = new LeveledTileProcessor();
                    JsonArray array = object.get("levels").getAsJsonArray();
                    for (JsonElement entry : array) {
                        processor.levels.put(entry.getAsJsonObject().get("level").getAsInt(), (TileProcessor)this.deserialize(entry, (Type)((Object)TileProcessor.class), context));
                    }
                    return processor;
                }
                case "placeholder": {
                    VaultLootTileProcessor processor = new VaultLootTileProcessor();
                    processor.target = PlaceholderBlock.Type.fromString(object.get("target").getAsString());
                    JsonArray array = object.get("levels").getAsJsonArray();
                    for (JsonElement entry : array) {
                        entry.getAsJsonObject().addProperty("type", "bernoulli_weighted_target");
                        processor.levels.put(entry.getAsJsonObject().get("level").getAsInt(), (TileProcessor)this.deserialize(entry, (Type)((Object)TileProcessor.class), context));
                    }
                    return processor;
                }
                case "spawner": {
                    SpawnerTileProcessor processor = new SpawnerTileProcessor();
                    processor.target(object.get("target").getAsString());
                    JsonArray output = object.get("output").getAsJsonArray();
                    if (output == null) {
                        return processor;
                    }
                    for (JsonElement e : output) {
                        WeightedList<PartialEntity> result = new WeightedList<PartialEntity>();
                        JsonObject element2 = e.getAsJsonObject();
                        JsonObject elements = element2.get("elements").getAsJsonObject();
                        int weight = element2.get("weight").getAsInt();
                        elements.keySet().forEach(key -> PartialEntity.parse(key, true).ifPresent(entity -> result.put((PartialEntity)entity, elements.get(key).getAsInt())));
                        processor.into(result, weight);
                    }
                    return processor;
                }
                case "spawner_element": {
                    SpawnerElementTileProcessor processor = new SpawnerElementTileProcessor();
                    processor.target(object.get("target").getAsString());
                    EntityPredicate.of(object.get("element").getAsString(), true).ifPresent(processor::setElement);
                    JsonObject output = object.get("output").getAsJsonObject();
                    if (output == null) {
                        return processor;
                    }
                    output.keySet().forEach(key -> PartialEntity.parse(key, true).ifPresent(entity -> processor.into((PartialEntity)entity, output.get(key).getAsInt())));
                    return processor;
                }
                case "filter": {
                    JsonElement target = object.get("target");
                    return new FilterTileProcessor(target.getAsString());
                }
            }
            return TileProcessor.ofIdentity();
        }
        if (typeOfT == EntityProcessor.class) {
            // empty if block
        }
        return null;
    }

    public JsonElement serialize(Processor<?> src, Type typeOfSrc, JsonSerializationContext context) {
        return null;
    }
}

