/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.bounty.task;

import iskallia.vault.bounty.task.properties.KillEntityProperties;
import iskallia.vault.config.bounty.task.TaskConfig;
import iskallia.vault.config.bounty.task.entry.GenericEntry;
import iskallia.vault.config.bounty.task.entry.TaskEntry;
import iskallia.vault.config.entry.IntRangeEntry;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class KillEntityTaskConfig
extends TaskConfig<TaskEntry<EntityPredicate>, KillEntityProperties> {
    @Override
    public String getName() {
        return super.getName() + "kill_entity";
    }

    @Override
    public KillEntityProperties getGeneratedTaskProperties(int vaultLevel) {
        Object taskEntry = this.getEntry(vaultLevel);
        GenericEntry entry = ((TaskEntry)taskEntry).getRandom();
        KillEntityProperties killEntityProperties = new KillEntityProperties(EntityPredicate.of(((EntityPredicate)entry.getValue()).toString(), true).orElse(EntityPredicate.FALSE), new ArrayList<ResourceLocation>(entry.getValidDimensions()), entry.isVaultOnly(), (double)entry.getRandomAmount());
        killEntityProperties.setRewardPool(entry.getRewardPool());
        return killEntityProperties;
    }

    @Override
    protected TaskEntry<EntityPredicate> generateConfigEntry() {
        EntityPredicate skeleton = EntityPredicate.of(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)EntityType.f_20524_).toString(), true).orElse(EntityPredicate.FALSE);
        EntityPredicate zombie = EntityPredicate.of(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)EntityType.f_20501_).toString(), true).orElse(EntityPredicate.FALSE);
        EntityPredicate creeper = EntityPredicate.of(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)EntityType.f_20558_).toString(), true).orElse(EntityPredicate.FALSE);
        return new TaskEntry<EntityPredicate>(new GenericEntry<EntityPredicate>(skeleton, new IntRangeEntry(10, 50)).setValidDimensions(Set.of(Level.f_46428_.m_135782_(), Level.f_46429_.m_135782_())), 3).addEntry(new GenericEntry<EntityPredicate>(zombie, new IntRangeEntry(10, 50)).setValidDimensions(Set.of(Level.f_46428_.m_135782_(), Level.f_46429_.m_135782_())), 3).addEntry(new GenericEntry<EntityPredicate>(creeper, new IntRangeEntry(10, 50)).setValidDimensions(Set.of(Level.f_46428_.m_135782_(), Level.f_46429_.m_135782_())), 3);
    }
}

