/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.gear;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.util.data.WeightedList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;

public class VaultGearTagConfig
extends Config {
    @Expose
    private final Map<String, ModTagGroup> tags = new LinkedHashMap<String, ModTagGroup>();

    @Override
    public String getName() {
        return "gear%sgear_tags".formatted(File.separator);
    }

    @Nullable
    public ModTagGroup getGroupTag(String tag) {
        return this.tags.get(tag);
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags.keySet());
    }

    @Nullable
    public String getRandomTag() {
        WeightedList tags = new WeightedList();
        this.tags.forEach((tag, groupCfg) -> tags.add(tag, groupCfg.getWeight()));
        return (String)tags.getRandom(rand);
    }

    @Override
    protected void reset() {
        this.tags.clear();
        this.tags.put("Armor", new ModTagGroup("Armor", 4766456).addTag("ModArmor"));
    }

    public static class ModTagGroup {
        @Expose
        private List<String> tags = new ArrayList<String>();
        @Expose
        private String display;
        @Expose
        private int color;
        @Expose
        private int weight = 10;

        public ModTagGroup(String display, int color) {
            this.display = display;
            this.color = color;
        }

        public ModTagGroup addTag(String modGroup) {
            this.tags.add(modGroup);
            return this;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public String getDisplayName() {
            return this.display;
        }

        public int getColor() {
            return this.color;
        }

        public int getWeight() {
            return this.weight;
        }

        public Component getDisplayComponent() {
            return new TextComponent(this.getDisplayName()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)this.getColor())));
        }
    }
}

