/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.gear;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.ability.AbilityFloatValueAttribute;
import iskallia.vault.gear.attribute.ability.special.DashVelocityModification;
import iskallia.vault.gear.attribute.ability.special.EmpowerImmunityModification;
import iskallia.vault.gear.attribute.ability.special.EternalsSpeedModification;
import iskallia.vault.gear.attribute.ability.special.ExecuteHealthModification;
import iskallia.vault.gear.attribute.ability.special.FarmerAdditionalRangeModification;
import iskallia.vault.gear.attribute.ability.special.GhostWalkDurationModification;
import iskallia.vault.gear.attribute.ability.special.HealAdditionalHealthModification;
import iskallia.vault.gear.attribute.ability.special.HunterRangeModification;
import iskallia.vault.gear.attribute.ability.special.ManaShieldAbsorptionModification;
import iskallia.vault.gear.attribute.ability.special.MegaJumpVelocityModification;
import iskallia.vault.gear.attribute.ability.special.NovaRadiusModification;
import iskallia.vault.gear.attribute.ability.special.RampageDamageModification;
import iskallia.vault.gear.attribute.ability.special.TauntRadiusModification;
import iskallia.vault.gear.attribute.ability.special.VeinMinerAdditionalBlocksModification;
import iskallia.vault.gear.attribute.config.BooleanFlagGenerator;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.config.DoubleAttributeGenerator;
import iskallia.vault.gear.attribute.config.IntegerAttributeGenerator;
import iskallia.vault.gear.attribute.custom.EffectAvoidanceGearAttribute;
import iskallia.vault.gear.attribute.custom.EffectCloudAttribute;
import iskallia.vault.gear.attribute.custom.EffectGearAttribute;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potions;
import org.apache.commons.lang3.ObjectUtils;

public class VaultGearTierConfig
extends Config {
    public static final String NO_LEGENDARY_TAG = "noLegendary";
    private Item gearItem;
    @Expose
    private final Map<ModifierAffixTagGroup, AttributeGroup> modifierGroup = new LinkedHashMap<ModifierAffixTagGroup, AttributeGroup>();

    public static Map<Item, VaultGearTierConfig> registerConfigs() {
        HashMap<Item, VaultGearTierConfig> gearConfig = new HashMap<Item, VaultGearTierConfig>();
        List<Item> gearItems = Arrays.asList(ModItems.HELMET, ModItems.CHESTPLATE, ModItems.LEGGINGS, ModItems.BOOTS, ModItems.SWORD, ModItems.AXE, ModItems.SHIELD, ModItems.IDOL_BENEVOLENT, ModItems.IDOL_MALEVOLENCE, ModItems.IDOL_OMNISCIENT, ModItems.IDOL_TIMEKEEPER, ModItems.JEWEL, ModItems.MAGNET, ModItems.WAND, ModItems.FOCUS);
        for (Item item : gearItems) {
            gearConfig.put(item, (VaultGearTierConfig)new VaultGearTierConfig(item).readConfig());
        }
        return gearConfig;
    }

    public static Optional<VaultGearTierConfig> getConfig(Item item) {
        return Optional.ofNullable(ModConfigs.VAULT_GEAR_CONFIG.get(item));
    }

    public VaultGearTierConfig(Item gearItem) {
        this.gearItem = gearItem;
    }

    @Override
    public String getName() {
        return "gear_modifiers%s%s".formatted(File.separator, this.gearItem.getRegistryName().m_135815_());
    }

    @Nullable
    public Object getTierConfig(VaultGearModifier<?> modifier) {
        for (ModifierTier<?> modTier : this.getAllTiers(modifier.getModifierIdentifier())) {
            if (modTier.getModifierTier() != modifier.getRolledTier()) continue;
            return modTier.getModifierConfiguration();
        }
        return null;
    }

    @Nonnull
    public ModifierConfigRange getTierConfigRange(VaultGearModifier<?> modifier, int level) {
        ModifierTier<?> modifierTier;
        Object tierGroup;
        Object currentTierCfg = null;
        ModifierTier min = null;
        ModifierTier max = null;
        if (modifier.getCategory() == VaultGearModifier.AffixCategory.LEGENDARY && (tierGroup = this.getTierGroup(modifier.getModifierIdentifier())) != null && (modifierTier = ((ModifierTierGroup)tierGroup).getModifierForTier(modifier.getRolledTier())) != null) {
            Object configObject = modifierTier.getModifierConfiguration();
            return new ModifierConfigRange(configObject, configObject, configObject);
        }
        for (ModifierTier modifierTier2 : this.getAllTiers(modifier.getModifierIdentifier())) {
            if (modifierTier2.getMinLevel() > level || modifierTier2.getMaxLevel() != -1 && modifierTier2.getMaxLevel() < level) continue;
            if (modifierTier2.getModifierTier() == modifier.getRolledTier()) {
                currentTierCfg = modifierTier2.getModifierConfiguration();
            }
            if (min == null || modifierTier2.getMinLevel() < min.getMinLevel()) {
                min = modifierTier2;
            }
            if (max != null && modifierTier2.getMinLevel() <= max.getMinLevel()) continue;
            max = modifierTier2;
        }
        Object minCfg = min == null ? null : min.getModifierConfiguration();
        Object var7_10 = max == null ? null : max.getModifierConfiguration();
        return new ModifierConfigRange(currentTierCfg, minCfg, var7_10);
    }

    public Optional<ModifierOutcome<?>> getConfiguredModifierTier(ModifierAffixTagGroup affixTagGroup, ResourceLocation identifier, int modifierTier) {
        if (!this.modifierGroup.containsKey((Object)affixTagGroup)) {
            return Optional.empty();
        }
        ModifierTierGroup group = this.getTierGroup(identifier);
        if (group != null) {
            for (ModifierTier tier : group) {
                if (tier.getModifierTier() != modifierTier) continue;
                return Optional.of(new ModifierOutcome(tier, group));
            }
        }
        return Optional.empty();
    }

    public Optional<VaultGearModifier<?>> createModifier(ModifierAffixTagGroup affixTagGroup, ResourceLocation identifier, int modifierTier, Random random) {
        return this.getConfiguredModifierTier(affixTagGroup, identifier, modifierTier).map(outcome -> outcome.makeModifier(random));
    }

    public List<ModifierTier<?>> getAllTiers(@Nullable ResourceLocation identifier) {
        ModifierTierGroup group = this.getTierGroup(identifier);
        if (group != null) {
            return Collections.unmodifiableList(group);
        }
        return Collections.emptyList();
    }

    @Nullable
    public VaultGearModifier<?> generateModifier(ResourceLocation identifier, int level, Random random) {
        ModifierTierGroup group = this.getTierGroup(identifier);
        if (group != null) {
            WeightedList outcomes = new WeightedList();
            group.getModifiersForLevel(level).forEach(tier -> outcomes.add(new ModifierOutcome(tier, group), tier.getWeight()));
            return outcomes.getRandom().map(modifierOutcome -> modifierOutcome.makeModifier(random)).orElse(null);
        }
        return null;
    }

    @Nullable
    public VaultGearModifier<?> maxAndIncreaseTier(VaultGearModifier.AffixType type, VaultGearModifier<?> modifier, int level, int tierIncrease, Random random) {
        AttributeGroup attributeGroup = this.modifierGroup.get((Object)ModifierAffixTagGroup.ofAffixType(type));
        if (attributeGroup == null || attributeGroup.isEmpty()) {
            return null;
        }
        ModifierTierGroup tierGroup = this.getTierGroup(modifier.getModifierIdentifier());
        if (tierGroup == null) {
            return null;
        }
        ModifierTier<?> foundTier = tierGroup.getHighestForLevel(level);
        if (foundTier == null) {
            return null;
        }
        int index = Math.min(foundTier.getModifierTier() + tierIncrease, tierGroup.size() - 1);
        return ((ModifierTier)tierGroup.get(index)).makeModifier(tierGroup, random);
    }

    @Nullable
    public ModifierTierGroup getTierGroup(@Nullable ResourceLocation identifier) {
        for (AttributeGroup attributePool : this.modifierGroup.values()) {
            for (ModifierTierGroup group : attributePool) {
                if (!group.identifier.equals((Object)identifier)) continue;
                return group;
            }
        }
        return null;
    }

    public List<VaultGearModifier<?>> generateImplicits(int level, Random random) {
        AttributeGroup attributePool = this.modifierGroup.get((Object)ModifierAffixTagGroup.IMPLICIT);
        if (attributePool == null || attributePool.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap groupOutcomes = new HashMap();
        attributePool.forEach(group -> {
            String modGrp = Strings.isNullOrEmpty((String)group.getModifierGroup()) ? group.getIdentifier().toString() : group.getModifierGroup();
            group.getModifiersForLevel(level).forEach(tier -> groupOutcomes.computeIfAbsent(modGrp, s -> new WeightedList()).add(new ModifierOutcome(tier, (ModifierTierGroup)group), tier.getWeight()));
        });
        ArrayList modifiers = new ArrayList();
        groupOutcomes.values().forEach(outcomes -> outcomes.getRandom(random).map(outcome -> outcome.makeModifier(random)).ifPresent(modifiers::add));
        return modifiers;
    }

    public Optional<VaultGearModifier<?>> getRandomModifier(VaultGearModifier.AffixType type, int level, Random random, Set<String> excludedModGroups) {
        return this.getRandomModifier(ModifierAffixTagGroup.ofAffixType(type), level, random, excludedModGroups);
    }

    public Optional<VaultGearModifier<?>> getRandomModifier(ModifierAffixTagGroup affixTagGroup, int level, Random random, Set<String> excludedModGroups) {
        AttributeGroup attributePool = this.modifierGroup.get((Object)affixTagGroup);
        if (attributePool == null || attributePool.isEmpty()) {
            return Optional.empty();
        }
        WeightedList outcomes = new WeightedList();
        attributePool.forEach(group -> {
            if (!group.modifierGroup.isEmpty() && excludedModGroups.contains(group.modifierGroup)) {
                return;
            }
            group.getModifiersForLevel(level).forEach(tier -> outcomes.add(new ModifierOutcome(tier, (ModifierTierGroup)group), tier.getWeight()));
        });
        return outcomes.getRandom().map(modifierOutcome -> modifierOutcome.makeModifier(random));
    }

    public List<Tuple<ModifierAffixTagGroup, ModifierTierGroup>> getModifierConfigurationsByTag(String modTag) {
        ArrayList<Tuple<ModifierAffixTagGroup, ModifierTierGroup>> configs = new ArrayList<Tuple<ModifierAffixTagGroup, ModifierTierGroup>>();
        for (Map.Entry<ModifierAffixTagGroup, AttributeGroup> entry : this.modifierGroup.entrySet()) {
            if (!entry.getKey().isGenericGroup()) continue;
            for (ModifierTierGroup group : entry.getValue()) {
                if (!modTag.isEmpty() && !group.getTags().contains(modTag)) continue;
                configs.add((Tuple<ModifierAffixTagGroup, ModifierTierGroup>)new Tuple((Object)entry.getKey(), (Object)group));
            }
        }
        return configs;
    }

    @Override
    protected void reset() {
        this.modifierGroup.clear();
        AttributeGroup implicits = new AttributeGroup();
        this.modifierGroup.put(ModifierAffixTagGroup.IMPLICIT, implicits);
        ModifierTierGroup armorTierGroup = new ModifierTierGroup(ModGearAttributes.ARMOR, "ModArmor", "armor");
        armorTierGroup.add(new ModifierTier<IntegerAttributeGenerator.Range>(0, 10, new IntegerAttributeGenerator.Range(1, 2, 1)));
        armorTierGroup.add(new ModifierTier<IntegerAttributeGenerator.Range>(15, 10, new IntegerAttributeGenerator.Range(1, 2, 1)));
        armorTierGroup.add(new ModifierTier<IntegerAttributeGenerator.Range>(25, 10, new IntegerAttributeGenerator.Range(1, 2, 1)));
        ModifierTierGroup attackDamageTierGroup = new ModifierTierGroup(ModGearAttributes.ATTACK_DAMAGE, "ModAttackDamage", "attackdamage");
        attackDamageTierGroup.add(new ModifierTier<DoubleAttributeGenerator.Range>(0, 20, new DoubleAttributeGenerator.Range(1.0, 1.5)));
        attackDamageTierGroup.add(new ModifierTier<DoubleAttributeGenerator.Range>(10, 18, new DoubleAttributeGenerator.Range(1.6, 2.0)));
        attackDamageTierGroup.add(new ModifierTier<DoubleAttributeGenerator.Range>(20, 15, new DoubleAttributeGenerator.Range(2.1, 2.5)));
        ModifierTierGroup effectAvoidTierGroup = new ModifierTierGroup(ModGearAttributes.EFFECT_AVOIDANCE, "ModPoisonAvoidance", "poisonavoidance");
        effectAvoidTierGroup.add(new ModifierTier<EffectAvoidanceGearAttribute.Config>(0, 10, new EffectAvoidanceGearAttribute.Config(MobEffects.f_19614_, 0.1f, 0.2f)));
        effectAvoidTierGroup.add(new ModifierTier<EffectAvoidanceGearAttribute.Config>(15, 10, new EffectAvoidanceGearAttribute.Config(MobEffects.f_19614_, 0.21f, 0.3f)));
        AttributeGroup prefixes = new AttributeGroup();
        prefixes.add(armorTierGroup);
        prefixes.add(attackDamageTierGroup);
        prefixes.add(effectAvoidTierGroup);
        this.modifierGroup.put(ModifierAffixTagGroup.PREFIX, prefixes);
        EffectCloudAttribute.CloudConfig config = new EffectCloudAttribute.CloudConfig("Healing", Potions.f_43623_.getRegistryName(), 40, 4.0f, Color.RED.getRGB(), true, 0.05f);
        config.setAdditionalEffect(new EffectCloudAttribute.CloudEffectConfig(MobEffects.f_19601_.getRegistryName(), 20, 0));
        ModifierTierGroup effectCloudGroup = new ModifierTierGroup(ModGearAttributes.EFFECT_CLOUD, "ModRegenCloud", "regencloud");
        effectCloudGroup.add(new ModifierTier<EffectCloudAttribute.CloudConfig>(0, 10, config));
        ModifierTierGroup effectGroup = new ModifierTierGroup(ModGearAttributes.EFFECT, "ModFireEffect", "fireeffect");
        effectGroup.add(new ModifierTier<EffectGearAttribute.Config>(15, 10, new EffectGearAttribute.Config(MobEffects.f_19607_, 0)));
        ModifierTierGroup fireImmunityGroup = new ModifierTierGroup(ModGearAttributes.IS_FIRE_IMMUNE, "ModFireImmunity", "fireimmunity");
        fireImmunityGroup.add(new ModifierTier<BooleanFlagGenerator.BooleanFlag>(0, 10, new BooleanFlagGenerator.BooleanFlag(true)));
        ModifierTierGroup soulboundGroup = new ModifierTierGroup(ModGearAttributes.SOULBOUND, "ModSoulbound", "soulbound");
        soulboundGroup.add(new ModifierTier<BooleanFlagGenerator.BooleanFlag>(0, 10, new BooleanFlagGenerator.BooleanFlag(true)));
        AttributeGroup suffixes = new AttributeGroup();
        suffixes.add(effectCloudGroup);
        suffixes.add(effectGroup);
        suffixes.add(fireImmunityGroup);
        suffixes.add(soulboundGroup);
        this.modifierGroup.put(ModifierAffixTagGroup.SUFFIX, suffixes);
        AttributeGroup enhancements = new AttributeGroup();
        this.modifierGroup.put(ModifierAffixTagGroup.ABILITY_ENHANCEMENT, enhancements);
        if (this.gearItem == ModItems.HELMET) {
            this.addHelmetEnhancementConfigs();
        }
    }

    private void addHelmetEnhancementConfigs() {
        AttributeGroup enhancements = this.modifierGroup.get((Object)ModifierAffixTagGroup.ABILITY_ENHANCEMENT);
        ModifierTierGroup modDashVelocity = this.enhancementGroup(DashVelocityModification.ID);
        modDashVelocity.add(new ModifierTier(0, 10, DashVelocityModification.newConfig(0.2f)));
        modDashVelocity.add(new ModifierTier(0, 4, DashVelocityModification.newConfig(0.4f)));
        enhancements.add(modDashVelocity);
        ModifierTierGroup modEternalSpeed = this.enhancementGroup(EternalsSpeedModification.ID);
        modEternalSpeed.add(new ModifierTier(0, 10, EternalsSpeedModification.newConfig(0.35f)));
        modEternalSpeed.add(new ModifierTier(0, 4, EternalsSpeedModification.newConfig(0.6f)));
        enhancements.add(modEternalSpeed);
        ModifierTierGroup modExecuteHealth = this.enhancementGroup(ExecuteHealthModification.ID);
        modExecuteHealth.add(new ModifierTier(0, 10, ExecuteHealthModification.newConfig(0.2f)));
        modExecuteHealth.add(new ModifierTier(0, 4, ExecuteHealthModification.newConfig(0.35f)));
        enhancements.add(modExecuteHealth);
        ModifierTierGroup modFarmerRange = this.enhancementGroup(FarmerAdditionalRangeModification.ID);
        modFarmerRange.add(new ModifierTier(0, 10, FarmerAdditionalRangeModification.newConfig(4)));
        modFarmerRange.add(new ModifierTier(0, 4, FarmerAdditionalRangeModification.newConfig(10)));
        enhancements.add(modFarmerRange);
        ModifierTierGroup modGhostWalk = this.enhancementGroup(GhostWalkDurationModification.ID);
        modGhostWalk.add(new ModifierTier(0, 10, GhostWalkDurationModification.newConfig(60)));
        modGhostWalk.add(new ModifierTier(0, 4, GhostWalkDurationModification.newConfig(120)));
        enhancements.add(modGhostWalk);
        ModifierTierGroup modHealHealth = this.enhancementGroup(HealAdditionalHealthModification.ID);
        modHealHealth.add(new ModifierTier(0, 10, HealAdditionalHealthModification.newConfig(4)));
        modHealHealth.add(new ModifierTier(0, 4, HealAdditionalHealthModification.newConfig(8)));
        enhancements.add(modHealHealth);
        ModifierTierGroup modHunterRange = this.enhancementGroup(HunterRangeModification.ID);
        modHunterRange.add(new ModifierTier(0, 10, HunterRangeModification.newConfig(0.6f)));
        modHunterRange.add(new ModifierTier(0, 4, HunterRangeModification.newConfig(1.5f)));
        enhancements.add(modHunterRange);
        ModifierTierGroup modManaShield = this.enhancementGroup(ManaShieldAbsorptionModification.ID);
        modManaShield.add(new ModifierTier(0, 10, ManaShieldAbsorptionModification.newConfig(0.25f)));
        modManaShield.add(new ModifierTier(0, 4, ManaShieldAbsorptionModification.newConfig(0.6f)));
        enhancements.add(modManaShield);
        ModifierTierGroup modMegaJump = this.enhancementGroup(MegaJumpVelocityModification.ID);
        modMegaJump.add(new ModifierTier(0, 10, MegaJumpVelocityModification.newConfig(6)));
        modMegaJump.add(new ModifierTier(0, 4, MegaJumpVelocityModification.newConfig(12)));
        modMegaJump.add(new ModifierTier(0, 4, MegaJumpVelocityModification.newConfig(0)));
        enhancements.add(modMegaJump);
        ModifierTierGroup modNovaRadius = this.enhancementGroup(NovaRadiusModification.ID);
        modNovaRadius.add(new ModifierTier(0, 10, NovaRadiusModification.newConfig(0.6f)));
        modNovaRadius.add(new ModifierTier(0, 4, NovaRadiusModification.newConfig(1.4f)));
        enhancements.add(modNovaRadius);
        ModifierTierGroup modRampageDamage = this.enhancementGroup(RampageDamageModification.ID);
        modRampageDamage.add(new ModifierTier(0, 10, RampageDamageModification.newConfig(0.3f)));
        modRampageDamage.add(new ModifierTier(0, 4, RampageDamageModification.newConfig(0.65f)));
        enhancements.add(modRampageDamage);
        ModifierTierGroup modTankImmunity = this.enhancementGroup(EmpowerImmunityModification.ID);
        modTankImmunity.add(new ModifierTier(0, 4, EmpowerImmunityModification.newConfig()));
        enhancements.add(modTankImmunity);
        ModifierTierGroup modTauntRadius = this.enhancementGroup(TauntRadiusModification.ID);
        modTauntRadius.add(new ModifierTier(0, 10, TauntRadiusModification.newConfig(0.75f)));
        modTauntRadius.add(new ModifierTier(0, 4, TauntRadiusModification.newConfig(1.5f)));
        enhancements.add(modTauntRadius);
        ModifierTierGroup modVeinMiner = this.enhancementGroup(VeinMinerAdditionalBlocksModification.ID);
        modVeinMiner.add(new ModifierTier(0, 10, VeinMinerAdditionalBlocksModification.newConfig(60)));
        modVeinMiner.add(new ModifierTier(0, 4, VeinMinerAdditionalBlocksModification.newConfig(140)));
        enhancements.add(modVeinMiner);
        ModifierTierGroup modManaDash = new ModifierTierGroup(ModGearAttributes.ABILITY_MANACOST_FLAT, "ModEnhancement", "enhancement_mana_dash");
        modManaDash.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Dash", -6.0f)));
        modManaDash.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Dash", -14.0f)));
        enhancements.add(modManaDash);
        ModifierTierGroup modManaEternal = new ModifierTierGroup(ModGearAttributes.ABILITY_MANACOST_PERCENT, "ModEnhancement", "enhancement_mana_eternal");
        modManaEternal.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Summon Eternal", -0.6f)));
        modManaEternal.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Summon Eternal", -1.0f)));
        enhancements.add(modManaEternal);
        ModifierTierGroup modManaFarmer = new ModifierTierGroup(ModGearAttributes.ABILITY_MANACOST_FLAT, "ModEnhancement", "enhancement_mana_farmer");
        modManaFarmer.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Farmer", -2.0f)));
        modManaFarmer.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Farmer", -3.0f)));
        enhancements.add(modManaFarmer);
        ModifierTierGroup modManaGhostWalk = new ModifierTierGroup(ModGearAttributes.ABILITY_MANACOST_PERCENT, "ModEnhancement", "enhancement_mana_ghost_walk");
        modManaGhostWalk.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Ghost Walk", -0.3f)));
        modManaGhostWalk.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Ghost Walk", -0.8f)));
        enhancements.add(modManaGhostWalk);
        ModifierTierGroup modManaHeal = new ModifierTierGroup(ModGearAttributes.ABILITY_MANACOST_PERCENT, "ModEnhancement", "enhancement_mana_heal");
        modManaHeal.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Heal", -0.35f)));
        modManaHeal.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Heal", -0.75f)));
        enhancements.add(modManaHeal);
        ModifierTierGroup modManaHunter = new ModifierTierGroup(ModGearAttributes.ABILITY_MANACOST_FLAT, "ModEnhancement", "enhancement_mana_hunter");
        modManaHunter.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Hunter", -6.0f)));
        modManaHunter.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Hunter", -8.0f)));
        enhancements.add(modManaHunter);
        ModifierTierGroup modManaManaShield = new ModifierTierGroup(ModGearAttributes.ABILITY_MANACOST_PERCENT, "ModEnhancement", "enhancement_mana_mana_shield");
        modManaManaShield.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Mana Shield", -0.3f)));
        modManaManaShield.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Mana Shield", -0.65f)));
        enhancements.add(modManaManaShield);
        ModifierTierGroup modManaMegaJump = new ModifierTierGroup(ModGearAttributes.ABILITY_MANACOST_FLAT, "ModEnhancement", "enhancement_mana_mega_jump");
        modManaMegaJump.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Mega Jump", -8.0f)));
        modManaMegaJump.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Mega Jump", -16.0f)));
        enhancements.add(modManaMegaJump);
        ModifierTierGroup modManaNova = new ModifierTierGroup(ModGearAttributes.ABILITY_MANACOST_PERCENT, "ModEnhancement", "enhancement_mana_nova");
        modManaNova.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Nova", -0.4f)));
        modManaNova.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Nova", -0.8f)));
        enhancements.add(modManaNova);
        ModifierTierGroup modManaRampage = new ModifierTierGroup(ModGearAttributes.ABILITY_MANACOST_FLAT, "ModEnhancement", "enhancement_mana_rampage");
        modManaRampage.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Rampage", -1.0f)));
        modManaRampage.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Rampage", -2.5f)));
        enhancements.add(modManaRampage);
        ModifierTierGroup modManaTank = new ModifierTierGroup(ModGearAttributes.ABILITY_MANACOST_PERCENT, "ModEnhancement", "enhancement_mana_tank");
        modManaTank.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Empower", -0.35f)));
        modManaTank.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Empower", -0.7f)));
        enhancements.add(modManaTank);
        ModifierTierGroup modManaTaunt = new ModifierTierGroup(ModGearAttributes.ABILITY_MANACOST_PERCENT, "ModEnhancement", "enhancement_mana_taunt");
        modManaTaunt.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Taunt", -0.6f)));
        modManaTaunt.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Taunt", -1.0f)));
        enhancements.add(modManaTaunt);
        ModifierTierGroup modCoolDownDash = new ModifierTierGroup(ModGearAttributes.ABILITY_COOLDOWN_PERCENT, "ModEnhancement", "enhancement_cooldown_dash");
        modCoolDownDash.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Dash", -0.25f)));
        modCoolDownDash.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Dash", -0.6f)));
        enhancements.add(modCoolDownDash);
        ModifierTierGroup modCoolDownEternal = new ModifierTierGroup(ModGearAttributes.ABILITY_COOLDOWN_PERCENT, "ModEnhancement", "enhancement_cooldown_eternal");
        modCoolDownEternal.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Summon Eternal", -0.2f)));
        modCoolDownEternal.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Summon Eternal", -0.45f)));
        enhancements.add(modCoolDownEternal);
        ModifierTierGroup modCoolDownExecute = new ModifierTierGroup(ModGearAttributes.ABILITY_COOLDOWN_PERCENT, "ModEnhancement", "enhancement_cooldown_execute");
        modCoolDownExecute.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Execute", -0.3f)));
        modCoolDownExecute.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Execute", -0.5f)));
        enhancements.add(modCoolDownExecute);
        ModifierTierGroup modCoolDownFarmer = new ModifierTierGroup(ModGearAttributes.ABILITY_COOLDOWN_PERCENT, "ModEnhancement", "enhancement_cooldown_farmer");
        modCoolDownFarmer.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Farmer", -0.6f)));
        modCoolDownFarmer.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Farmer", -1.0f)));
        enhancements.add(modCoolDownFarmer);
        ModifierTierGroup modCoolDownGhostWalk = new ModifierTierGroup(ModGearAttributes.ABILITY_COOLDOWN_PERCENT, "ModEnhancement", "enhancement_cooldown_ghost_walk");
        modCoolDownGhostWalk.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Ghost Walk", -0.25f)));
        modCoolDownGhostWalk.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Ghost Walk", -0.5f)));
        enhancements.add(modCoolDownGhostWalk);
        ModifierTierGroup modCoolDownHeal = new ModifierTierGroup(ModGearAttributes.ABILITY_COOLDOWN_FLAT, "ModEnhancement", "enhancement_cooldown_heal");
        modCoolDownHeal.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Heal", -50.0f)));
        modCoolDownHeal.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Heal", -120.0f)));
        enhancements.add(modCoolDownHeal);
        ModifierTierGroup modCoolDownHunter = new ModifierTierGroup(ModGearAttributes.ABILITY_COOLDOWN_PERCENT, "ModEnhancement", "enhancement_cooldown_hunter");
        modCoolDownHunter.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Hunter", -0.3f)));
        modCoolDownHunter.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Hunter", -0.5f)));
        enhancements.add(modCoolDownHunter);
        ModifierTierGroup modCoolDownManaShield = new ModifierTierGroup(ModGearAttributes.ABILITY_COOLDOWN_FLAT, "ModEnhancement", "enhancement_cooldown_hunter");
        modCoolDownManaShield.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Mana Shield", -180.0f)));
        modCoolDownManaShield.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Mana Shield", -340.0f)));
        enhancements.add(modCoolDownManaShield);
        ModifierTierGroup modCoolDownMegaJump = new ModifierTierGroup(ModGearAttributes.ABILITY_COOLDOWN_FLAT, "ModEnhancement", "enhancement_cooldown_mega_jump");
        modCoolDownMegaJump.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Mega Jump", -80.0f)));
        modCoolDownMegaJump.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Mega Jump", -140.0f)));
        enhancements.add(modCoolDownMegaJump);
        ModifierTierGroup modCoolDownNova = new ModifierTierGroup(ModGearAttributes.ABILITY_COOLDOWN_FLAT, "ModEnhancement", "enhancement_cooldown_nova");
        modCoolDownNova.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Nova", -60.0f)));
        modCoolDownNova.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Nova", -120.0f)));
        enhancements.add(modCoolDownNova);
        ModifierTierGroup modCoolDownRampage = new ModifierTierGroup(ModGearAttributes.ABILITY_COOLDOWN_PERCENT, "ModEnhancement", "enhancement_cooldown_rampage");
        modCoolDownRampage.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Rampage", -0.3f)));
        modCoolDownRampage.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Rampage", -0.7f)));
        enhancements.add(modCoolDownRampage);
        ModifierTierGroup modCoolDownTank = new ModifierTierGroup(ModGearAttributes.ABILITY_COOLDOWN_PERCENT, "ModEnhancement", "enhancement_cooldown_tank");
        modCoolDownTank.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Empower", -0.3f)));
        modCoolDownTank.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Empower", -0.7f)));
        enhancements.add(modCoolDownTank);
        ModifierTierGroup modCoolDownTaunt = new ModifierTierGroup(ModGearAttributes.ABILITY_COOLDOWN_PERCENT, "ModEnhancement", "enhancement_cooldown_taunt");
        modCoolDownTaunt.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 10, new AbilityFloatValueAttribute.Config("Taunt", -0.25f)));
        modCoolDownTaunt.add(new ModifierTier<AbilityFloatValueAttribute.Config>(0, 4, new AbilityFloatValueAttribute.Config("Taunt", -0.4f)));
        enhancements.add(modCoolDownTaunt);
    }

    private ModifierTierGroup enhancementGroup(ResourceLocation idSpecialModification) {
        return new ModifierTierGroup(ModGearAttributes.ABILITY_SPECIAL_MODIFICATION, "ModEnhancement", "enhancement_" + idSpecialModification.m_135815_());
    }

    @Override
    protected boolean isValid() {
        HashSet<ResourceLocation> foundIdentifiers = new HashSet<ResourceLocation>();
        for (AttributeGroup group : this.modifierGroup.values()) {
            for (ModifierTierGroup tierGroup : group) {
                if (foundIdentifiers.add(tierGroup.identifier)) continue;
                throw new IllegalArgumentException("Invalid Gear configuration (%s) - duplicate identifier found: %s".formatted(this.getName(), tierGroup.identifier.toString()));
            }
        }
        return true;
    }

    @Override
    protected void onLoad(Config oldConfigInstance) {
        super.onLoad(oldConfigInstance);
        if (oldConfigInstance instanceof VaultGearTierConfig) {
            VaultGearTierConfig cfg = (VaultGearTierConfig)oldConfigInstance;
            this.gearItem = cfg.gearItem;
        }
    }

    public static class ModifierTier<T> {
        private final int minLevel;
        private int maxLevel = -1;
        private final int weight;
        private int modifierTier = -1;
        private T modifierConfiguration;

        public ModifierTier(int minLevel, int weight) {
            this(minLevel, weight, null);
        }

        public ModifierTier(int minLevel, int weight, T defaultConfig) {
            this.minLevel = minLevel;
            this.weight = weight;
            this.modifierConfiguration = defaultConfig;
        }

        public int getMinLevel() {
            return this.minLevel;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getModifierTier() {
            return this.modifierTier;
        }

        public T getModifierConfiguration() {
            return this.modifierConfiguration;
        }

        public <C> VaultGearModifier<C> makeModifier(ModifierTierGroup tierGroup, Random random) {
            VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(tierGroup.getAttribute());
            ConfigurableAttributeGenerator<?, ?> generator = attribute.getGenerator();
            Object value = generator.generateRandomValue(this.getModifierConfiguration(), random);
            VaultGearModifier modifier = new VaultGearModifier(attribute, value);
            modifier.setRolledTier(this.getModifierTier());
            modifier.setModifierGroup((String)ObjectUtils.firstNonNull((Object[])new String[]{tierGroup.modifierGroup, ""}));
            modifier.setModifierIdentifier(tierGroup.identifier);
            return modifier;
        }
    }

    public static class ModifierTierGroup
    extends ArrayList<ModifierTier<?>> {
        private final ResourceLocation attribute;
        private final String modifierGroup;
        private final ResourceLocation identifier;
        private final List<String> tags = new ArrayList<String>();

        public ModifierTierGroup(VaultGearAttribute<?> attribute, String modifierGroup, String identifierStr) {
            this(attribute.getRegistryName(), modifierGroup, VaultMod.id(identifierStr));
        }

        public ModifierTierGroup(ResourceLocation attribute, String modifierGroup, ResourceLocation identifier) {
            this.attribute = attribute;
            this.modifierGroup = modifierGroup;
            this.identifier = identifier;
        }

        public List<ModifierTier<?>> getModifiersForLevel(int level) {
            ArrayList list = new ArrayList();
            for (ModifierTier tier : this) {
                if (tier.getMinLevel() > level || tier.getMaxLevel() != -1 && level > tier.getMaxLevel()) continue;
                list.add(tier);
            }
            return list;
        }

        @Nullable
        public ModifierTier<?> getHighestForLevel(int level) {
            ModifierTier highest = null;
            for (ModifierTier tier : this) {
                if (tier.getMinLevel() > level || highest != null && highest.getMinLevel() >= tier.getMinLevel()) continue;
                highest = tier;
            }
            return highest;
        }

        @Nullable
        public ModifierTier<?> getModifierForTier(int tier) {
            for (ModifierTier modifierTier : this) {
                if (modifierTier.modifierTier != tier) continue;
                return modifierTier;
            }
            return null;
        }

        public ResourceLocation getAttribute() {
            return this.attribute;
        }

        public String getModifierGroup() {
            return this.modifierGroup;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public ResourceLocation getIdentifier() {
            return this.identifier;
        }
    }

    public record ModifierConfigRange(@Nullable Object tierConfig, @Nullable Object minAvailableConfig, @Nullable Object maxAvailableConfig) {
        public static ModifierConfigRange empty() {
            return new ModifierConfigRange(null, null, null);
        }
    }

    public record ModifierOutcome<C>(ModifierTier<C> tier, ModifierTierGroup tierGroup) {
        public <T> VaultGearModifier<T> makeModifier(Random random) {
            return this.tier().makeModifier(this.tierGroup(), random);
        }
    }

    public static enum ModifierAffixTagGroup {
        IMPLICIT(VaultGearModifier.AffixType.IMPLICIT),
        PREFIX(VaultGearModifier.AffixType.PREFIX),
        SUFFIX(VaultGearModifier.AffixType.SUFFIX),
        ABILITY_ENHANCEMENT(VaultGearModifier.AffixType.IMPLICIT),
        CRAFTED_PREFIX(VaultGearModifier.AffixType.PREFIX),
        CRAFTED_SUFFIX(VaultGearModifier.AffixType.SUFFIX);

        private final VaultGearModifier.AffixType targetAffixType;

        private ModifierAffixTagGroup(VaultGearModifier.AffixType targetAffixType) {
            this.targetAffixType = targetAffixType;
        }

        public VaultGearModifier.AffixType getTargetAffixType() {
            return this.targetAffixType;
        }

        public boolean isGenericGroup() {
            return this == IMPLICIT || this == PREFIX || this == SUFFIX;
        }

        @Nonnull
        public static ModifierAffixTagGroup ofAffixType(VaultGearModifier.AffixType type) {
            switch (type) {
                case IMPLICIT: {
                    return IMPLICIT;
                }
                case PREFIX: {
                    return PREFIX;
                }
                case SUFFIX: {
                    return SUFFIX;
                }
            }
            throw new IllegalArgumentException("Unknown AffixType: " + type.name());
        }
    }

    public static class AttributeGroup
    extends ArrayList<ModifierTierGroup> {

        public static class Serializer
        implements JsonDeserializer<AttributeGroup>,
        JsonSerializer<AttributeGroup> {
            public AttributeGroup deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonArray array = json.getAsJsonArray();
                AttributeGroup attributeGroup = new AttributeGroup();
                array.forEach(tierGroupElement -> {
                    JsonObject tierGroupObject = tierGroupElement.getAsJsonObject();
                    ResourceLocation attributeKey = new ResourceLocation(tierGroupObject.get("attribute").getAsString());
                    VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(attributeKey);
                    if (attribute == null) {
                        throw new JsonParseException("Unknown Modifier %s".formatted(attributeKey));
                    }
                    ResourceLocation identifier = new ResourceLocation(tierGroupObject.get("identifier").getAsString());
                    ModifierTierGroup group = new ModifierTierGroup(attributeKey, tierGroupObject.get("group").getAsString(), identifier);
                    if (tierGroupObject.has("tags")) {
                        group.tags.addAll((Collection)context.deserialize(tierGroupObject.get("tags"), List.class));
                    }
                    JsonArray groupArray = tierGroupObject.getAsJsonArray("tiers");
                    for (int i = 0; i < groupArray.size(); ++i) {
                        JsonObject configObject;
                        Object patt34361$temp;
                        JsonObject tierObject = groupArray.get(i).getAsJsonObject();
                        int minLevel = tierObject.get("minLevel").getAsInt();
                        int maxLevel = tierObject.has("maxLevel") ? tierObject.get("maxLevel").getAsInt() : -1;
                        int weight = tierObject.get("weight").getAsInt();
                        ModifierTier tier = new ModifierTier(minLevel, weight);
                        tier.modifierTier = i;
                        tier.maxLevel = maxLevel;
                        Class<?> configClass = attribute.getGenerator().getConfigurationObjectClass();
                        if (configClass != null && (patt34361$temp = (tier.modifierConfiguration = context.deserialize((JsonElement)(configObject = tierObject.getAsJsonObject("value")), configClass))) instanceof ConfigurableAttributeGenerator.CustomTierConfig) {
                            ConfigurableAttributeGenerator.CustomTierConfig customCfg = (ConfigurableAttributeGenerator.CustomTierConfig)patt34361$temp;
                            customCfg.deserializeAdditional(configObject, context);
                        }
                        group.add(tier);
                    }
                    attributeGroup.add(group);
                });
                return attributeGroup;
            }

            public JsonElement serialize(AttributeGroup src, Type typeOfSrc, JsonSerializationContext context) {
                JsonArray array = new JsonArray();
                src.forEach(group -> {
                    VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(group.attribute);
                    if (attribute == null) {
                        return;
                    }
                    JsonObject groupObject = new JsonObject();
                    groupObject.addProperty("attribute", group.attribute.toString());
                    groupObject.addProperty("group", group.modifierGroup);
                    groupObject.addProperty("identifier", group.identifier.toString());
                    groupObject.add("tags", context.serialize(group.tags, List.class));
                    JsonArray groupArray = new JsonArray();
                    group.forEach(modifierTier -> {
                        JsonObject tierObject = new JsonObject();
                        tierObject.addProperty("minLevel", (Number)modifierTier.getMinLevel());
                        tierObject.addProperty("maxLevel", (Number)modifierTier.getMaxLevel());
                        tierObject.addProperty("weight", (Number)modifierTier.getWeight());
                        if (attribute.getGenerator().getConfigurationObjectClass() != null) {
                            Object configuration = modifierTier.getModifierConfiguration();
                            JsonObject configObject = context.serialize(configuration).getAsJsonObject();
                            if (configuration instanceof ConfigurableAttributeGenerator.CustomTierConfig) {
                                ConfigurableAttributeGenerator.CustomTierConfig customCfg = (ConfigurableAttributeGenerator.CustomTierConfig)configuration;
                                customCfg.serializeAdditional(configObject, context);
                            }
                            tierObject.add("value", (JsonElement)configObject);
                        }
                        groupArray.add((JsonElement)tierObject);
                    });
                    groupObject.add("tiers", (JsonElement)groupArray);
                    array.add((JsonElement)groupObject);
                });
                return array;
            }
        }
    }
}

