/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.quest;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.DescriptionData;
import iskallia.vault.config.quest.SkyVaultQuestConfig;
import iskallia.vault.core.SkyVaultsChunkGenerator;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.quest.base.InVaultQuest;
import iskallia.vault.quest.base.Quest;
import iskallia.vault.quest.type.AnvilQuest;
import iskallia.vault.quest.type.BlockInteractionQuest;
import iskallia.vault.quest.type.BountyCompleteQuest;
import iskallia.vault.quest.type.CollectionQuest;
import iskallia.vault.quest.type.CraftingQuest;
import iskallia.vault.quest.type.EnterVaultQuest;
import iskallia.vault.quest.type.LevelUpQuest;
import iskallia.vault.quest.type.MiningQuest;
import iskallia.vault.quest.type.SurviveQuest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class QuestConfig
extends Config {
    @Expose
    private List<Quest> quests = new ArrayList<Quest>();

    public Collection<Quest> getQuests() {
        return ImmutableList.copyOf(this.quests);
    }

    @Override
    public String getName() {
        return "quest/quests";
    }

    protected void collection(String id, String name, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward questReward) {
        CollectionQuest quest = new CollectionQuest(id, name, DescriptionData.getDefault(id), VaultMod.id("gui/quests/" + id), targetId, targetProgress, unlockedBy, questReward);
        this.quests.add(quest);
    }

    protected void crafting(String id, String name, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward questReward) {
        CraftingQuest quest = new CraftingQuest(id, name, DescriptionData.getDefault(id), VaultMod.id("gui/quests/" + id), targetId, targetProgress, unlockedBy, questReward);
        this.quests.add(quest);
    }

    protected void survive(String id, String name, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward questReward) {
        SurviveQuest quest = new SurviveQuest(id, name, DescriptionData.getDefault(id), VaultMod.id("gui/quests/" + id), targetId, targetProgress, unlockedBy, questReward);
        this.quests.add(quest);
    }

    protected void enterVault(String id, String name, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward questReward) {
        EnterVaultQuest quest = new EnterVaultQuest(id, name, DescriptionData.getDefault(id), VaultMod.id("gui/quests/" + id), targetId, targetProgress, unlockedBy, questReward);
        this.quests.add(quest);
    }

    protected void anvil(String id, String name, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward questReward) {
        AnvilQuest quest = new AnvilQuest(id, name, DescriptionData.getDefault(id), VaultMod.id("gui/quests/" + id), targetId, targetProgress, unlockedBy, questReward);
        this.quests.add(quest);
    }

    protected void mining(String id, String name, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward questReward) {
        MiningQuest quest = new MiningQuest(id, name, DescriptionData.getDefault(id), VaultMod.id("gui/quests/" + id), targetId, targetProgress, unlockedBy, questReward);
        this.quests.add(quest);
    }

    protected void bounty(String id, String name, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward questReward) {
        BountyCompleteQuest quest = new BountyCompleteQuest(id, name, DescriptionData.getDefault(id), VaultMod.id("gui/quests/" + id), targetId, targetProgress, unlockedBy, questReward);
        this.quests.add(quest);
    }

    protected void levelUp(String id, String name, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward questReward) {
        LevelUpQuest quest = new LevelUpQuest(id, name, DescriptionData.getDefault(id), VaultMod.id("gui/quests/" + id), targetId, targetProgress, unlockedBy, questReward);
        this.quests.add(quest);
    }

    protected void blockInteract(String id, String name, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward questReward) {
        BlockInteractionQuest quest = new BlockInteractionQuest(id, name, DescriptionData.getDefault(id), VaultMod.id("gui/quests/" + id), targetId, targetProgress, unlockedBy, questReward);
        this.quests.add(quest);
    }

    @Override
    protected void reset() {
        this.collection("find_chromatic_iron", "Find Chromatic Iron", ModItems.RAW_CHROMATIC_IRON.getRegistryName(), 16.0f, "", new Quest.QuestReward(List.of(new ItemStack((ItemLike)ModItems.CHROMATIC_IRON_INGOT, 16)), 0));
        this.mining("mine_vault_stone", "Mine Vault Stone", ModBlocks.VAULT_STONE.getRegistryName(), 8.0f, "find_chromatic_iron", new Quest.QuestReward(List.of(new ItemStack((ItemLike)ModItems.CHIPPED_VAULT_ROCK, 8)), 0));
        this.crafting("craft_vault_altar", "Craft a Vault Altar", ModBlocks.VAULT_ALTAR.getRegistryName(), 1.0f, "mine_vault_stone", new Quest.QuestReward(List.of(new ItemStack((ItemLike)ModItems.VAULT_ROCK, 1)), 0));
        this.crafting("craft_vault_rock", "Craft a Vault Rock", ModItems.VAULT_ROCK.getRegistryName(), 1.0f, "craft_vault_altar", new Quest.QuestReward(this.defaultReward(), 0));
        this.collection("complete_vault_crystal", "Complete a Vault Crystal", ModItems.VAULT_CRYSTAL.getRegistryName(), 1.0f, "craft_vault_rock", new Quest.QuestReward(List.of(new ItemStack((ItemLike)ModItems.SKILL_ORB, 1)), 0));
        this.enterVault("enter_vault", "Enter a Vault", QuestConfig.anyId(), 1.0f, "complete_vault_crystal", new Quest.QuestReward(List.of(new ItemStack((ItemLike)ModBlocks.BOUNTY_BLOCK, 1)), 0));
        this.bounty("complete_bounty", "Complete a Bounty", QuestConfig.anyId(), 1.0f, "enter_vault", new Quest.QuestReward(List.of(new ItemStack((ItemLike)ModItems.HELMET, 1), new ItemStack((ItemLike)ModItems.CHESTPLATE, 1), new ItemStack((ItemLike)ModItems.LEGGINGS, 1), new ItemStack((ItemLike)ModItems.BOOTS, 1)), 0));
        this.crafting("craft_tool_station", "Craft a Tool Station", ModBlocks.TOOL_STATION.getRegistryName(), 1.0f, "complete_bounty", new Quest.QuestReward(List.of(ModItems.JEWEL.defaultItem(), new ItemStack((ItemLike)ModItems.GEMSTONE, 1)), 0));
        this.anvil("apply_jewel", "Apply a Jewel", ModItems.JEWEL.getRegistryName(), 1.0f, "craft_tool_station", new Quest.QuestReward(List.of(ModItems.JEWEL.defaultItem()), 0));
        this.levelUp("level_up", "Gain a Vault Level", QuestConfig.anyId(), 1.0f, "apply_jewel", new Quest.QuestReward(this.defaultReward(), 0));
        this.crafting("craft_forge", "Craft a Vault Forge", ModBlocks.VAULT_FORGE.getRegistryName(), 1.0f, "level_up", new Quest.QuestReward(List.of(new ItemStack((ItemLike)ModItems.VAULT_ALLOY, 4)), 0));
        this.crafting("craft_artisan", "Craft an Artisan Station", ModBlocks.VAULT_ARTISAN_STATION.getRegistryName(), 1.0f, "craft_forge", new Quest.QuestReward(List.of(new ItemStack((ItemLike)ModBlocks.VAULT_BRONZE, 16), new ItemStack((ItemLike)ModItems.VAULT_PLATING, 4)), 0));
        this.crafting("craft_recycler", "Craft a Vault Recycler", ModBlocks.VAULT_RECYCLER.getRegistryName(), 1.0f, "craft_artisan", new Quest.QuestReward(List.of(new ItemStack((ItemLike)ModItems.VAULT_SCRAP, 8)), 0));
        this.blockInteract("complete_god_altar", "Complete a God Altar", VaultMod.id("god_altar"), 1.0f, "craft_recycler", new Quest.QuestReward(this.defaultReward(), 0));
        this.crafting("craft_black_market", "Craft a Black Market", ModBlocks.BLACK_MARKET.getRegistryName(), 1.0f, "complete_god_altar", new Quest.QuestReward(List.of(new ItemStack((ItemLike)ModItems.SOUL_SHARD, 32)), 0));
        this.crafting("craft_knowledge_star", "Craft a Knowledge Star", ModItems.KNOWLEDGE_STAR.getRegistryName(), 1.0f, "craft_black_market", new Quest.QuestReward(this.defaultReward(), 0));
        this.levelUp("reach_level_20", "Reach Level 20", QuestConfig.anyId(), 1.0f, "craft_knowledge_star", new Quest.QuestReward(List.of(ModItems.SKILL_ORB.m_7968_(), ModItems.KNOWLEDGE_STAR.m_7968_(), new ItemStack((ItemLike)ModItems.KEY_PIECE, 8), ModItems.KEY_MOULD.m_7968_()), 0));
        this.onLoad(null);
    }

    @NotNull
    protected List<ItemStack> defaultReward() {
        return List.of(Items.f_42415_.m_7968_());
    }

    @NotNull
    protected static ResourceLocation anyId() {
        return VaultMod.id("any");
    }

    @Override
    public <T extends Config> T readConfig() {
        QuestConfig config = (QuestConfig)super.readConfig();
        config.getQuests().stream().map(Quest::getDescriptionElement).forEach(jsonElement -> ModConfigs.COLORS.replaceColorStrings((JsonElement)jsonElement));
        return (T)config;
    }

    @Override
    protected void onLoad(Config oldConfigInstance) {
        Collections.sort(this.quests);
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        if (overworld == null) {
            return;
        }
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        boolean isSkyVault = SkyVaultsChunkGenerator.matches((Level)overworld);
        if (isSkyVault && this instanceof SkyVaultQuestConfig) {
            this.quests.stream().filter(quest -> !(quest instanceof InVaultQuest)).forEach(arg_0 -> ((IEventBus)eventBus).register(arg_0));
        } else if (!isSkyVault && !(this instanceof SkyVaultQuestConfig)) {
            this.quests.stream().filter(quest -> !(quest instanceof InVaultQuest)).forEach(arg_0 -> ((IEventBus)eventBus).register(arg_0));
        }
    }

    @Override
    public void onUnload() {
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        this.quests.forEach(arg_0 -> ((IEventBus)eventBus).unregister(arg_0));
    }

    public <G extends Quest> Optional<G> getQuestById(String id) {
        return this.getQuests().stream().filter(goal -> goal.getId().equals(id)).findFirst();
    }

    public <G extends Quest> G getNextQuest(Quest current) {
        return this.getNextQuest(current.getId());
    }

    public <G extends Quest> G getNextQuest(String currentId) {
        return (G)((Quest)this.getQuests().stream().filter(quest -> quest.getUnlockedBy().equals(currentId)).findFirst().orElse(null));
    }
}

