/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.recipe;

import iskallia.vault.config.Config;
import iskallia.vault.config.entry.recipe.ConfigForgeRecipe;
import iskallia.vault.config.recipe.ForgeRecipeType;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ForgeRecipeSyncMessage;
import java.io.File;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public abstract class ForgeRecipesConfig<T extends ConfigForgeRecipe<V>, V extends VaultForgeRecipe>
extends Config {
    private final ForgeRecipeType recipeType;

    protected ForgeRecipesConfig(ForgeRecipeType recipeType) {
        this.recipeType = recipeType;
    }

    @Override
    public String getName() {
        return "recipes%s%s_recipes".formatted(File.separator, this.recipeType.name().toLowerCase(Locale.ROOT));
    }

    protected abstract List<T> getConfigRecipes();

    @Nullable
    public V getRecipe(ResourceLocation id) {
        for (ConfigForgeRecipe recipe : this.getConfigRecipes()) {
            if (!id.equals((Object)recipe.getId())) continue;
            return (V)recipe.makeRecipe();
        }
        return null;
    }

    public <C extends Config> C readConfig() {
        Object cfg = super.readConfig();
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        if (srv != null) {
            srv.m_6846_().m_11314_().forEach(player -> this.syncTo((ForgeRecipesConfig)cfg, (ServerPlayer)player));
        }
        return (C)cfg;
    }

    public void syncTo(ForgeRecipesConfig<?, ?> cfg, ServerPlayer player) {
        ModNetwork.CHANNEL.sendTo((Object)ForgeRecipeSyncMessage.fromConfig(cfg.getConfigRecipes(), this.recipeType), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

