/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.block.entity.AscensionForgeTileEntity;
import iskallia.vault.config.AscensionForgeConfig;
import iskallia.vault.container.inventory.AscensionForgeInventory;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.oversized.OverSizedTabSlot;
import iskallia.vault.container.slot.RecipeOutputSlot;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.container.spi.AbstractElementContainer;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSlotIcons;
import iskallia.vault.world.data.DiscoveredModelsData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AscensionForgeContainer
extends OverSizedSlotContainer {
    protected AscensionForgeInventory internalInventory;
    protected AbstractElementContainer.SlotIndexRange playerInventoryIndexRange;
    protected AbstractElementContainer.SlotIndexRange hotbarIndexRange;
    protected AbstractElementContainer.SlotIndexRange internalInventoryIndexRange;
    private ItemStack previewItemStack = ItemStack.f_41583_;
    protected ResourceLocation selectedModelId;
    private final AscensionForgeTileEntity tileEntity;
    private final BlockPos tilePos;
    private int cost = Integer.MAX_VALUE;

    public AscensionForgeContainer(int id, Level level, BlockPos pos, Inventory playerInventory) {
        super(ModContainers.ASCENSION_FORGE_CONTAINER, id, playerInventory.f_35978_);
        this.tilePos = pos;
        BlockEntity tile = level.m_7702_(this.tilePos);
        if (tile instanceof AscensionForgeTileEntity) {
            AscensionForgeTileEntity ascensionForgeTileEntity;
            this.tileEntity = ascensionForgeTileEntity = (AscensionForgeTileEntity)tile;
            this.initInventory();
        } else {
            this.tileEntity = null;
        }
    }

    private void initInventory() {
        this.internalInventory = this.tileEntity.getInternalInventory();
        this.internalInventory.m_5785_(this.player);
        int offsetX = 0;
        int offsetY = 0;
        int containerSlotIndex = 0;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = column + (row + 1) * 9;
                int x = 8 + column * 18 + offsetX;
                int y = 84 + row * 18 + offsetY;
                this.m_38897_(new TabSlot((Container)this.player.m_150109_(), index, x, y));
                ++containerSlotIndex;
            }
        }
        this.playerInventoryIndexRange = new AbstractElementContainer.SlotIndexRange(0, containerSlotIndex);
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            int x = 8 + hotbarSlot * 18 + offsetX;
            int y = 142 + offsetY;
            this.m_38897_(new TabSlot((Container)this.player.m_150109_(), hotbarSlot, x, y));
            ++containerSlotIndex;
        }
        this.hotbarIndexRange = new AbstractElementContainer.SlotIndexRange(this.playerInventoryIndexRange.end(), containerSlotIndex);
        this.m_38897_(new OverSizedTabSlot(this.internalInventory, 0, 92, 61){

            public void m_6654_() {
                super.m_6654_();
                AscensionForgeContainer.this.m_6199_(this.f_40218_);
            }
        }.setFilter(itemStack -> itemStack.m_41720_() == ModItems.EMBER).setBackground(InventoryMenu.f_39692_, ModSlotIcons.EMBER_NO_ITEM));
        ++containerSlotIndex;
        this.m_38897_(new RecipeOutputSlot(this.internalInventory, this.internalInventory.outputSlotIndex(), 152, 61){

            public void m_6654_() {
                super.m_6654_();
                AscensionForgeContainer.this.m_6199_(this.f_40218_);
            }
        });
        this.internalInventoryIndexRange = new AbstractElementContainer.SlotIndexRange(this.hotbarIndexRange.end(), ++containerSlotIndex);
    }

    public AscensionForgeInventory getInternalInventory() {
        return this.internalInventory;
    }

    public AbstractElementContainer.SlotIndexRange getInternalInventoryIndexRange() {
        return this.internalInventoryIndexRange;
    }

    public ResourceLocation getSelectedModelId() {
        return this.selectedModelId;
    }

    public void selectItem(@Nullable ResourceLocation modelId, ItemStack previewItemStack) {
        this.selectedModelId = modelId;
        this.cost = ModConfigs.ASCENSION_FORGE.getListings().stream().filter(listing -> {
            if (listing.modelId() != null) {
                return listing.modelId().equals((Object)this.selectedModelId);
            }
            return ItemStack.m_150942_((ItemStack)listing.stack(), (ItemStack)previewItemStack);
        }).findFirst().map(AscensionForgeConfig.AscensionForgeListing::cost).orElse(Integer.MAX_VALUE);
        if (modelId == null) {
            this.previewItemStack = previewItemStack;
            return;
        }
        ModDynamicModels.REGISTRIES.getModelAndAssociatedItem(modelId).ifPresent(pair -> {
            Item item = (Item)pair.getSecond();
            if (!(item instanceof VaultGearItem)) {
                this.previewItemStack = ItemStack.f_41583_;
                return;
            }
            this.previewItemStack = new ItemStack((ItemLike)item);
            VaultGearData gearData = VaultGearData.read(this.previewItemStack);
            gearData.setState(VaultGearState.IDENTIFIED);
            gearData.updateAttribute(ModGearAttributes.GEAR_MODEL, modelId);
            gearData.write(this.previewItemStack);
        });
    }

    public ItemStack getPreviewItemStack() {
        return this.previewItemStack;
    }

    public boolean priceFulfilled() {
        Slot emberSlot = this.m_38853_(this.internalInventoryIndexRange.getContainerIndex(0));
        return emberSlot.m_6657_() && emberSlot.m_7993_().m_150930_((Item)ModItems.EMBER) && emberSlot.m_7993_().m_41613_() >= this.emberCost();
    }

    public int emberCost() {
        return this.cost;
    }

    public void m_6199_(Container pInventory) {
        this.tileEntity.m_6596_();
        super.m_6199_(pInventory);
    }

    public boolean m_6875_(@Nonnull Player player) {
        if (this.tileEntity == null) {
            return false;
        }
        return this.tileEntity.stillValid(player);
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.internalInventory.m_5785_(player);
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.moveOverSizedItemStackTo(slotStack, slot, 36, this.f_38839_.size(), false)) {
                return itemstack;
            }
            if (index >= 0 && index < 27 ? !this.moveOverSizedItemStackTo(slotStack, slot, 27, 36, false) : (index >= 27 && index < 36 ? !this.moveOverSizedItemStackTo(slotStack, slot, 0, 27, false) : !this.moveOverSizedItemStackTo(slotStack, slot, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemstack;
    }

    public void buy(ServerPlayer player) {
        if (player == null) {
            return;
        }
        if (this.previewItemStack.m_41619_() || !this.priceFulfilled()) {
            return;
        }
        if (this.selectedModelId != null) {
            DiscoveredModelsData discoveredModelsData = DiscoveredModelsData.get(player.m_183503_());
            discoveredModelsData.discoverModelAndBroadcast(this.previewItemStack.m_41720_(), this.selectedModelId, (Player)player);
            Slot inputSlot = this.m_38853_(this.getInternalInventoryIndexRange().getContainerIndex(0));
            ItemStack emberStack = inputSlot.m_7993_();
            emberStack.m_41774_(this.emberCost());
            inputSlot.m_5852_(emberStack);
        } else {
            Slot outputSlot = this.m_38853_(this.getInternalInventoryIndexRange().getContainerIndex(this.getInternalInventory().outputSlotIndex()));
            outputSlot.m_5852_(this.previewItemStack.m_41777_());
            Slot inputSlot = this.m_38853_(this.getInternalInventoryIndexRange().getContainerIndex(0));
            ItemStack emberStack = inputSlot.m_7993_();
            emberStack.m_41774_(this.emberCost());
            inputSlot.m_5852_(emberStack);
        }
    }
}

