/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.block.entity.RelicPedestalTileEntity;
import iskallia.vault.container.inventory.RelicPedestalInventory;
import iskallia.vault.container.slot.RelicRecipeFragmentSlot;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.container.spi.AbstractElementContainer;
import iskallia.vault.dynamodel.DynamicModelItem;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModRelics;
import iskallia.vault.util.EntityHelper;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class RelicPedestalContainer
extends AbstractElementContainer {
    protected RelicPedestalInventory internalInventory;
    protected AbstractElementContainer.SlotIndexRange playerInventoryIndexRange;
    protected AbstractElementContainer.SlotIndexRange hotbarIndexRange;
    protected AbstractElementContainer.SlotIndexRange internalInventoryIndexRange;
    protected BlockPos pedestalPos;
    @NotNull
    protected ResourceLocation selectedRelicId = ModRelics.EMPTY.getResultingRelic();
    private final RelicPedestalTileEntity tileEntity;

    public RelicPedestalContainer(int id, Player player, BlockPos pedestalPos) {
        super(ModContainers.RELIC_PEDESTAL_CONTAINER, id, player);
        RelicPedestalTileEntity relicPedestalTileEntity;
        this.pedestalPos = pedestalPos;
        BlockEntity tile = player.m_183503_().m_7702_(this.pedestalPos);
        this.tileEntity = tile instanceof RelicPedestalTileEntity ? (relicPedestalTileEntity = (RelicPedestalTileEntity)tile) : null;
        this.internalInventory = new RelicPedestalInventory(this.tileEntity);
        int offsetX = 0;
        int offsetY = 0;
        int containerSlotIndex = 0;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = column + (row + 1) * 9;
                int x = 8 + column * 18 + offsetX;
                int y = 84 + row * 18 + offsetY;
                this.m_38897_(new TabSlot((Container)player.m_150109_(), index, x, y));
                ++containerSlotIndex;
            }
        }
        this.playerInventoryIndexRange = new AbstractElementContainer.SlotIndexRange(0, containerSlotIndex);
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            int x = 8 + hotbarSlot * 18 + offsetX;
            int y = 142 + offsetY;
            this.m_38897_(new TabSlot((Container)player.m_150109_(), hotbarSlot, x, y));
            ++containerSlotIndex;
        }
        this.hotbarIndexRange = new AbstractElementContainer.SlotIndexRange(this.playerInventoryIndexRange.end(), containerSlotIndex);
        for (int i = 0; i < this.internalInventory.getInputSlotCount(); ++i) {
            this.m_38897_(new RelicRecipeFragmentSlot(() -> ModRelics.RECIPE_REGISTRY.get(this.selectedRelicId), this.internalInventory, i, 8 + 18 * i, 61));
            ++containerSlotIndex;
        }
        this.internalInventoryIndexRange = new AbstractElementContainer.SlotIndexRange(this.hotbarIndexRange.end(), containerSlotIndex);
    }

    public RelicPedestalInventory getInternalInventory() {
        return this.internalInventory;
    }

    @Nonnull
    public ResourceLocation getSelectedRelicId() {
        return this.selectedRelicId;
    }

    public BlockPos getPedestalPos() {
        return this.pedestalPos;
    }

    public boolean recipeFulfilled() {
        ModRelics.RelicRecipe relicRecipe = ModRelics.RECIPE_REGISTRY.get(this.selectedRelicId);
        if (relicRecipe == null) {
            return false;
        }
        for (int i = 0; i < this.internalInventory.getInputSlotCount(); ++i) {
            ItemStack itemStack = this.internalInventory.m_8020_(i);
            if (itemStack.m_41619_()) {
                return false;
            }
            ResourceLocation fragmentId = DynamicModelItem.getGenericModelId(itemStack).orElse(null);
            if (fragmentId == null) {
                return false;
            }
            if (relicRecipe.getFragments().contains(fragmentId)) continue;
            return false;
        }
        return true;
    }

    public void selectRelic(ResourceLocation selectedRelicId) {
        this.selectedRelicId = selectedRelicId;
    }

    public boolean m_6875_(@Nonnull Player player) {
        if (this.tileEntity == null) {
            return false;
        }
        return this.tileEntity.stillValid(player);
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.internalInventory.forEachInput(relativeIndex -> {
            ItemStack itemStack = this.internalInventory.m_8020_((int)relativeIndex);
            if (!itemStack.m_41619_()) {
                EntityHelper.giveItem(player, itemStack);
            }
        });
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.m_38903_(slotStack, 36, this.f_38839_.size(), false)) {
                return itemstack;
            }
            if (index >= 0 && index < 27 ? !this.m_38903_(slotStack, 27, 36, false) : (index >= 27 && index < 36 ? !this.m_38903_(slotStack, 0, 27, false) : !this.m_38903_(slotStack, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemstack;
    }
}

