/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.block.SkillAltarBlock;
import iskallia.vault.block.entity.SkillAltarTileEntity;
import iskallia.vault.client.ClientAbilityData;
import iskallia.vault.client.ClientTalentData;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.oversized.OverSizedTabSlot;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.container.spi.AbstractElementContainer;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSlotIcons;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.ServerboundSkillAltarActionMessage;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerTalentsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.SkillAltarData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class SkillAltarContainer
extends OverSizedSlotContainer {
    protected final BlockPos pos;
    @Nullable
    protected SkillAltarData.SkillTemplate template;
    protected int templateIndex;
    private List<SkillAltarData.SkillIcon> skillIcons;
    protected final SkillAltarTileEntity tileEntity;

    @Nullable
    public SkillAltarData.SkillTemplate getTemplate() {
        return this.template;
    }

    protected SkillAltarContainer(MenuType<?> menuType, int id, Inventory playerInventory, BlockPos pos, @Nullable SkillAltarData.SkillTemplate template, int templateIndex, List<SkillAltarData.SkillIcon> skillIcons) {
        super(menuType, id, playerInventory.f_35978_);
        SkillAltarTileEntity abilityAtlarTile;
        BlockEntity tile;
        this.pos = pos;
        this.template = template;
        this.templateIndex = templateIndex;
        this.skillIcons = skillIcons;
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerAbilitiesData playerAbilitiesData = PlayerAbilitiesData.get(serverPlayer.m_183503_());
            playerAbilitiesData.getAbilities(this.player).sync(SkillContext.of(serverPlayer));
        }
        this.tileEntity = (tile = this.player.f_19853_.m_7702_(pos)) instanceof SkillAltarTileEntity ? (abilityAtlarTile = (SkillAltarTileEntity)tile) : null;
    }

    public boolean isEmptyTemplate() {
        return this.template == null;
    }

    public boolean m_6875_(Player pPlayer) {
        return true;
    }

    public List<SkillAltarData.SkillIcon> getSkillIcons() {
        return this.skillIcons;
    }

    public int getTemplateIndex() {
        return this.templateIndex;
    }

    public void openTab(int tabIndex) {
        ModNetwork.CHANNEL.sendToServer((Object)new ServerboundSkillAltarActionMessage(this.pos, ServerboundSkillAltarActionMessage.Action.OPEN_TAB, tabIndex));
    }

    public boolean isOpenedByNonOwner() {
        return !this.player.m_142081_().equals(this.tileEntity.getOwnerId());
    }

    public void updateTemplateIcon(SkillAltarData.SkillIcon icon) {
        Player player;
        if (!this.player.m_142081_().equals(this.tileEntity.getOwnerId())) {
            return;
        }
        if (this.player.m_183503_().m_5776_()) {
            this.player.m_5496_(SoundEvents.f_12490_, 1.0f, 1.0f);
            ModNetwork.CHANNEL.sendToServer((Object)new ServerboundSkillAltarActionMessage(this.pos, ServerboundSkillAltarActionMessage.Action.UPDATE_ICON, this.templateIndex, icon));
        }
        if ((player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SkillAltarData altarData = SkillAltarData.get(serverPlayer.m_183503_());
            altarData.updateTemplateIcon(serverPlayer.m_142081_(), this.templateIndex, icon);
            SkillAltarBlock.openGui(this.pos, serverPlayer, this.templateIndex, true);
        }
    }

    public void copyToClipboard() {
        if (this.template != null) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.template.exportToString());
        }
    }

    public void openImportScreen(int templateIndex) {
        if (this.player.m_183503_().m_5776_()) {
            this.player.m_5496_(SoundEvents.f_12490_, 1.0f, 1.0f);
            ModNetwork.CHANNEL.sendToServer((Object)new ServerboundSkillAltarActionMessage(this.pos, ServerboundSkillAltarActionMessage.Action.OPEN_IMPORT, templateIndex));
            return;
        }
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        SkillAltarBlock.openGui(this.pos, serverPlayer, templateIndex, false);
    }

    public static class Import
    extends SkillAltarContainer {
        public Import(int id, Inventory playerInventory, BlockPos pos, SkillAltarData.SkillTemplate template, int templateIndex, List<SkillAltarData.SkillIcon> skillIcons) {
            super(ModContainers.SKILL_ALTAR_IMPORT_CONTAINER, id, playerInventory, pos, template, templateIndex, skillIcons);
        }

        public void importTemplate(String input) {
            if (this.player.m_183503_().m_5776_()) {
                ModNetwork.CHANNEL.sendToServer((Object)new ServerboundSkillAltarActionMessage(this.pos, ServerboundSkillAltarActionMessage.Action.IMPORT, this.templateIndex, input));
                return;
            }
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SkillAltarData altarData = SkillAltarData.get(serverPlayer.m_183503_());
                SkillAltarData.DeserializationResult<SkillAltarData.SkillTemplate> skillTemplate = SkillAltarData.SkillTemplate.fromString(input);
                if (skillTemplate.valid()) {
                    altarData.saveSkillTemplate(serverPlayer.m_142081_(), this.templateIndex, skillTemplate.deserializedValue());
                    SkillAltarBlock.openGui(this.pos, serverPlayer, this.templateIndex, true);
                }
            }
        }
    }

    public static class Default
    extends SkillAltarContainer {
        private static final int PLAYER_INVENTORY_TOP_Y = 132;
        private AbstractElementContainer.SlotIndexRange hotbarSlotIndexRange;
        private AbstractElementContainer.SlotIndexRange inventorySlotIndexRange;
        private AbstractElementContainer.SlotIndexRange hotbarInventorySlotIndexRange;
        private AbstractElementContainer.SlotIndexRange regretOrbsIndexRange;
        private int missingRegretOrbs = -1;

        public Default(int id, Inventory playerInventory, BlockPos pos, @Nullable SkillAltarData.SkillTemplate template, int templateIndex, List<SkillAltarData.SkillIcon> skillIcons) {
            super(ModContainers.SKILL_ALTAR_CONTAINER, id, playerInventory, pos, template, templateIndex, skillIcons);
            BlockEntity tile = this.player.f_19853_.m_7702_(pos);
            if (tile instanceof SkillAltarTileEntity) {
                this.initSlots(playerInventory);
            }
        }

        protected void initSlots(Inventory playerInventory) {
            int nextSlotIndex = 0;
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 9; ++column) {
                    this.m_38897_(new TabSlot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, 132 + row * 18));
                    ++nextSlotIndex;
                }
            }
            this.inventorySlotIndexRange = new AbstractElementContainer.SlotIndexRange(0, nextSlotIndex);
            for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
                this.m_38897_(new TabSlot((Container)playerInventory, hotbarSlot, 8 + hotbarSlot * 18, 190));
                ++nextSlotIndex;
            }
            this.hotbarSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.inventorySlotIndexRange.end(), nextSlotIndex);
            this.hotbarInventorySlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.inventorySlotIndexRange.start(), this.hotbarSlotIndexRange.end());
            OverSizedTabSlot paymentSlot = new OverSizedTabSlot(this.tileEntity.getRegretOrbInventory(), 0, 105, 100);
            paymentSlot.setFilter(stack -> stack.m_41720_() == ModItems.REGRET_ORB);
            paymentSlot.setBackground(InventoryMenu.f_39692_, ModSlotIcons.REGRET_ORB_NO_ITEM);
            this.m_38897_(paymentSlot);
            this.regretOrbsIndexRange = new AbstractElementContainer.SlotIndexRange(this.hotbarInventorySlotIndexRange.end(), this.hotbarInventorySlotIndexRange.end() + 1);
        }

        public ItemStack m_7648_(Player player, int index) {
            ItemStack originalStack = ItemStack.f_41583_;
            Slot slot = (Slot)this.f_38839_.get(index);
            if (slot != null && slot.m_6657_()) {
                boolean didNotMoveAnything;
                ItemStack slotStack = slot.m_7993_().m_41777_();
                originalStack = slotStack.m_41777_();
                if (this.regretOrbsIndexRange.contains(index)) {
                    didNotMoveAnything = !this.moveOverSizedItemStackTo(slotStack, slot, this.hotbarInventorySlotIndexRange.start(), this.hotbarInventorySlotIndexRange.end(), false);
                } else if (this.hotbarSlotIndexRange.contains(index)) {
                    didNotMoveAnything = !this.m_38903_(slotStack, this.regretOrbsIndexRange.start(), this.regretOrbsIndexRange.end(), false) && !this.m_38903_(slotStack, this.inventorySlotIndexRange.start(), this.inventorySlotIndexRange.end(), false);
                } else {
                    boolean bl = didNotMoveAnything = !this.m_38903_(slotStack, this.regretOrbsIndexRange.start(), this.regretOrbsIndexRange.end(), false) && !this.m_38903_(slotStack, this.hotbarSlotIndexRange.start(), this.hotbarSlotIndexRange.end(), false);
                }
                if (didNotMoveAnything) {
                    return ItemStack.f_41583_;
                }
                if (slotStack.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
            }
            return originalStack;
        }

        @Override
        public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
            this.missingRegretOrbs = -1;
        }

        public int getNumberOfRegretOrbsRequired() {
            if (this.isEmptyTemplate()) {
                return Integer.MAX_VALUE;
            }
            return Math.max(1, (int)(ModConfigs.SKILL_ALTAR.getPerLevelCost() * (float)SidedHelper.getVaultLevel(this.player)));
        }

        public int getNumberOfMissingRegretOrbs(int unspentRegretPoints) {
            if (this.player.m_183503_().m_5776_() && this.missingRegretOrbs != -1) {
                return this.missingRegretOrbs;
            }
            int orbsRequired = this.getNumberOfRegretOrbsRequired();
            if ((orbsRequired -= unspentRegretPoints) <= 0) {
                return 0;
            }
            if ((orbsRequired -= this.tileEntity.getRegretOrbInventory().m_8020_(0).m_41613_()) <= 0) {
                return 0;
            }
            this.missingRegretOrbs = Math.max(orbsRequired -= this.player.m_150109_().m_18947_((Item)ModItems.REGRET_ORB), 0);
            return this.missingRegretOrbs;
        }

        public void setPlayerAbilitiesAndTalentsFromTemplate() {
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                int unspentRegretPoints = PlayerVaultStatsData.get(serverPlayer.m_183503_()).getVaultStats((Player)serverPlayer).getUnspentRegretPoints();
                this.setPlayerAbilitiesAndTalentsFromTemplate(unspentRegretPoints);
            }
        }

        public int getMissingSkillPoints(int unspentSkillPoints, int spentSkillPoints) {
            if (this.template == null) {
                return 0;
            }
            int cost = this.template.getAbilities().getSpentLearnPoints() + this.template.getTalents().getSpentLearnPoints();
            return cost - (unspentSkillPoints + spentSkillPoints);
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getMissingSkillPointsClient() {
            if (ClientAbilityData.getTree() == null || ClientTalentData.getTree() == null) {
                return 0;
            }
            int spent = ClientAbilityData.getTree().getSpentLearnPoints() + ClientTalentData.getTree().getSpentLearnPoints();
            return this.getMissingSkillPoints(VaultBarOverlay.unspentSkillPoints, spent);
        }

        public int getMissingSkillPointsServer() {
            if (this.template == null) {
                return 0;
            }
            int spent = PlayerAbilitiesData.get((ServerLevel)this.player.f_19853_).getAbilities(this.player).getSpentLearnPoints() + PlayerTalentsData.get((ServerLevel)this.player.f_19853_).getTalents(this.player).getSpentLearnPoints();
            return this.getMissingSkillPoints(PlayerVaultStatsData.get((ServerLevel)this.player.f_19853_).getVaultStats(this.player).getUnspentSkillPoints(), spent);
        }

        public void setPlayerAbilitiesAndTalentsFromTemplate(int unspentRegretPoints) {
            if (this.template == null || !this.player.m_142081_().equals(this.tileEntity.getOwnerId()) || this.getNumberOfMissingRegretOrbs(unspentRegretPoints) > 0) {
                return;
            }
            if (this.player.m_183503_().m_5776_() ? this.getMissingSkillPointsClient() > 0 : this.getMissingSkillPointsServer() > 0) {
                return;
            }
            if (this.player.m_183503_().m_5776_()) {
                this.player.m_5496_(ModSounds.SKILL_TREE_LEARN_SFX, 1.0f, 1.0f);
                ModNetwork.CHANNEL.sendToServer((Object)new ServerboundSkillAltarActionMessage(this.pos, ServerboundSkillAltarActionMessage.Action.LOAD, this.templateIndex));
                return;
            }
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.consumeRequiredRegretPointsOrOrbs(serverPlayer, unspentRegretPoints);
                int skillPointsBefore = PlayerAbilitiesData.get(serverPlayer.m_183503_()).getAbilities((Player)serverPlayer).getSpentLearnPoints();
                PlayerVaultStatsData statsData = PlayerVaultStatsData.get(serverPlayer.m_183503_());
                statsData.addSkillPoints(serverPlayer, skillPointsBefore += PlayerTalentsData.get(serverPlayer.m_183503_()).getTalents((Player)serverPlayer).getSpentLearnPoints());
                this.setAbilitiesFromTemplate(serverPlayer);
                this.setTalentsFromTemplate(serverPlayer);
                int skillPointsAfter = PlayerAbilitiesData.get(serverPlayer.m_183503_()).getAbilities((Player)serverPlayer).getSpentLearnPoints();
                statsData.spendSkillPoints(serverPlayer, skillPointsAfter += PlayerTalentsData.get(serverPlayer.m_183503_()).getTalents((Player)serverPlayer).getSpentLearnPoints());
                SkillAltarBlock.openGui(this.pos, serverPlayer, this.templateIndex, true);
            }
        }

        private void setTalentsFromTemplate(ServerPlayer serverPlayer) {
            ModConfigs.TALENTS.get().ifPresent(tree -> {
                PlayerTalentsData playerTalentsData = PlayerTalentsData.get(serverPlayer.m_183503_());
                TalentTree mergedTalents = (TalentTree)((Skill)this.template.getTalents().copy()).mergeFrom((Skill)tree.copy(), SkillContext.of(serverPlayer));
                playerTalentsData.setTalents((Player)serverPlayer, mergedTalents);
            });
        }

        private void setAbilitiesFromTemplate(ServerPlayer serverPlayer) {
            ModConfigs.ABILITIES.get().ifPresent(tree -> {
                PlayerAbilitiesData playerAbilitiesData = PlayerAbilitiesData.get(serverPlayer.m_183503_());
                AbilityTree mergedAbilities = (AbilityTree)((Skill)this.template.getAbilities().copy()).mergeFrom((Skill)tree.copy(), SkillContext.of(serverPlayer));
                playerAbilitiesData.setAbilities((Player)serverPlayer, mergedAbilities);
                AttributeSnapshotHelper.getInstance().refreshSnapshotDelayed(serverPlayer);
            });
        }

        private void consumeRequiredRegretPointsOrOrbs(ServerPlayer serverPlayer, int unspentRegretPoints) {
            int requiredOrbs = this.getNumberOfRegretOrbsRequired();
            PlayerVaultStatsData statsData = PlayerVaultStatsData.get(serverPlayer.m_183503_());
            statsData.spendRegretPoints(serverPlayer, Math.min(requiredOrbs, unspentRegretPoints));
            int remaining = requiredOrbs - unspentRegretPoints;
            if (remaining <= 0) {
                return;
            }
            int orbInventoryCount = this.tileEntity.getRegretOrbInventory().m_8020_(0).m_41613_();
            this.tileEntity.consumeOrbs(Math.min(remaining, orbInventoryCount));
            remaining -= orbInventoryCount;
            Inventory playerInventory = this.player.m_150109_();
            for (int slot = 0; slot < playerInventory.m_6643_() && remaining > 0; ++slot) {
                ItemStack slotStack = playerInventory.m_8020_(slot);
                if (slotStack.m_41720_() != ModItems.REGRET_ORB) continue;
                int toShrink = Math.min(remaining, slotStack.m_41613_());
                playerInventory.m_7407_(slot, toShrink);
                remaining -= toShrink;
            }
        }

        public void saveTemplate() {
            if (!this.player.m_142081_().equals(this.tileEntity.getOwnerId())) {
                return;
            }
            if (this.player.m_183503_().m_5776_()) {
                this.player.m_5496_(SoundEvents.f_12490_, 1.0f, 1.0f);
                ModNetwork.CHANNEL.sendToServer((Object)new ServerboundSkillAltarActionMessage(this.pos, ServerboundSkillAltarActionMessage.Action.SAVE, this.templateIndex));
                return;
            }
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SkillAltarData altarData = SkillAltarData.get(serverPlayer.m_183503_());
                AbilityTree abilities = PlayerAbilitiesData.get(serverPlayer.m_183503_()).getAbilities(serverPlayer.m_142081_());
                List<SpecializedSkill> sortedAbilities = abilities.getAll(SpecializedSkill.class, SpecializedSkill::isUnlocked).stream().sorted(SkillAltarData.SPECIALIZED_SKILL_HIGHEST_LEVEL_COMPARATOR).toList();
                SkillAltarData.SkillIcon icon = sortedAbilities.isEmpty() ? new SkillAltarData.SkillIcon("", false) : new SkillAltarData.SkillIcon(sortedAbilities.get(0).getSpecialization().getId(), false);
                altarData.saveSkillTemplate(serverPlayer.m_142081_(), abilities, PlayerTalentsData.get(serverPlayer.m_183503_()).getTalents(serverPlayer.m_142081_()), this.templateIndex, icon);
                SkillAltarBlock.openGui(this.pos, serverPlayer, this.templateIndex, true);
            }
        }

        public void shareInChat() {
            if (this.template == null) {
                return;
            }
            if (this.player.m_183503_().m_5776_()) {
                ModNetwork.CHANNEL.sendToServer((Object)new ServerboundSkillAltarActionMessage(this.pos, ServerboundSkillAltarActionMessage.Action.SHARE, this.templateIndex));
                return;
            }
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MutableComponent acceptTxt = new TextComponent(this.template.getIcon().key()).m_130940_(ChatFormatting.AQUA);
                acceptTxt.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to copy to clipboard"))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, this.template.exportToString())));
                MutableComponent acceptMessage = new TextComponent("Sharing skill template ").m_7220_((Component)new TextComponent("[").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)acceptTxt).m_7220_((Component)new TextComponent("]").m_130940_(ChatFormatting.GREEN));
                serverPlayer.m_20194_().m_6846_().m_11264_((Component)new TranslatableComponent("chat.type.text", new Object[]{this.player.m_5446_(), acceptMessage}), ChatType.CHAT, Util.f_137441_);
            }
        }
    }
}

