/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import com.mojang.authlib.GameProfile;
import iskallia.vault.block.entity.SpiritExtractorTileEntity;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.oversized.OverSizedTabSlot;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSlotIcons;
import iskallia.vault.network.message.ClientboundRefreshSpiritExtractorMessage;
import iskallia.vault.network.message.SpiritExtractorMessage;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.InventorySnapshot;
import iskallia.vault.world.data.PlayerSpiritRecoveryData;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;

public class SpiritExtractorContainer
extends OverSizedSlotContainer {
    private final BlockPos pos;
    private final SpiritExtractorTileEntity tileEntity;
    private boolean recycleUnlocked = false;
    private int spiritRecoveryCount = -1;
    private float multiplier = -1.0f;
    private float heroDiscount = 0.0f;
    private SpiritExtractorTileEntity.RecoveryCost currentPlayersRecoveryCost = new SpiritExtractorTileEntity.RecoveryCost();

    public SpiritExtractorContainer(int id, Inventory playerInventory, BlockPos pos) {
        super(ModContainers.SPIRIT_EXTRACTOR_CONTAINER, id, playerInventory.f_35978_);
        this.pos = pos;
        BlockEntity tile = this.player.f_19853_.m_7702_(pos);
        if (tile instanceof SpiritExtractorTileEntity) {
            SpiritExtractorTileEntity spiritExtractorTile;
            this.tileEntity = spiritExtractorTile = (SpiritExtractorTileEntity)tile;
            this.initSlots(playerInventory);
        } else {
            this.tileEntity = null;
        }
    }

    private void calculateCostForCurrentPlayer() {
        InventorySnapshot inventorySnapshot = new InventorySnapshot.Builder(this.player).setStackFilter((p, stack) -> SpiritExtractorContainer.shouldAddItem(stack)).createSnapshot();
        this.currentPlayersRecoveryCost.calculate(this.getMultiplier(), this.getPlayerLevel(), Collections.emptyList(), inventorySnapshot, this.heroDiscount, this.getRescuedBonus());
    }

    private static boolean shouldAddItem(ItemStack stack) {
        return !stack.m_41619_() && (!AttributeGearData.hasData(stack) || ((AttributeGearData)((Object)AttributeGearData.read(stack))).get(ModGearAttributes.SOULBOUND, VaultGearAttributeTypeMerger.anyTrue()) == false);
    }

    private void initSlots(Inventory playerInventory) {
        int playerInventoryTopY = 102;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new TabSlot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, playerInventoryTopY + row * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new TabSlot((Container)playerInventory, hotbarSlot, 8 + hotbarSlot * 18, playerInventoryTopY + 54 + 4));
        }
        OverSizedTabSlot paymentSlot = new OverSizedTabSlot(this.tileEntity.getPaymentInventory(), 0, 131, playerInventoryTopY - 32){

            public boolean m_8010_(Player pPlayer) {
                return !SpiritExtractorContainer.this.tileEntity.isSpewingItems();
            }

            @Override
            public boolean m_5857_(ItemStack stack) {
                return SpiritExtractorContainer.this.getTotalCost().m_41720_() == stack.m_41720_();
            }
        };
        paymentSlot.setBackground(InventoryMenu.f_39692_, ModSlotIcons.COINS_NO_ITEM);
        this.m_38897_(paymentSlot);
    }

    public boolean m_6875_(Player player) {
        return player.m_20275_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5) <= 64.0;
    }

    public List<ItemStack> getStoredItems() {
        return this.tileEntity.getStoredItems();
    }

    public void startSpewingItems() {
        this.tileEntity.spewItems(this.player);
        if (this.player.f_19853_.m_5776_()) {
            ModNetwork.CHANNEL.sendToServer((Object)new SpiritExtractorMessage(this.getExtractorPos(), SpiritExtractorMessage.Action.REVIVE));
        }
        this.player.m_6915_();
    }

    public void recycle() {
        if (this.player.f_19853_.m_5776_()) {
            ModNetwork.CHANNEL.sendToServer((Object)new SpiritExtractorMessage(this.getExtractorPos(), SpiritExtractorMessage.Action.RECYCLE));
        }
        this.player.m_6915_();
    }

    public boolean coinsCoverTotalCost() {
        return this.tileEntity.coinsCoverTotalCost();
    }

    public BlockPos getExtractorPos() {
        return this.pos;
    }

    public ItemStack getTotalCost() {
        return this.tileEntity.getRecoveryCost().getTotalCost();
    }

    public void setSpiritRecoveryCountAndMultiplier(int spiritRecoveryCount, float multiplier, float heroDiscount) {
        this.spiritRecoveryCount = spiritRecoveryCount;
        this.multiplier = multiplier;
        this.heroDiscount = heroDiscount;
    }

    public int getSpiritRecoveryCount() {
        return this.spiritRecoveryCount;
    }

    public float getHeroDiscount() {
        return this.heroDiscount;
    }

    public void m_38946_() {
        ServerLevel serverLevel;
        Level level = this.player.f_19853_;
        if (level instanceof ServerLevel && this.costDataChanged(serverLevel = (ServerLevel)level)) {
            this.updateClientCostData(serverLevel);
        }
        super.m_38946_();
    }

    public void m_182423_() {
        ServerLevel serverLevel;
        Level level = this.player.f_19853_;
        if (level instanceof ServerLevel && this.costDataChanged(serverLevel = (ServerLevel)level)) {
            this.updateClientCostData(serverLevel);
        }
        super.m_182423_();
    }

    private boolean costDataChanged(ServerLevel serverLevel) {
        UUID playerId = this.tileEntity.getGameProfile().map(GameProfile::getId).orElse(this.player.m_142081_());
        PlayerSpiritRecoveryData data = PlayerSpiritRecoveryData.get(serverLevel);
        return data.getSpiritRecoveryCount(playerId) != this.spiritRecoveryCount || !Mth.m_14033_((float)data.getSpiritRecoveryMultiplier(playerId), (float)this.multiplier);
    }

    public SpiritExtractorTileEntity.RecoveryCost getRecoveryCost() {
        if (this.tileEntity.getGameProfile().isEmpty() && this.currentPlayersRecoveryCost.isEmpty()) {
            this.calculateCostForCurrentPlayer();
        }
        return this.tileEntity.getGameProfile().isPresent() ? this.tileEntity.getRecoveryCost() : this.currentPlayersRecoveryCost;
    }

    private void updateClientCostData(ServerLevel serverLevel) {
        this.tileEntity.recalculateCost();
        serverLevel.m_7260_(this.tileEntity.m_58899_(), this.tileEntity.m_58900_(), this.tileEntity.m_58900_(), 3);
        UUID playerId = this.tileEntity.getGameProfile().map(GameProfile::getId).orElse(this.player.m_142081_());
        PlayerSpiritRecoveryData data = PlayerSpiritRecoveryData.get(serverLevel);
        this.spiritRecoveryCount = data.getSpiritRecoveryCount(playerId);
        this.multiplier = data.getSpiritRecoveryMultiplier(playerId);
        this.heroDiscount = data.getHeroDiscount(playerId);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModNetwork.CHANNEL.sendTo((Object)new ClientboundRefreshSpiritExtractorMessage(this.spiritRecoveryCount, this.multiplier, this.heroDiscount), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.moveOverSizedItemStackTo(slotStack, slot, 36, 37, false)) {
                return ItemStack.f_41583_;
            }
            if (index >= 0 && index < 27 ? !this.moveOverSizedItemStackTo(slotStack, slot, 27, 36, false) : (index >= 27 && index < 36 ? !this.moveOverSizedItemStackTo(slotStack, slot, 0, 27, false) : !this.moveOverSizedItemStackTo(slotStack, slot, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemstack;
    }

    public boolean isSpewingItems() {
        return this.tileEntity.isSpewingItems();
    }

    public boolean hasSpirit() {
        return this.tileEntity.getGameProfile().isPresent();
    }

    public void toggleRecycleLock() {
        this.recycleUnlocked = !this.recycleUnlocked;
    }

    public boolean isRecycleUnlocked() {
        return this.recycleUnlocked;
    }

    public int getPlayerLevel() {
        return this.hasSpirit() ? this.tileEntity.getPlayerLevel() : SidedHelper.getVaultLevel(this.player);
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public boolean isRecyclable() {
        return this.tileEntity.isRecyclable();
    }

    public float getRescuedBonus() {
        return this.tileEntity.getRescuedBonus();
    }
}

