/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import com.mojang.datafixers.util.Pair;
import iskallia.vault.block.entity.ToolViseTile;
import iskallia.vault.config.PaxelConfigs;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.oversized.OverSizedTabSlot;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSlotIcons;
import iskallia.vault.item.tool.PaxelItem;
import iskallia.vault.network.message.ClientboundRefreshToolViseMessage;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;

public class ToolViseContainerMenu
extends OverSizedSlotContainer {
    private static final Pair<ResourceLocation, ResourceLocation>[] EMPTY_SLOT_TEXTURES = new Pair[]{Pair.of((Object)InventoryMenu.f_39692_, (Object)ModSlotIcons.TOOL_VISE_SLOT_0_NO_ITEM), Pair.of((Object)InventoryMenu.f_39692_, (Object)ModSlotIcons.TOOL_VISE_SLOT_1_NO_ITEM), Pair.of((Object)InventoryMenu.f_39692_, (Object)ModSlotIcons.TOOL_VISE_SLOT_2_NO_ITEM), Pair.of((Object)InventoryMenu.f_39692_, (Object)ModSlotIcons.TOOL_VISE_SLOT_3_NO_ITEM), Pair.of((Object)InventoryMenu.f_39692_, (Object)ModSlotIcons.TOOL_VISE_SLOT_4_NO_ITEM), Pair.of((Object)InventoryMenu.f_39692_, (Object)ModSlotIcons.TOOL_VISE_SLOT_5_NO_ITEM)};
    private final BlockPos tilePos;
    private final ToolViseTile tileEntity;
    public final Map<PaxelItem.Stat, PaxelConfigs.Upgrade> upgrades = ModConfigs.PAXEL_CONFIGS.getAllUpgrades();

    public ToolViseContainerMenu(int id, Level level, BlockPos pos, Inventory playerInventory) {
        super(ModContainers.TOOL_VISE_CONTAINER, id, playerInventory.f_35978_);
        this.tilePos = pos;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ToolViseTile) {
            ToolViseTile toolViseTile;
            this.tileEntity = toolViseTile = (ToolViseTile)blockEntity;
            this.initSlots(playerInventory);
        } else {
            this.tileEntity = null;
        }
    }

    private void initSlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new TabSlot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, 136 + row * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new TabSlot((Container)playerInventory, hotbarSlot, 8 + hotbarSlot * 18, 194));
        }
        SimpleContainer pickaxeContainer = this.tileEntity.getPickaxeInput();
        this.m_38897_(new TabSlot((Container)pickaxeContainer, 0, 55, 24){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof PaxelItem;
            }

            public void m_6654_() {
                ToolViseContainerMenu.this.m_6199_(this.f_40218_);
                super.m_6654_();
            }
        });
        OverSizedInventory inventoryContainer = this.tileEntity.getInventory();
        this.m_38897_(new OverSizedTabSlot(inventoryContainer, 0, 43, 64){

            public void m_6654_() {
                ToolViseContainerMenu.this.m_6199_(this.f_40218_);
                super.m_6654_();
            }
        }.setFilter(itemStack -> itemStack.m_150930_(ModConfigs.PAXEL_CONFIGS.getMaterialItem(0))).setBackground((ResourceLocation)EMPTY_SLOT_TEXTURES[0].getFirst(), (ResourceLocation)EMPTY_SLOT_TEXTURES[0].getSecond()));
        this.m_38897_(new OverSizedTabSlot(inventoryContainer, 1, 66, 64){

            public void m_6654_() {
                ToolViseContainerMenu.this.m_6199_(this.f_40218_);
                super.m_6654_();
            }
        }.setFilter(itemStack -> itemStack.m_150930_(ModConfigs.PAXEL_CONFIGS.getMaterialItem(1))).setBackground((ResourceLocation)EMPTY_SLOT_TEXTURES[1].getFirst(), (ResourceLocation)EMPTY_SLOT_TEXTURES[1].getSecond()));
        this.m_38897_(new OverSizedTabSlot(inventoryContainer, 2, 43, 86){

            public void m_6654_() {
                ToolViseContainerMenu.this.tileEntity.m_6596_();
                ToolViseContainerMenu.this.m_6199_(this.f_40218_);
                super.m_6654_();
            }
        }.setFilter(itemStack -> itemStack.m_150930_(ModConfigs.PAXEL_CONFIGS.getMaterialItem(2))).setBackground((ResourceLocation)EMPTY_SLOT_TEXTURES[2].getFirst(), (ResourceLocation)EMPTY_SLOT_TEXTURES[2].getSecond()));
        this.m_38897_(new OverSizedTabSlot(inventoryContainer, 3, 66, 86){

            public void m_6654_() {
                ToolViseContainerMenu.this.m_6199_(this.f_40218_);
                super.m_6654_();
            }
        }.setFilter(itemStack -> itemStack.m_150930_(ModConfigs.PAXEL_CONFIGS.getMaterialItem(3))).setBackground((ResourceLocation)EMPTY_SLOT_TEXTURES[3].getFirst(), (ResourceLocation)EMPTY_SLOT_TEXTURES[3].getSecond()));
        this.m_38897_(new OverSizedTabSlot(inventoryContainer, 4, 43, 108){

            public void m_6654_() {
                ToolViseContainerMenu.this.m_6199_(this.f_40218_);
                super.m_6654_();
            }
        }.setFilter(itemStack -> itemStack.m_150930_(ModConfigs.PAXEL_CONFIGS.getMaterialItem(4))).setBackground((ResourceLocation)EMPTY_SLOT_TEXTURES[4].getFirst(), (ResourceLocation)EMPTY_SLOT_TEXTURES[4].getSecond()));
        this.m_38897_(new OverSizedTabSlot(inventoryContainer, 5, 66, 108){

            public void m_6654_() {
                ToolViseContainerMenu.this.m_6199_(this.f_40218_);
                super.m_6654_();
            }
        }.setFilter(itemStack -> itemStack.m_150930_(ModConfigs.PAXEL_CONFIGS.getMaterialItem(5))).setBackground((ResourceLocation)EMPTY_SLOT_TEXTURES[5].getFirst(), (ResourceLocation)EMPTY_SLOT_TEXTURES[5].getSecond()));
    }

    public void m_6199_(Container pInventory) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModNetwork.CHANNEL.sendTo((Object)new ClientboundRefreshToolViseMessage(this.tilePos), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        this.tileEntity.m_6596_();
        super.m_6199_(pInventory);
    }

    public boolean m_6875_(Player playerIn) {
        if (this.tileEntity == null) {
            return false;
        }
        return this.tileEntity.stillValid(playerIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.moveOverSizedItemStackTo(slotStack, slot, 36, this.f_38839_.size(), false)) {
                return itemstack;
            }
            if (index >= 0 && index < 27 ? !this.moveOverSizedItemStackTo(slotStack, slot, 27, 36, false) : (index >= 27 && index < 36 ? !this.moveOverSizedItemStackTo(slotStack, slot, 0, 27, false) : !this.moveOverSizedItemStackTo(slotStack, slot, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(this.player, slotStack);
        }
        return itemstack;
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        return super.m_6366_(pPlayer, pId);
    }

    private static class MaterialSlot
    extends Slot {
        private final Predicate<ItemStack> itemFilter;
        private final Pair<ResourceLocation, ResourceLocation> emptyIconLocation;

        public MaterialSlot(Container pContainer, int pIndex, int pX, int pY, Predicate<ItemStack> itemFilter, Pair<ResourceLocation, ResourceLocation> emptyIconLocation) {
            super(pContainer, pIndex, pX, pY);
            this.itemFilter = itemFilter;
            this.emptyIconLocation = emptyIconLocation;
        }

        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            return this.emptyIconLocation;
        }

        public boolean m_5857_(@Nonnull ItemStack pStack) {
            return this.itemFilter.test(pStack);
        }
    }
}

