/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.oversized;

import iskallia.vault.container.oversized.OverSizedItemStack;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class OverSizedInventory
implements Container {
    public static final OverSizedInventory EMPTY = new OverSizedInventory(0, () -> {}, player -> false);
    private final NonNullList<OverSizedItemStack> contents;
    private final Runnable onChange;
    private final Predicate<Player> stillValid;

    public OverSizedInventory(int size, BlockEntity tile) {
        this(size, () -> ((BlockEntity)tile).m_6596_(), player -> OverSizedInventory.stillValidTile().test(tile, (Player)player));
    }

    public OverSizedInventory(int size, Runnable onChange, Predicate<Player> stillValid) {
        this.contents = NonNullList.m_122780_((int)size, (Object)OverSizedItemStack.EMPTY);
        this.onChange = onChange;
        this.stillValid = stillValid;
    }

    public NonNullList<OverSizedItemStack> getOverSizedContents() {
        return this.contents;
    }

    public void setOverSizedStack(int slot, OverSizedItemStack stack) {
        this.contents.set(slot, (Object)stack);
    }

    public static BiPredicate<BlockEntity, Player> stillValidTile() {
        return (tile, player) -> {
            if (tile.m_58904_().m_7702_(tile.m_58899_()) != tile) {
                return false;
            }
            return player.m_20275_((double)tile.m_58899_().m_123341_() + 0.5, (double)tile.m_58899_().m_123342_() + 0.5, (double)tile.m_58899_().m_123343_() + 0.5) <= 64.0;
        };
    }

    public void load(CompoundTag tag) {
        this.contents.clear();
        ListTag items = tag.m_128437_("items", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag stackTag = items.m_128728_(i);
            int slot = stackTag.m_128451_("slot");
            this.contents.set(slot, (Object)OverSizedItemStack.deserialize(stackTag.m_128469_("stack")));
        }
    }

    public void save(CompoundTag tag) {
        ListTag items = new ListTag();
        for (int i = 0; i < this.contents.size(); ++i) {
            OverSizedItemStack stack = (OverSizedItemStack)this.contents.get(i);
            if (stack.overSizedStack().m_41619_()) continue;
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128405_("slot", i);
            stackTag.m_128365_("stack", (Tag)stack.serialize());
            items.add((Object)stackTag);
        }
        tag.m_128365_("items", (Tag)items);
    }

    public List<ItemStack> getContents() {
        return this.contents.stream().map(OverSizedItemStack::overSizedStack).toList();
    }

    public int m_6643_() {
        return this.contents.size();
    }

    public int m_6893_() {
        return 2147483582;
    }

    public boolean m_7983_() {
        return this.contents.stream().mapToInt(OverSizedItemStack::amount).sum() <= 0;
    }

    public ItemStack m_8020_(int pIndex) {
        return ((OverSizedItemStack)this.contents.get(pIndex)).overSizedStack();
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        if (pIndex >= 0 && pIndex < this.contents.size() && ((OverSizedItemStack)this.contents.get(pIndex)).amount() > 0 && pCount > 0) {
            ItemStack contained = ((OverSizedItemStack)this.contents.get(pIndex)).overSizedStack();
            ItemStack splitOff = contained.m_41620_(pCount);
            this.contents.set(pIndex, (Object)OverSizedItemStack.of(contained));
            this.m_6596_();
            return splitOff;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int pIndex) {
        return pIndex >= 0 && pIndex < this.contents.size() ? ((OverSizedItemStack)this.contents.set(pIndex, (Object)OverSizedItemStack.EMPTY)).overSizedStack() : ItemStack.f_41583_;
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        this.contents.set(pIndex, (Object)OverSizedItemStack.of(pStack));
        this.m_6596_();
    }

    public void m_6596_() {
        this.onChange.run();
    }

    public boolean m_6542_(Player pPlayer) {
        return this.stillValid.test(pPlayer);
    }

    public void m_6211_() {
        this.contents.clear();
    }
}

