/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.oversized;

import com.google.common.collect.Sets;
import iskallia.vault.container.oversized.OverSizedContainerSynchronizer;
import iskallia.vault.container.spi.AbstractElementContainer;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class OverSizedSlotContainer
extends AbstractElementContainer {
    private int dragMode = -1;
    private int dragEvent;
    private final Set<Slot> dragSlots = Sets.newHashSet();

    protected OverSizedSlotContainer(MenuType<?> menuType, int id, Player player) {
        super(menuType, id, player);
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (clickTypeIn == ClickType.QUICK_CRAFT) {
            int j1 = this.dragEvent;
            this.dragEvent = OverSizedSlotContainer.m_38947_((int)dragType);
            if ((j1 != 1 || this.dragEvent != 2) && j1 != this.dragEvent) {
                this.m_38951_();
            } else if (this.m_142621_().m_41619_()) {
                this.m_38951_();
            } else if (this.dragEvent == 0) {
                this.dragMode = OverSizedSlotContainer.m_38928_((int)dragType);
                if (OverSizedSlotContainer.m_38862_((int)this.dragMode, (Player)player)) {
                    this.dragEvent = 1;
                    this.dragSlots.clear();
                } else {
                    this.m_38951_();
                }
            } else if (this.dragEvent == 1) {
                Slot slot = (Slot)this.f_38839_.get(slotId);
                ItemStack mouseStack = this.m_142621_();
                if (slot != null && OverSizedSlotContainer.canAddItemToSlot(slot, mouseStack, true) && slot.m_5857_(mouseStack) && (this.dragMode == 2 || mouseStack.m_41613_() > this.dragSlots.size()) && this.m_5622_(slot)) {
                    this.dragSlots.add(slot);
                }
            } else if (this.dragEvent == 2) {
                if (!this.dragSlots.isEmpty()) {
                    ItemStack mouseStackCopy = this.m_142621_().m_41777_();
                    int k1 = this.m_142621_().m_41613_();
                    for (Slot dragSlot : this.dragSlots) {
                        ItemStack mouseStack = this.m_142621_();
                        if (dragSlot == null || !OverSizedSlotContainer.canAddItemToSlot(dragSlot, mouseStack, true) || !dragSlot.m_5857_(mouseStack) || this.dragMode != 2 && mouseStack.m_41613_() < this.dragSlots.size() || !this.m_5622_(dragSlot)) continue;
                        ItemStack itemstack14 = mouseStackCopy.m_41777_();
                        int j3 = dragSlot.m_6657_() ? dragSlot.m_7993_().m_41613_() : 0;
                        OverSizedSlotContainer.m_38922_(this.dragSlots, (int)this.dragMode, (ItemStack)itemstack14, (int)j3);
                        int k3 = dragSlot.m_5866_(itemstack14);
                        if (itemstack14.m_41613_() > k3) {
                            itemstack14.m_41764_(k3);
                        }
                        k1 -= itemstack14.m_41613_() - j3;
                        dragSlot.m_5852_(itemstack14);
                    }
                    mouseStackCopy.m_41764_(k1);
                    this.m_142503_(mouseStackCopy);
                }
                this.m_38951_();
            } else {
                this.m_38951_();
            }
        } else if (this.dragEvent != 0) {
            this.m_38951_();
        } else if (!(clickTypeIn != ClickType.PICKUP && clickTypeIn != ClickType.QUICK_MOVE || dragType != 0 && dragType != 1)) {
            if (slotId == -999) {
                if (!this.m_142621_().m_41619_()) {
                    if (dragType == 0) {
                        player.m_36176_(this.m_142621_(), true);
                        this.m_142503_(ItemStack.f_41583_);
                    }
                    if (dragType == 1) {
                        player.m_36176_(this.m_142621_().m_41620_(1), true);
                    }
                }
            } else if (clickTypeIn == ClickType.QUICK_MOVE) {
                if (slotId < 0) {
                    return;
                }
                Slot slot = (Slot)this.f_38839_.get(slotId);
                if (slot == null || !slot.m_8010_(player)) {
                    return;
                }
                ItemStack itemstack7 = this.m_7648_(player, slotId);
                while (!itemstack7.m_41619_() && ItemStack.m_41746_((ItemStack)slot.m_7993_(), (ItemStack)itemstack7)) {
                    itemstack7 = this.m_7648_(player, slotId);
                }
            } else {
                if (slotId < 0) {
                    return;
                }
                Slot slot = (Slot)this.f_38839_.get(slotId);
                if (slot != null) {
                    ItemStack slotStack = slot.m_7993_();
                    ItemStack mouseStack = this.m_142621_();
                    if (slotStack.m_41619_()) {
                        if (!mouseStack.m_41619_() && slot.m_5857_(mouseStack)) {
                            int i3;
                            int n = i3 = dragType == 0 ? mouseStack.m_41613_() : 1;
                            if (i3 > slot.m_5866_(mouseStack)) {
                                i3 = slot.m_5866_(mouseStack);
                            }
                            slot.m_5852_(mouseStack.m_41620_(i3));
                        }
                    } else if (slot.m_8010_(player)) {
                        int j2;
                        if (mouseStack.m_41619_()) {
                            if (slotStack.m_41619_()) {
                                slot.m_5852_(ItemStack.f_41583_);
                                this.m_142503_(ItemStack.f_41583_);
                            } else {
                                int slotCount = Math.min(slotStack.m_41613_(), slotStack.m_41741_());
                                int toMove = dragType == 0 ? slotCount : (slotCount + 1) / 2;
                                this.m_142503_(slot.m_6201_(toMove));
                                if (slotStack.m_41619_()) {
                                    slot.m_5852_(ItemStack.f_41583_);
                                }
                                slot.m_142406_(player, this.m_142621_());
                            }
                        } else if (slot.m_5857_(mouseStack)) {
                            if (slotStack.m_41720_() == mouseStack.m_41720_() && ItemStack.m_41658_((ItemStack)slotStack, (ItemStack)mouseStack)) {
                                int k2;
                                int n = k2 = dragType == 0 ? mouseStack.m_41613_() : 1;
                                if (k2 > slot.m_5866_(mouseStack) - slotStack.m_41613_()) {
                                    k2 = slot.m_5866_(mouseStack) - slotStack.m_41613_();
                                }
                                mouseStack.m_41774_(k2);
                                slotStack.m_41769_(k2);
                                slot.m_5852_(slotStack);
                            } else if (mouseStack.m_41613_() <= slot.m_5866_(mouseStack) && slotStack.m_41613_() <= slotStack.m_41741_()) {
                                slot.m_5852_(mouseStack);
                                this.m_142503_(slotStack);
                            }
                        } else if (slotStack.m_41720_() == mouseStack.m_41720_() && mouseStack.m_41741_() > 1 && ItemStack.m_41658_((ItemStack)slotStack, (ItemStack)mouseStack) && !slotStack.m_41619_() && (j2 = slotStack.m_41613_()) + mouseStack.m_41613_() <= mouseStack.m_41741_()) {
                            mouseStack.m_41769_(j2);
                            slotStack = slot.m_6201_(j2);
                            if (slotStack.m_41619_()) {
                                slot.m_5852_(ItemStack.f_41583_);
                            }
                            slot.m_142406_(player, this.m_142621_());
                        }
                    }
                    slot.m_6654_();
                }
            }
        } else if (clickTypeIn != ClickType.SWAP || dragType < 0 || dragType >= 9) {
            if (clickTypeIn == ClickType.CLONE && player.m_150110_().f_35937_ && this.m_142621_().m_41619_() && slotId >= 0) {
                Slot slot3 = (Slot)this.f_38839_.get(slotId);
                if (slot3 != null && slot3.m_6657_()) {
                    ItemStack itemstack5 = slot3.m_7993_().m_41777_();
                    itemstack5.m_41764_(itemstack5.m_41741_());
                    this.m_142503_(itemstack5);
                }
            } else if (clickTypeIn == ClickType.THROW && this.m_142621_().m_41619_() && slotId >= 0) {
                Slot slot = (Slot)this.f_38839_.get(slotId);
                if (slot != null && slot.m_6657_() && slot.m_8010_(player)) {
                    int removeCount = Math.min(dragType == 0 ? 1 : slot.m_7993_().m_41613_(), slot.m_7993_().m_41741_());
                    ItemStack itemstack4 = slot.m_6201_(removeCount);
                    slot.m_142406_(player, itemstack4);
                    player.m_36176_(itemstack4, true);
                }
            } else if (clickTypeIn == ClickType.PICKUP_ALL && slotId >= 0) {
                Slot slot = (Slot)this.f_38839_.get(slotId);
                ItemStack mouseStack = this.m_142621_();
                if (!(mouseStack.m_41619_() || slot != null && slot.m_6657_() && slot.m_8010_(player))) {
                    int i = dragType == 0 ? 0 : this.f_38839_.size() - 1;
                    int j = dragType == 0 ? 1 : -1;
                    for (int k = 0; k < 2; ++k) {
                        for (int l = i; l >= 0 && l < this.f_38839_.size() && mouseStack.m_41613_() < mouseStack.m_41741_(); l += j) {
                            Slot slot1 = (Slot)this.f_38839_.get(l);
                            if (!slot1.m_6657_() || !OverSizedSlotContainer.canAddItemToSlot(slot1, mouseStack, true) || !slot1.m_8010_(player) || !this.m_5882_(mouseStack, slot1)) continue;
                            ItemStack itemstack2 = slot1.m_7993_();
                            if (k == 0 && itemstack2.m_41613_() >= slot1.m_5866_(itemstack2)) continue;
                            int i1 = Math.min(mouseStack.m_41741_() - mouseStack.m_41613_(), itemstack2.m_41613_());
                            ItemStack itemstack3 = slot1.m_6201_(i1);
                            mouseStack.m_41769_(i1);
                            if (itemstack3.m_41619_()) {
                                slot1.m_5852_(ItemStack.f_41583_);
                            }
                            slot1.m_142406_(player, itemstack3);
                        }
                    }
                }
                this.m_38946_();
            }
        }
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.moveOverSizedItemStackTo(stack, null, startIndex, endIndex, reverseDirection);
    }

    protected boolean moveOverSizedItemStackTo(ItemStack sourceStack, @Nullable Slot sourceSlot, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        while (!sourceStack.m_41619_() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
            Slot slot = (Slot)this.f_38839_.get(i);
            ItemStack slotStack = slot.m_7993_();
            if (!slotStack.m_41619_() && slotStack.m_41720_() == sourceStack.m_41720_() && ItemStack.m_41658_((ItemStack)sourceStack, (ItemStack)slotStack) && slot.m_5857_(sourceStack)) {
                int maxSize;
                int j = slotStack.m_41613_() + sourceStack.m_41613_();
                if (j <= (maxSize = slot.m_5866_(slotStack))) {
                    sourceStack.m_41764_(0);
                    if (sourceSlot != null) {
                        sourceSlot.m_5852_(sourceStack);
                    }
                    slotStack.m_41764_(j);
                    slot.m_5852_(slotStack);
                    slot.m_6654_();
                    flag = true;
                } else if (slotStack.m_41613_() < maxSize) {
                    sourceStack.m_41774_(maxSize - slotStack.m_41613_());
                    if (sourceSlot != null) {
                        sourceSlot.m_5852_(sourceStack);
                    }
                    slotStack.m_41764_(maxSize);
                    slot.m_5852_(slotStack);
                    slot.m_6654_();
                    flag = true;
                }
            }
            i += reverseDirection ? -1 : 1;
        }
        if (!sourceStack.m_41619_()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(sourceStack)) {
                    if (sourceStack.m_41613_() > slot1.m_5866_(sourceStack)) {
                        slot1.m_5852_(sourceStack.m_41620_(slot1.m_5866_(sourceStack)));
                    } else {
                        slot1.m_5852_(sourceStack.m_41620_(sourceStack.m_41613_()));
                    }
                    if (sourceSlot != null) {
                        sourceSlot.m_5852_(sourceStack);
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                i += reverseDirection ? -1 : 1;
            }
        }
        return flag;
    }

    public static boolean canAddItemToSlot(@Nullable Slot slot, @Nonnull ItemStack stack, boolean stackSizeMatters) {
        boolean flag;
        boolean bl = flag = slot == null || !slot.m_6657_();
        if (slot != null) {
            ItemStack slotStack = slot.m_7993_();
            if (!flag && stack.m_41656_(slotStack) && ItemStack.m_41658_((ItemStack)slotStack, (ItemStack)stack)) {
                return slotStack.m_41613_() + (stackSizeMatters ? 0 : stack.m_41613_()) <= slot.m_5866_(slotStack);
            }
        }
        return flag;
    }

    protected void m_38951_() {
        this.dragEvent = 0;
        this.dragSlots.clear();
    }

    public void m_150416_(ContainerSynchronizer sync) {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            super.m_150416_((ContainerSynchronizer)new OverSizedContainerSynchronizer(sync, sPlayer));
        } else {
            super.m_150416_(sync);
        }
    }
}

