/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.slot;

import iskallia.vault.container.slot.spi.IGhostSlot;
import iskallia.vault.dynamodel.DynamicModelItem;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModRelics;
import iskallia.vault.item.RelicFragmentItem;
import java.util.LinkedList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RelicRecipeFragmentSlot
extends Slot
implements IGhostSlot {
    protected Supplier<ModRelics.RelicRecipe> recipe;

    public RelicRecipeFragmentSlot(Supplier<ModRelics.RelicRecipe> recipe, Container container, int pIndex, int pX, int pY) {
        super(container, pIndex, pX, pY);
        this.recipe = recipe;
    }

    public int m_6641_() {
        return 1;
    }

    public boolean m_5857_(@Nonnull ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof RelicFragmentItem)) {
            return false;
        }
        ResourceLocation fragmentId = DynamicModelItem.getGenericModelId(itemStack).orElse(null);
        if (fragmentId == null) {
            return false;
        }
        ModRelics.RelicRecipe relicRecipe = this.recipe.get();
        if (relicRecipe == null) {
            return false;
        }
        LinkedList<ResourceLocation> fragments = new LinkedList<ResourceLocation>(relicRecipe.getFragments());
        return fragments.get(this.getSlotIndex()).equals((Object)fragmentId);
    }

    @Override
    public ItemStack getGhostItemStack() {
        ModRelics.RelicRecipe relicRecipe = this.recipe.get();
        if (relicRecipe == null) {
            return null;
        }
        LinkedList<ResourceLocation> fragments = new LinkedList<ResourceLocation>(relicRecipe.getFragments());
        if (this.getSlotIndex() >= fragments.size()) {
            return null;
        }
        ResourceLocation fragmentId = fragments.get(this.getSlotIndex());
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.RELIC_FRAGMENT);
        DynamicModelItem.setGenericModelId(itemStack, fragmentId);
        return itemStack;
    }
}

