/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.spi;

import iskallia.vault.block.entity.base.ForgeRecipeTileEntity;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.slot.RecipeOutputSlot;
import iskallia.vault.container.slot.TabSlot;
import java.awt.Point;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class ForgeRecipeContainer<T extends ForgeRecipeTileEntity>
extends OverSizedSlotContainer {
    private final T tile;
    private final BlockPos tilePos;

    public ForgeRecipeContainer(MenuType<?> menuType, int id, Level world, BlockPos pos, Inventory playerInventory) {
        super(menuType, id, playerInventory.f_35978_);
        this.tilePos = pos;
        BlockEntity tile = world.m_7702_(this.tilePos);
        if (this.getTileClass().isInstance(tile)) {
            this.tile = (ForgeRecipeTileEntity)tile;
            this.initSlots(playerInventory);
        } else {
            this.tile = null;
        }
    }

    protected abstract Class<T> getTileClass();

    public abstract Point getOffset();

    public Point getPlayerInventoryOffset() {
        return this.getOffset();
    }

    public final Slot getResultSlot() {
        return this.m_38853_(this.f_38839_.size() - 1);
    }

    public BlockPos getTilePos() {
        return this.tilePos;
    }

    @Nullable
    public T getTile() {
        return this.tile;
    }

    private void initSlots(Inventory playerInventory) {
        Point inventoryOffset = this.getPlayerInventoryOffset();
        int invXOffset = inventoryOffset.x;
        int invYOffset = inventoryOffset.y;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new TabSlot((Container)playerInventory, column + row * 9 + 9, invXOffset + column * 18, 68 + invYOffset + row * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new TabSlot((Container)playerInventory, hotbarSlot, invXOffset + hotbarSlot * 18, 126 + invYOffset));
        }
        Point containerOffset = this.getOffset();
        int xOffset = containerOffset.x;
        int yOffset = containerOffset.y;
        final OverSizedInventory invContainer = ((ForgeRecipeTileEntity)((Object)this.tile)).getInventory();
        for (int invSlot = 0; invSlot < invContainer.m_6643_(); ++invSlot) {
            int x = xOffset + invSlot / 3 * 18;
            int y = yOffset + invSlot % 3 * 18;
            this.m_38897_(new TabSlot(invContainer, invSlot, x, y){

                public int m_5866_(ItemStack stack) {
                    return invContainer.m_6893_();
                }
            });
        }
        int slotWidth = Mth.m_14167_((float)((float)invContainer.m_6643_() / 3.0f));
        this.m_38897_(new RecipeOutputSlot((Container)((ForgeRecipeTileEntity)((Object)this.tile)).getResultContainer(), 0, xOffset + slotWidth * 18 + 104, 18 + yOffset));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.moveOverSizedItemStackTo(slotStack, slot, 36, this.f_38839_.size() - 1, false)) {
                return itemstack;
            }
            if (index >= 0 && index < 27 ? !this.moveOverSizedItemStackTo(slotStack, slot, 27, 36, false) : (index >= 27 && index < 36 ? !this.moveOverSizedItemStackTo(slotStack, slot, 0, 27, false) : !this.moveOverSizedItemStackTo(slotStack, slot, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        if (this.tile == null) {
            return false;
        }
        return ((ForgeRecipeTileEntity)((Object)this.tile)).stillValid(player);
    }
}

