/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.item.crystal.data.adapter.IBitAdapter;
import iskallia.vault.item.crystal.data.adapter.IByteAdapter;
import iskallia.vault.item.crystal.data.adapter.IDataAdapter;
import iskallia.vault.item.crystal.data.adapter.IJsonAdapter;
import iskallia.vault.item.crystal.data.adapter.INbtAdapter;
import iskallia.vault.item.crystal.data.adapter.ISimpleAdapter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;

public class ByteArrayAdapter
implements ISimpleAdapter<byte[], Tag, JsonArray> {
    private final Object elementAdapter;
    private final boolean nullable;

    public ByteArrayAdapter(Object elementAdapter, boolean nullable) {
        this.elementAdapter = elementAdapter;
        this.nullable = nullable;
    }

    public Object getElementAdapter() {
        return this.elementAdapter;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public ByteArrayAdapter asNullable() {
        return new ByteArrayAdapter(this.elementAdapter, true);
    }

    @Override
    public final void writeBits(@Nullable byte[] value, BitBuffer buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IBitAdapter)) {
            throw new UnsupportedOperationException();
        }
        IBitAdapter adapter = (IBitAdapter)object;
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_7.writeBits(value.length, buffer);
            for (Object element : (Object)value) {
                adapter.writeBits((byte)element, buffer, null);
            }
        }
    }

    @Override
    public final Optional<byte[]> readBits(BitBuffer buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IBitAdapter)) {
            throw new UnsupportedOperationException();
        }
        IBitAdapter adapter = (IBitAdapter)object;
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        byte[] value = new byte[((Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow()).intValue()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = adapter.readBits(buffer, null).orElse((byte)0);
        }
        return Optional.of(value);
    }

    @Override
    public final void writeBytes(@Nullable byte[] value, ByteBuf buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IByteAdapter)) {
            throw new UnsupportedOperationException();
        }
        IByteAdapter adapter = (IByteAdapter)object;
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_7.writeBytes(value.length, buffer);
            for (Object element : (Object)value) {
                adapter.writeBytes((int)element, buffer, null);
            }
        }
    }

    @Override
    public final Optional<byte[]> readBytes(ByteBuf buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IByteAdapter)) {
            throw new UnsupportedOperationException();
        }
        IByteAdapter adapter = (IByteAdapter)object;
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        byte[] value = new byte[((Integer)Adapters.INT_SEGMENTED_7.readBytes(buffer).orElseThrow()).intValue()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = adapter.readBytes(buffer, null).orElse((byte)0);
        }
        return Optional.of(value);
    }

    @Override
    public void writeData(@Nullable byte[] value, DataOutput data) throws IOException {
        Object object = this.elementAdapter;
        if (!(object instanceof IDataAdapter)) {
            throw new UnsupportedOperationException();
        }
        IDataAdapter adapter = (IDataAdapter)object;
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_7.writeData(value.length, data);
            for (Object element : (Object)value) {
                adapter.writeData((int)element, data, null);
            }
        }
    }

    @Override
    public Optional<byte[]> readData(DataInput data) throws IOException {
        Object object = this.elementAdapter;
        if (!(object instanceof IDataAdapter)) {
            throw new UnsupportedOperationException();
        }
        IDataAdapter adapter = (IDataAdapter)object;
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        byte[] value = new byte[((Integer)Adapters.INT_SEGMENTED_7.readData(data).orElseThrow()).intValue()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = adapter.readData(data, null).orElse((byte)0);
        }
        return Optional.of(value);
    }

    @Override
    public final Optional<Tag> writeNbt(@Nullable byte[] value) {
        Object object = this.elementAdapter;
        if (!(object instanceof INbtAdapter)) {
            throw new UnsupportedOperationException();
        }
        INbtAdapter adapter = (INbtAdapter)object;
        if (value == null) {
            return Optional.empty();
        }
        byte[] bytes = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            bytes[i] = ((NumericTag)adapter.writeNbt(value[i], null).orElseThrow()).m_7063_();
        }
        return Optional.of(new ByteArrayTag(bytes));
    }

    @Override
    public final Optional<byte[]> readNbt(@Nullable Tag nbt) {
        Object object = this.elementAdapter;
        if (!(object instanceof INbtAdapter)) {
            throw new UnsupportedOperationException();
        }
        INbtAdapter adapter = (INbtAdapter)object;
        if (nbt instanceof NumericTag) {
            NumericTag numeric = (NumericTag)nbt;
            return Optional.of(new byte[]{numeric.m_7063_()});
        }
        if (nbt instanceof CollectionTag) {
            CollectionTag array = (CollectionTag)nbt;
            byte[] value = new byte[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                value[i] = adapter.readNbt((Tag)array.get(i), null).orElse((byte)0);
            }
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @Override
    public final Optional<JsonArray> writeJson(@Nullable byte[] value) {
        Object object = this.elementAdapter;
        if (!(object instanceof IJsonAdapter)) {
            throw new UnsupportedOperationException();
        }
        IJsonAdapter adapter = (IJsonAdapter)object;
        if (value == null) {
            return Optional.empty();
        }
        JsonPrimitive[] primitives = new JsonPrimitive[value.length];
        for (int i = 0; i < value.length; ++i) {
            primitives[i] = (JsonPrimitive)adapter.writeJson(value[i], null).orElseGet(() -> new JsonPrimitive((Number)0));
        }
        JsonArray bytes = new JsonArray(primitives.length);
        for (JsonPrimitive primitive : primitives) {
            bytes.add((Number)primitive.getAsByte());
        }
        return Optional.of(bytes);
    }

    @Override
    public final Optional<byte[]> readJson(@Nullable JsonArray json) {
        Object object = this.elementAdapter;
        if (!(object instanceof IJsonAdapter)) {
            throw new UnsupportedOperationException();
        }
        IJsonAdapter adapter = (IJsonAdapter)object;
        if (json == null) {
            return Optional.empty();
        }
        byte[] value = new byte[json.size()];
        for (int i = 0; i < json.size(); ++i) {
            value[i] = adapter.readJson(json.get(i), null).orElse((byte)0);
        }
        return Optional.of(value);
    }
}

