/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.item.crystal.data.adapter.IBitAdapter;
import iskallia.vault.item.crystal.data.adapter.IByteAdapter;
import iskallia.vault.item.crystal.data.adapter.IDataAdapter;
import iskallia.vault.item.crystal.data.adapter.IJsonAdapter;
import iskallia.vault.item.crystal.data.adapter.INbtAdapter;
import iskallia.vault.item.crystal.data.adapter.ISimpleAdapter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;

public class IntArrayAdapter
implements ISimpleAdapter<int[], Tag, JsonArray> {
    private final Object elementAdapter;
    private final boolean nullable;

    public IntArrayAdapter(Object elementAdapter, boolean nullable) {
        this.elementAdapter = elementAdapter;
        this.nullable = nullable;
    }

    public Object getElementAdapter() {
        return this.elementAdapter;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public IntArrayAdapter asNullable() {
        return new IntArrayAdapter(this.elementAdapter, true);
    }

    @Override
    public final void writeBits(@Nullable int[] value, BitBuffer buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IBitAdapter)) {
            throw new UnsupportedOperationException();
        }
        IBitAdapter adapter = (IBitAdapter)object;
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_7.writeBits(value.length, buffer);
            for (Object element : (Object)value) {
                adapter.writeBits((int)element, buffer, null);
            }
        }
    }

    @Override
    public final Optional<int[]> readBits(BitBuffer buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IBitAdapter)) {
            throw new UnsupportedOperationException();
        }
        IBitAdapter adapter = (IBitAdapter)object;
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        int[] value = new int[((Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow()).intValue()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = adapter.readBits(buffer, null).orElse(0);
        }
        return Optional.of(value);
    }

    @Override
    public final void writeBytes(@Nullable int[] value, ByteBuf buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IByteAdapter)) {
            throw new UnsupportedOperationException();
        }
        IByteAdapter adapter = (IByteAdapter)object;
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_7.writeBytes(value.length, buffer);
            for (Object element : (Object)value) {
                adapter.writeBytes((int)element, buffer, null);
            }
        }
    }

    @Override
    public final Optional<int[]> readBytes(ByteBuf buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IByteAdapter)) {
            throw new UnsupportedOperationException();
        }
        IByteAdapter adapter = (IByteAdapter)object;
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        int[] value = new int[((Integer)Adapters.INT_SEGMENTED_7.readBytes(buffer).orElseThrow()).intValue()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = adapter.readBytes(buffer, null).orElse(0);
        }
        return Optional.of(value);
    }

    @Override
    public void writeData(@Nullable int[] value, DataOutput data) throws IOException {
        Object object = this.elementAdapter;
        if (!(object instanceof IDataAdapter)) {
            throw new UnsupportedOperationException();
        }
        IDataAdapter adapter = (IDataAdapter)object;
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_7.writeData(value.length, data);
            for (Object element : (Object)value) {
                adapter.writeData((int)element, data, null);
            }
        }
    }

    @Override
    public Optional<int[]> readData(DataInput data) throws IOException {
        Object object = this.elementAdapter;
        if (!(object instanceof IDataAdapter)) {
            throw new UnsupportedOperationException();
        }
        IDataAdapter adapter = (IDataAdapter)object;
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        int[] value = new int[((Integer)Adapters.INT_SEGMENTED_7.readData(data).orElseThrow()).intValue()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = adapter.readData(data, null).orElse(0);
        }
        return Optional.of(value);
    }

    @Override
    public final Optional<Tag> writeNbt(@Nullable int[] value) {
        Object object = this.elementAdapter;
        if (!(object instanceof INbtAdapter)) {
            throw new UnsupportedOperationException();
        }
        INbtAdapter adapter = (INbtAdapter)object;
        if (value == null) {
            return Optional.empty();
        }
        NumericTag[] tags = new NumericTag[value.length];
        for (int i = 0; i < value.length; ++i) {
            tags[i] = (NumericTag)adapter.writeNbt(value[i], null).orElseThrow();
        }
        if (Arrays.stream(tags).allMatch(element -> element.m_7063_() == element.m_7047_())) {
            byte[] bytes = new byte[tags.length];
            for (int i = 0; i < tags.length; ++i) {
                bytes[i] = tags[i].m_7063_();
            }
            return Optional.of(new ByteArrayTag(bytes));
        }
        int[] ints = new int[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            ints[i] = tags[i].m_7047_();
        }
        return Optional.of(new IntArrayTag(ints));
    }

    @Override
    public final Optional<int[]> readNbt(@Nullable Tag nbt) {
        Object object = this.elementAdapter;
        if (!(object instanceof INbtAdapter)) {
            throw new UnsupportedOperationException();
        }
        INbtAdapter adapter = (INbtAdapter)object;
        if (nbt instanceof NumericTag) {
            NumericTag numeric = (NumericTag)nbt;
            return Optional.of(new int[]{numeric.m_7047_()});
        }
        if (nbt instanceof CollectionTag) {
            CollectionTag array = (CollectionTag)nbt;
            int[] value = new int[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                value[i] = adapter.readNbt((Tag)array.get(i), null).orElse(0);
            }
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @Override
    public final Optional<JsonArray> writeJson(@Nullable int[] value) {
        Object object = this.elementAdapter;
        if (!(object instanceof IJsonAdapter)) {
            throw new UnsupportedOperationException();
        }
        IJsonAdapter adapter = (IJsonAdapter)object;
        if (value == null) {
            return Optional.empty();
        }
        JsonPrimitive[] primitives = new JsonPrimitive[value.length];
        for (int i = 0; i < value.length; ++i) {
            primitives[i] = (JsonPrimitive)adapter.writeJson(value[i], null).orElseGet(() -> new JsonPrimitive((Number)0));
        }
        JsonArray ints = new JsonArray(primitives.length);
        for (JsonPrimitive primitive : primitives) {
            ints.add((Number)primitive.getAsInt());
        }
        return Optional.of(ints);
    }

    @Override
    public final Optional<int[]> readJson(@Nullable JsonArray json) {
        Object object = this.elementAdapter;
        if (!(object instanceof IJsonAdapter)) {
            throw new UnsupportedOperationException();
        }
        IJsonAdapter adapter = (IJsonAdapter)object;
        if (json == null) {
            return Optional.empty();
        }
        int[] value = new int[json.size()];
        for (int i = 0; i < json.size(); ++i) {
            value[i] = adapter.readJson(json.get(i), null).orElse(0);
        }
        return Optional.of(value);
    }
}

