/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.basic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.item.crystal.data.adapter.ISimpleAdapter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class StringAdapter
implements ISimpleAdapter<String, Tag, JsonElement> {
    private final Charset charset;
    private final boolean nullable;

    public StringAdapter(Charset charset, boolean nullable) {
        this.charset = charset;
        this.nullable = nullable;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public StringAdapter asNullable() {
        return new StringAdapter(this.charset, true);
    }

    @Override
    public void writeBits(@Nullable String value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeString(value, this.charset);
        }
    }

    @Override
    public Optional<String> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(buffer.readString(this.charset));
    }

    @Override
    public void writeBytes(@Nullable String value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            byte[] bytes = value.getBytes(this.charset);
            Adapters.INT_SEGMENTED_7.writeBytes(bytes.length, buffer);
            buffer.writeBytes(bytes);
        }
    }

    @Override
    public Optional<String> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        byte[] bytes = new byte[((Integer)Adapters.INT_SEGMENTED_7.readBytes(buffer).orElseThrow()).intValue()];
        buffer.readBytes(bytes);
        return Optional.of(new String(bytes, this.charset));
    }

    @Override
    public void writeData(@Nullable String value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            byte[] bytes = value.getBytes(this.charset);
            Adapters.INT_SEGMENTED_7.writeData(bytes.length, data);
            for (byte b : bytes) {
                data.writeByte(b);
            }
        }
    }

    @Override
    public Optional<String> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        byte[] bytes = new byte[((Integer)Adapters.INT_SEGMENTED_7.readData(data).orElseThrow()).intValue()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = data.readByte();
        }
        return Optional.of(new String(bytes, this.charset));
    }

    @Override
    public Optional<Tag> writeNbt(@Nullable String value) {
        return value == null ? Optional.empty() : Optional.of(StringTag.m_129297_((String)value));
    }

    @Override
    public Optional<String> readNbt(@Nullable Tag nbt) {
        if (nbt instanceof StringTag) {
            StringTag string = (StringTag)nbt;
            return Optional.of(string.m_7916_());
        }
        return Optional.empty();
    }

    @Override
    public Optional<JsonElement> writeJson(@Nullable String value) {
        return value == null ? Optional.empty() : Optional.of(new JsonPrimitive(value));
    }

    @Override
    public Optional<String> readJson(@Nullable JsonElement json) {
        JsonArray array;
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readJson(array.get(0));
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            return Optional.of(primitive.getAsString());
        }
        return Optional.empty();
    }
}

